/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.JosmUserIdentityManager;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.date.DateUtils;

public class ChangesetQuery {
    public static final int MAX_CHANGESETS_NUMBER = 100;
    private Integer uid;
    private String userName;
    private Bounds bounds;
    private Date closedAfter;
    private Date createdBefore;
    private Boolean open;
    private Boolean closed;
    private Collection<Long> changesetIds;

    public static ChangesetQuery buildFromUrlQuery(String string) throws ChangesetQueryUrlException {
        return new ChangesetQueryUrlParser().parse(string);
    }

    public static ChangesetQuery forCurrentUser() {
        JosmUserIdentityManager josmUserIdentityManager = JosmUserIdentityManager.getInstance();
        if (josmUserIdentityManager.isAnonymous()) {
            throw new IllegalStateException("anonymous user");
        }
        ChangesetQuery changesetQuery = new ChangesetQuery();
        if (josmUserIdentityManager.isFullyIdentified()) {
            return changesetQuery.forUser(josmUserIdentityManager.getUserId());
        }
        return changesetQuery.forUser(josmUserIdentityManager.getUserName());
    }

    public ChangesetQuery forUser(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' > 0 expected. Got ''{1}''.", "uid", n));
        }
        this.uid = n;
        this.userName = null;
        return this;
    }

    public ChangesetQuery forUser(String string) {
        CheckParameterUtil.ensureParameterNotNull(string, "username");
        this.userName = string;
        this.uid = null;
        return this;
    }

    public boolean isRestrictedToPartiallyIdentifiedUser() {
        return this.userName != null;
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean isRestrictedToFullyIdentifiedUser() {
        return this.uid > 0;
    }

    public ChangesetQuery inBbox(double d, double d2, double d3, double d4) {
        if (!LatLon.isValidLon(d)) {
            throw new IllegalArgumentException(I18n.tr("Illegal longitude value for parameter ''{0}'', got {1}", "minLon", d));
        }
        if (!LatLon.isValidLon(d3)) {
            throw new IllegalArgumentException(I18n.tr("Illegal longitude value for parameter ''{0}'', got {1}", "maxLon", d3));
        }
        if (!LatLon.isValidLat(d2)) {
            throw new IllegalArgumentException(I18n.tr("Illegal latitude value for parameter ''{0}'', got {1}", "minLat", d2));
        }
        if (!LatLon.isValidLat(d4)) {
            throw new IllegalArgumentException(I18n.tr("Illegal longitude value for parameter ''{0}'', got {1}", "maxLat", d4));
        }
        return this.inBbox(new LatLon(d, d2), new LatLon(d3, d4));
    }

    public ChangesetQuery inBbox(LatLon latLon, LatLon latLon2) {
        CheckParameterUtil.ensureParameterNotNull(latLon, "min");
        CheckParameterUtil.ensureParameterNotNull(latLon2, "max");
        this.bounds = new Bounds(latLon, latLon2);
        return this;
    }

    public ChangesetQuery inBbox(Bounds bounds) {
        CheckParameterUtil.ensureParameterNotNull(bounds, "bbox");
        this.bounds = bounds;
        return this;
    }

    public ChangesetQuery closedAfter(Date date) {
        CheckParameterUtil.ensureParameterNotNull(date, "d");
        this.closedAfter = DateUtils.cloneDate(date);
        return this;
    }

    public ChangesetQuery closedAfterAndCreatedBefore(Date date, Date date2) {
        CheckParameterUtil.ensureParameterNotNull(date, "closedAfter");
        CheckParameterUtil.ensureParameterNotNull(date2, "createdBefore");
        this.closedAfter = DateUtils.cloneDate(date);
        this.createdBefore = DateUtils.cloneDate(date2);
        return this;
    }

    public ChangesetQuery beingOpen(boolean bl) {
        this.open = bl;
        return this;
    }

    public ChangesetQuery beingClosed(boolean bl) {
        this.closed = bl;
        return this;
    }

    public ChangesetQuery forChangesetIds(Collection<Long> collection) {
        CheckParameterUtil.ensureParameterNotNull(collection, "changesetIds");
        if (collection.size() > 100) {
            Main.warn("Changeset query built with more than 100 changeset ids (" + collection.size() + ')');
        }
        this.changesetIds = collection;
        return this;
    }

    public String getQueryString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.uid != null) {
            stringBuilder.append("user=").append(this.uid);
        } else if (this.userName != null) {
            stringBuilder.append("display_name=").append(Utils.encodeUrl(this.userName));
        }
        if (this.bounds != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('&');
            }
            stringBuilder.append("bbox=").append(this.bounds.encodeAsString(","));
        }
        if (this.closedAfter != null && this.createdBefore != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('&');
            }
            SimpleDateFormat simpleDateFormat = DateUtils.newIsoDateTimeFormat();
            stringBuilder.append("time=").append(simpleDateFormat.format(this.closedAfter));
            stringBuilder.append(',').append(simpleDateFormat.format(this.createdBefore));
        } else if (this.closedAfter != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('&');
            }
            SimpleDateFormat simpleDateFormat = DateUtils.newIsoDateTimeFormat();
            stringBuilder.append("time=").append(simpleDateFormat.format(this.closedAfter));
        }
        if (this.open != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('&');
            }
            stringBuilder.append("open=").append(Boolean.toString(this.open));
        } else if (this.closed != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('&');
            }
            stringBuilder.append("closed=").append(Boolean.toString(this.closed));
        } else if (this.changesetIds != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('&');
            }
            stringBuilder.append("changesets=").append(Utils.join(",", this.changesetIds));
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.getQueryString();
    }

    public static class ChangesetQueryUrlParser {
        protected int parseUid(String string) throws ChangesetQueryUrlException {
            int n;
            if (string == null || string.trim().isEmpty()) {
                throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", "uid", string));
            }
            try {
                n = Integer.parseInt(string);
                if (n <= 0) {
                    throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", "uid", string));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", "uid", string), numberFormatException);
            }
            return n;
        }

        protected boolean parseBoolean(String string, String string2) throws ChangesetQueryUrlException {
            if (string == null || string.trim().isEmpty()) {
                throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", string2, string));
            }
            switch (string) {
                case "true": {
                    return true;
                }
                case "false": {
                    return false;
                }
            }
            throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", string2, string));
        }

        protected Date parseDate(String string, String string2) throws ChangesetQueryUrlException {
            if (string == null || string.trim().isEmpty()) {
                throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", string2, string));
            }
            SimpleDateFormat simpleDateFormat = DateUtils.newIsoDateTimeFormat();
            try {
                return simpleDateFormat.parse(string);
            }
            catch (ParseException parseException) {
                throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", string2, string), parseException);
            }
        }

        protected Date[] parseTime(String string) throws ChangesetQueryUrlException {
            String[] stringArray = string.split(",");
            if (stringArray.length == 0 || stringArray.length > 2) {
                throw new ChangesetQueryUrlException(I18n.tr("Unexpected value for ''{0}'' in changeset query url, got {1}", "time", string));
            }
            if (stringArray.length == 1) {
                return new Date[]{this.parseDate(stringArray[0], "time")};
            }
            if (stringArray.length == 2) {
                return new Date[]{this.parseDate(stringArray[0], "time"), this.parseDate(stringArray[1], "time")};
            }
            return new Date[0];
        }

        protected Collection<Long> parseLongs(String string) {
            if (string == null || string.isEmpty()) {
                return Collections.emptySet();
            }
            return Stream.of(string.split(",")).map(Long::valueOf).collect(Collectors.toSet());
        }

        protected ChangesetQuery createFromMap(Map<String, String> map) throws ChangesetQueryUrlException {
            ChangesetQuery changesetQuery = new ChangesetQuery();
            block26: for (Map.Entry<String, String> entry : map.entrySet()) {
                String string;
                switch (string = entry.getKey()) {
                    case "uid": {
                        if (map.containsKey("display_name")) {
                            throw new ChangesetQueryUrlException(I18n.tr("Cannot create a changeset query including both the query parameters ''uid'' and ''display_name''", new Object[0]));
                        }
                        changesetQuery.forUser(this.parseUid(map.get("uid")));
                        continue block26;
                    }
                    case "display_name": {
                        if (map.containsKey("uid")) {
                            throw new ChangesetQueryUrlException(I18n.tr("Cannot create a changeset query including both the query parameters ''uid'' and ''display_name''", new Object[0]));
                        }
                        changesetQuery.forUser(map.get("display_name"));
                        continue block26;
                    }
                    case "open": {
                        changesetQuery.beingOpen(this.parseBoolean(entry.getValue(), "open"));
                        continue block26;
                    }
                    case "closed": {
                        changesetQuery.beingClosed(this.parseBoolean(entry.getValue(), "closed"));
                        continue block26;
                    }
                    case "time": {
                        Date[] dateArray = this.parseTime(entry.getValue());
                        switch (dateArray.length) {
                            case 1: {
                                changesetQuery.closedAfter(dateArray[0]);
                                continue block26;
                            }
                            case 2: {
                                changesetQuery.closedAfterAndCreatedBefore(dateArray[0], dateArray[1]);
                                continue block26;
                            }
                        }
                        Main.warn("Unable to parse time: " + entry.getValue());
                        continue block26;
                    }
                    case "bbox": {
                        try {
                            changesetQuery.inBbox(new Bounds(entry.getValue(), ","));
                            continue block26;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw new ChangesetQueryUrlException(illegalArgumentException);
                        }
                    }
                    case "changesets": {
                        try {
                            changesetQuery.forChangesetIds(this.parseLongs(entry.getValue()));
                            continue block26;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new ChangesetQueryUrlException(numberFormatException);
                        }
                    }
                }
                throw new ChangesetQueryUrlException(I18n.tr("Unsupported parameter ''{0}'' in changeset query string", string));
            }
            return changesetQuery;
        }

        protected Map<String, String> createMapFromQueryString(String string) {
            String[] stringArray;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (String string2 : stringArray = string.split("&")) {
                String[] stringArray2 = string2.split("=");
                hashMap.put(stringArray2[0], stringArray2.length > 1 ? stringArray2[1] : "");
            }
            return hashMap;
        }

        public ChangesetQuery parse(String string) throws ChangesetQueryUrlException {
            if (string == null) {
                return new ChangesetQuery();
            }
            String string2 = string.trim();
            if (string2.isEmpty()) {
                return new ChangesetQuery();
            }
            return this.createFromMap(this.createMapFromQueryString(string2));
        }
    }

    public static class ChangesetQueryUrlException
    extends Exception {
        public ChangesetQueryUrlException(String string) {
            super(string);
        }

        public ChangesetQueryUrlException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public ChangesetQueryUrlException(Throwable throwable) {
            super(throwable);
        }
    }
}

