/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.server.ProxyPreferencesPanel;
import org.openstreetmap.josm.tools.I18n;

public class DefaultProxySelector
extends ProxySelector {
    private static final List<Proxy> NO_PROXY_LIST = Collections.singletonList(Proxy.NO_PROXY);
    private static final String IPV4_LOOPBACK = "127.0.0.1";
    private static final String IPV6_LOOPBACK = "::1";
    private static boolean jvmWillUseSystemProxies;
    private ProxyPreferencesPanel.ProxyPolicy proxyPolicy;
    private InetSocketAddress httpProxySocketAddress;
    private InetSocketAddress socksProxySocketAddress;
    private final ProxySelector delegate;
    private final Set<String> errorResources = new HashSet<String>();
    private final Set<String> errorMessages = new HashSet<String>();
    private Set<String> proxyExceptions;

    public static boolean willJvmRetrieveSystemProxies() {
        return jvmWillUseSystemProxies;
    }

    public DefaultProxySelector(ProxySelector proxySelector) {
        this.delegate = proxySelector;
        this.initFromPreferences();
    }

    protected int parseProxyPortValue(String string, String string2) {
        if (string2 == null) {
            return 0;
        }
        int n = 0;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            Main.error(I18n.tr("Unexpected format for port number in preference ''{0}''. Got ''{1}''.", string, string2));
            Main.error(I18n.tr("The proxy will not be used.", new Object[0]));
            return 0;
        }
        if (n <= 0 || n > 65535) {
            Main.error(I18n.tr("Illegal port number in preference ''{0}''. Got {1}.", string, n));
            Main.error(I18n.tr("The proxy will not be used.", new Object[0]));
            return 0;
        }
        return n;
    }

    public final void initFromPreferences() {
        String string = Main.pref.get("proxy.policy");
        if (string.isEmpty()) {
            this.proxyPolicy = ProxyPreferencesPanel.ProxyPolicy.NO_PROXY;
        } else {
            this.proxyPolicy = ProxyPreferencesPanel.ProxyPolicy.fromName(string);
            if (this.proxyPolicy == null) {
                Main.warn(I18n.tr("Unexpected value for preference ''{0}'' found. Got ''{1}''. Will use no proxy.", "proxy.policy", string));
                this.proxyPolicy = ProxyPreferencesPanel.ProxyPolicy.NO_PROXY;
            }
        }
        String string2 = Main.pref.get("proxy.http.host", null);
        int n = this.parseProxyPortValue("proxy.http.port", Main.pref.get("proxy.http.port", null));
        this.httpProxySocketAddress = null;
        if (this.proxyPolicy.equals((Object)ProxyPreferencesPanel.ProxyPolicy.USE_HTTP_PROXY)) {
            if (string2 != null && !string2.trim().isEmpty() && n > 0) {
                this.httpProxySocketAddress = new InetSocketAddress(string2, n);
            } else {
                Main.warn(I18n.tr("Unexpected parameters for HTTP proxy. Got host ''{0}'' and port ''{1}''.", string2, n));
                Main.warn(I18n.tr("The proxy will not be used.", new Object[0]));
            }
        }
        string2 = Main.pref.get("proxy.socks.host", null);
        n = this.parseProxyPortValue("proxy.socks.port", Main.pref.get("proxy.socks.port", null));
        this.socksProxySocketAddress = null;
        if (this.proxyPolicy.equals((Object)ProxyPreferencesPanel.ProxyPolicy.USE_SOCKS_PROXY)) {
            if (string2 != null && !string2.trim().isEmpty() && n > 0) {
                this.socksProxySocketAddress = new InetSocketAddress(string2, n);
            } else {
                Main.warn(I18n.tr("Unexpected parameters for SOCKS proxy. Got host ''{0}'' and port ''{1}''.", string2, n));
                Main.warn(I18n.tr("The proxy will not be used.", new Object[0]));
            }
        }
        this.proxyExceptions = new HashSet<String>(Main.pref.getCollection("proxy.exceptions", Arrays.asList("localhost", IPV4_LOOPBACK, IPV6_LOOPBACK)));
    }

    @Override
    public void connectFailed(URI uRI, SocketAddress socketAddress, IOException iOException) {
        Main.error(I18n.tr("Connection to proxy ''{0}'' for URI ''{1}'' failed. Exception was: {2}", socketAddress.toString(), uRI.toString(), iOException.toString()));
        this.errorResources.add(uRI.toString());
        this.errorMessages.add(iOException.toString());
    }

    public final Set<String> getErrorResources() {
        return new TreeSet<String>(this.errorResources);
    }

    public final Set<String> getErrorMessages() {
        return new TreeSet<String>(this.errorMessages);
    }

    public final void clearErrors() {
        this.errorResources.clear();
        this.errorMessages.clear();
    }

    public final boolean hasErrors() {
        return !this.errorResources.isEmpty();
    }

    @Override
    public List<Proxy> select(URI uRI) {
        if (uRI != null && this.proxyExceptions.contains(uRI.getHost())) {
            return NO_PROXY_LIST;
        }
        switch (this.proxyPolicy) {
            case USE_SYSTEM_SETTINGS: {
                if (!jvmWillUseSystemProxies) {
                    Main.warn(I18n.tr("The JVM is not configured to lookup proxies from the system settings. The property ''java.net.useSystemProxies'' was missing at startup time.  Will not use a proxy.", new Object[0]));
                    return NO_PROXY_LIST;
                }
                return this.delegate.select(uRI);
            }
            case NO_PROXY: {
                return NO_PROXY_LIST;
            }
            case USE_HTTP_PROXY: {
                if (this.httpProxySocketAddress == null) {
                    return NO_PROXY_LIST;
                }
                return Collections.singletonList(new Proxy(Proxy.Type.HTTP, this.httpProxySocketAddress));
            }
            case USE_SOCKS_PROXY: {
                if (this.socksProxySocketAddress == null) {
                    return NO_PROXY_LIST;
                }
                return Collections.singletonList(new Proxy(Proxy.Type.SOCKS, this.socksProxySocketAddress));
            }
        }
        return null;
    }

    static {
        String string = System.getProperty("java.net.useSystemProxies");
        if (string != null && string.equals(Boolean.TRUE.toString())) {
            jvmWillUseSystemProxies = true;
        }
    }
}

