/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.session;

import java.awt.GraphicsEnvironment;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.ViewportData;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.session.GeoImageSessionImporter;
import org.openstreetmap.josm.io.session.GpxTracksSessionImporter;
import org.openstreetmap.josm.io.session.ImagerySessionImporter;
import org.openstreetmap.josm.io.session.MarkerSessionImporter;
import org.openstreetmap.josm.io.session.NoteSessionImporter;
import org.openstreetmap.josm.io.session.OsmDataSessionImporter;
import org.openstreetmap.josm.io.session.SessionLayerImporter;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SessionReader {
    private static final Map<String, Class<? extends SessionLayerImporter>> sessionLayerImporters = new HashMap<String, Class<? extends SessionLayerImporter>>();
    private URI sessionFileURI;
    private boolean zip;
    private ZipFile zipFile;
    private List<Layer> layers = new ArrayList<Layer>();
    private int active = -1;
    private final List<Runnable> postLoadTasks = new ArrayList<Runnable>();
    private SessionViewportData viewport;
    private SessionProjectionChoiceData projectionChoice;

    public static void registerSessionLayerImporter(String string, Class<? extends SessionLayerImporter> clazz) {
        sessionLayerImporters.put(string, clazz);
    }

    public static SessionLayerImporter getSessionLayerImporter(String string) {
        Class<? extends SessionLayerImporter> clazz = sessionLayerImporters.get(string);
        if (clazz == null) {
            return null;
        }
        SessionLayerImporter sessionLayerImporter = null;
        try {
            sessionLayerImporter = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new JosmRuntimeException(reflectiveOperationException);
        }
        return sessionLayerImporter;
    }

    public List<Layer> getLayers() {
        return this.layers;
    }

    public Layer getActive() {
        return this.active >= 0 && this.active < this.layers.size() ? this.layers.get(this.layers.size() - 1 - this.active) : null;
    }

    public List<Runnable> getPostLoadTasks() {
        return this.postLoadTasks;
    }

    public SessionViewportData getViewport() {
        return this.viewport;
    }

    public SessionProjectionChoiceData getProjectionChoice() {
        return this.projectionChoice;
    }

    private static void error(String string) throws IllegalDataException {
        throw new IllegalDataException(string);
    }

    private void parseJos(Document document, ProgressMonitor progressMonitor) throws IllegalDataException {
        Object object;
        Object object2;
        Serializable serializable;
        Object object3;
        Object object4;
        String string;
        Element element = document.getDocumentElement();
        if (!"josm-session".equals(element.getTagName())) {
            SessionReader.error(I18n.tr("Unexpected root element ''{0}'' in session file", element.getTagName()));
        }
        if (!"0.1".equals(string = element.getAttribute("version"))) {
            SessionReader.error(I18n.tr("Version ''{0}'' of session file is not supported. Expected: 0.1", string));
        }
        this.viewport = SessionReader.readViewportData(element);
        this.projectionChoice = SessionReader.readProjectionChoiceData(element);
        Element element2 = SessionReader.getElementByTagName(element, "layers");
        if (element2 == null) {
            return;
        }
        String string2 = element2.getAttribute("active");
        try {
            this.active = !string2.isEmpty() ? Integer.parseInt(string2) - 1 : -1;
        }
        catch (NumberFormatException numberFormatException) {
            Main.warn("Unsupported value for 'active' layer attribute. Ignoring it. Error was: " + numberFormatException.getMessage());
            this.active = -1;
        }
        MultiMap<Serializable, Object> multiMap = new MultiMap<Serializable, Object>();
        HashMap<Serializable, Object> hashMap = new HashMap<Serializable, Object>();
        NodeList nodeList = element2.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            object4 = nodeList.item(i);
            if (object4.getNodeType() != 1 || !"layer".equals((object3 = (Element)object4).getTagName())) continue;
            if (!object3.hasAttribute("index")) {
                SessionReader.error(I18n.tr("missing mandatory attribute ''index'' for element ''layer''", new Object[0]));
            }
            serializable = null;
            try {
                serializable = Integer.valueOf(object3.getAttribute("index"));
            }
            catch (NumberFormatException numberFormatException) {
                Main.warn(numberFormatException);
            }
            if (serializable == null) {
                SessionReader.error(I18n.tr("unexpected format of attribute ''index'' for element ''layer''", new Object[0]));
            } else if (hashMap.containsKey(serializable)) {
                SessionReader.error(I18n.tr("attribute ''index'' ({0}) for element ''layer'' must be unique", Integer.toString((Integer)serializable)));
            }
            hashMap.put(serializable, object3);
            multiMap.putVoid(serializable);
            object2 = object3.getAttribute("depends");
            if (((String)object2).isEmpty()) continue;
            for (String string3 : ((String)object2).split(",")) {
                object = null;
                try {
                    object = Integer.valueOf(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    Main.warn(numberFormatException);
                }
                if (object == null) continue;
                multiMap.put(serializable, object);
            }
        }
        List list = Utils.topologicalSort(multiMap);
        object4 = new TreeMap(Collections.reverseOrder());
        object3 = new HashMap();
        serializable = new HashMap();
        progressMonitor.setTicksCount(list.size());
        object2 = list.iterator();
        block12: while (object2.hasNext()) {
            Object object5;
            String string3;
            int n = (Integer)object2.next();
            Element element3 = (Element)hashMap.get(n);
            if (element3 == null) {
                SessionReader.error(I18n.tr("missing layer with index {0}", n));
                return;
            }
            if (!element3.hasAttribute("name")) {
                SessionReader.error(I18n.tr("missing mandatory attribute ''name'' for element ''layer''", new Object[0]));
                return;
            }
            String string4 = element3.getAttribute("name");
            serializable.put(n, string4);
            if (!element3.hasAttribute("type")) {
                SessionReader.error(I18n.tr("missing mandatory attribute ''type'' for element ''layer''", new Object[0]));
                return;
            }
            string3 = element3.getAttribute("type");
            object = SessionReader.getSessionLayerImporter(string3);
            if (object == null && !GraphicsEnvironment.isHeadless()) {
                object5 = new CancelOrContinueDialog();
                ((CancelOrContinueDialog)object5).show(I18n.tr("Unable to load layer", new Object[0]), I18n.tr("Cannot load layer of type ''{0}'' because no suitable importer was found.", string3), 2, progressMonitor);
                if (!((CancelOrContinueDialog)object5).isCancel()) continue;
                progressMonitor.cancel();
                return;
            }
            if (object != null) {
                CancelOrContinueDialog cancelOrContinueDialog;
                Object object6;
                object3.put(n, object);
                object5 = new ArrayList();
                Object object7 = multiMap.get(Integer.valueOf(n)).iterator();
                while (object7.hasNext()) {
                    int n2 = (Integer)object7.next();
                    object6 = (SessionLayerImporter)object3.get(n2);
                    if (object6 == null) {
                        cancelOrContinueDialog = new CancelOrContinueDialog();
                        cancelOrContinueDialog.show(I18n.tr("Unable to load layer", new Object[0]), I18n.tr("Cannot load layer {0} because it depends on layer {1} which has been skipped.", n, n2), 2, progressMonitor);
                        if (!cancelOrContinueDialog.isCancel()) continue block12;
                        progressMonitor.cancel();
                        return;
                    }
                    object5.add(new LayerDependency(n2, (Layer)object4.get(n2), (SessionLayerImporter)object6));
                }
                object7 = new ImportSupport(string4, n, (List<LayerDependency>)object5);
                Layer layer = null;
                object6 = null;
                try {
                    layer = object.load(element3, (ImportSupport)object7, progressMonitor.createSubTaskMonitor(1, false));
                    if (layer == null) {
                        throw new IllegalStateException("Importer " + object + " returned null for " + object7);
                    }
                }
                catch (IOException | IllegalStateException | IllegalDataException exception) {
                    object6 = exception;
                }
                if (object6 != null) {
                    Main.error((Throwable)object6);
                    if (!GraphicsEnvironment.isHeadless()) {
                        cancelOrContinueDialog = new CancelOrContinueDialog();
                        cancelOrContinueDialog.show(I18n.tr("Error loading layer", new Object[0]), I18n.tr("<html>Could not load layer {0} ''{1}''.<br>Error is:<br>{2}</html>", n, Utils.escapeReservedCharactersHTML(string4), Utils.escapeReservedCharactersHTML(((Throwable)object6).getMessage())), 0, progressMonitor);
                        if (!cancelOrContinueDialog.isCancel()) continue;
                        progressMonitor.cancel();
                        return;
                    }
                }
                object4.put(n, layer);
            }
            progressMonitor.worked(1);
        }
        this.layers = new ArrayList<Layer>();
        for (Map.Entry entry : object4.entrySet()) {
            Layer layer = (Layer)entry.getValue();
            if (layer == null) continue;
            Element element4 = (Element)hashMap.get(entry.getKey());
            if (element4.hasAttribute("visible")) {
                layer.setVisible(Boolean.parseBoolean(element4.getAttribute("visible")));
            }
            if (element4.hasAttribute("opacity")) {
                try {
                    double d = Double.parseDouble(element4.getAttribute("opacity"));
                    layer.setOpacity(d);
                }
                catch (NumberFormatException numberFormatException) {
                    Main.warn(numberFormatException);
                }
            }
            layer.setName((String)serializable.get(entry.getKey()));
            this.layers.add(layer);
        }
    }

    private static SessionViewportData readViewportData(Element element) {
        Element element2 = SessionReader.getElementByTagName(element, "viewport");
        if (element2 == null) {
            return null;
        }
        LatLon latLon = null;
        Element element3 = SessionReader.getElementByTagName(element2, "center");
        if (element3 == null || !element3.hasAttribute("lat") || !element3.hasAttribute("lon")) {
            return null;
        }
        try {
            latLon = new LatLon(Double.parseDouble(element3.getAttribute("lat")), Double.parseDouble(element3.getAttribute("lon")));
        }
        catch (NumberFormatException numberFormatException) {
            Main.warn(numberFormatException);
        }
        if (latLon == null) {
            return null;
        }
        Element element4 = SessionReader.getElementByTagName(element2, "scale");
        if (element4 == null || !element4.hasAttribute("meter-per-pixel")) {
            return null;
        }
        try {
            double d = Double.parseDouble(element4.getAttribute("meter-per-pixel"));
            return new SessionViewportData(latLon, d);
        }
        catch (NumberFormatException numberFormatException) {
            Main.warn(numberFormatException);
            return null;
        }
    }

    private static SessionProjectionChoiceData readProjectionChoiceData(Element element) {
        Element element2 = SessionReader.getElementByTagName(element, "projection");
        if (element2 == null) {
            return null;
        }
        Element element3 = SessionReader.getElementByTagName(element2, "projection-choice");
        if (element3 == null) {
            return null;
        }
        Element element4 = SessionReader.getElementByTagName(element3, "id");
        if (element4 == null) {
            return null;
        }
        String string = element4.getTextContent();
        Element element5 = SessionReader.getElementByTagName(element3, "parameters");
        if (element5 == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        NodeList nodeList = element5.getElementsByTagName("param");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element6 = (Element)nodeList.item(i);
            arrayList.add(element6.getTextContent());
        }
        return new SessionProjectionChoiceData(string, arrayList);
    }

    public void loadSession(File file, boolean bl, ProgressMonitor progressMonitor) throws IllegalDataException, IOException {
        try (InputStream inputStream = this.createInputStream(file, bl);){
            this.loadSession(inputStream, file.toURI(), bl, progressMonitor != null ? progressMonitor : NullProgressMonitor.INSTANCE);
        }
    }

    private InputStream createInputStream(File file, boolean bl) throws IOException, IllegalDataException {
        if (bl) {
            try {
                this.zipFile = new ZipFile(file, StandardCharsets.UTF_8);
                return SessionReader.getZipInputStream(this.zipFile);
            }
            catch (ZipException zipException) {
                throw new IOException(zipException);
            }
        }
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException(fileNotFoundException);
        }
    }

    private static InputStream getZipInputStream(ZipFile zipFile) throws IOException, IllegalDataException {
        ZipEntry zipEntry = null;
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry2 = enumeration.nextElement();
            if (!Utils.hasExtension(zipEntry2.getName(), "jos")) continue;
            zipEntry = zipEntry2;
            break;
        }
        if (zipEntry == null) {
            SessionReader.error(I18n.tr("expected .jos file inside .joz archive", new Object[0]));
        }
        return zipFile.getInputStream(zipEntry);
    }

    private void loadSession(InputStream inputStream, URI uRI, boolean bl, ProgressMonitor progressMonitor) throws IOException, IllegalDataException {
        this.sessionFileURI = uRI;
        this.zip = bl;
        try {
            this.parseJos(Utils.parseSafeDOM(inputStream), progressMonitor);
        }
        catch (SAXException sAXException) {
            throw new IllegalDataException(sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(parserConfigurationException);
        }
    }

    private static Element getElementByTagName(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        return nodeList.getLength() > 0 ? (Element)nodeList.item(0) : null;
    }

    static {
        SessionReader.registerSessionLayerImporter("osm-data", OsmDataSessionImporter.class);
        SessionReader.registerSessionLayerImporter("imagery", ImagerySessionImporter.class);
        SessionReader.registerSessionLayerImporter("tracks", GpxTracksSessionImporter.class);
        SessionReader.registerSessionLayerImporter("geoimage", GeoImageSessionImporter.class);
        SessionReader.registerSessionLayerImporter("markers", MarkerSessionImporter.class);
        SessionReader.registerSessionLayerImporter("osm-notes", NoteSessionImporter.class);
    }

    private static class CancelOrContinueDialog {
        private boolean cancel;

        private CancelOrContinueDialog() {
        }

        public void show(String string, String string2, int n, ProgressMonitor progressMonitor) {
            try {
                SwingUtilities.invokeAndWait(() -> {
                    ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, string, I18n.tr("Cancel", new Object[0]), I18n.tr("Skip layer and continue", new Object[0])).setButtonIcons("cancel", "dialogs/next").setIcon(n).setContent(string2);
                    this.cancel = extendedDialog.showDialog().getValue() != 2;
                });
            }
            catch (InterruptedException | InvocationTargetException exception) {
                throw new JosmRuntimeException(exception);
            }
        }

        public boolean isCancel() {
            return this.cancel;
        }
    }

    public static class LayerDependency {
        private final Integer index;
        private final Layer layer;
        private final SessionLayerImporter importer;

        public LayerDependency(Integer n, Layer layer, SessionLayerImporter sessionLayerImporter) {
            this.index = n;
            this.layer = layer;
            this.importer = sessionLayerImporter;
        }

        public SessionLayerImporter getImporter() {
            return this.importer;
        }

        public Integer getIndex() {
            return this.index;
        }

        public Layer getLayer() {
            return this.layer;
        }
    }

    public class ImportSupport {
        private final String layerName;
        private final int layerIndex;
        private final List<LayerDependency> layerDependencies;
        private String inZipPath;

        public ImportSupport(String string, int n, List<LayerDependency> list) {
            this.layerName = string;
            this.layerIndex = n;
            this.layerDependencies = list;
        }

        public void addPostLayersTask(Runnable runnable) {
            SessionReader.this.postLoadTasks.add(runnable);
        }

        public InputStream getInputStream(String string) throws IOException {
            ZipEntry zipEntry;
            File file = this.getFile(string);
            if (file != null) {
                try {
                    return new BufferedInputStream(Compression.getUncompressedFileInputStream(file));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new IOException(I18n.tr("File ''{0}'' does not exist.", file.getPath()), fileNotFoundException);
                }
            }
            if (this.inZipPath != null && (zipEntry = SessionReader.this.zipFile.getEntry(this.inZipPath)) != null) {
                return SessionReader.this.zipFile.getInputStream(zipEntry);
            }
            throw new IOException(I18n.tr("Unable to locate file  ''{0}''.", string));
        }

        public File getFile(String string) throws IOException {
            this.inZipPath = null;
            try {
                URI uRI = new URI(string);
                if ("file".equals(uRI.getScheme())) {
                    return new File(uRI);
                }
                if (uRI.getScheme() == null) {
                    File file = new File(string);
                    if (file.isAbsolute()) {
                        return file;
                    }
                    if (this.isZip()) {
                        if (uRI.getPath().startsWith("../")) {
                            String string2 = uRI.getPath().substring(3);
                            return new File(SessionReader.this.sessionFileURI.resolve(string2));
                        }
                        this.inZipPath = string;
                        return null;
                    }
                    return new File(SessionReader.this.sessionFileURI.resolve(uRI));
                }
                throw new IOException(I18n.tr("Unsupported scheme ''{0}'' in URI ''{1}''.", uRI.getScheme(), string));
            }
            catch (IllegalArgumentException | URISyntaxException exception) {
                throw new IOException(exception);
            }
        }

        public boolean isZip() {
            return SessionReader.this.zip;
        }

        public String getLayerName() {
            return this.layerName;
        }

        public int getLayerIndex() {
            return this.layerIndex;
        }

        public List<LayerDependency> getLayerDependencies() {
            return this.layerDependencies;
        }

        public String toString() {
            return "ImportSupport [layerName=" + this.layerName + ", layerIndex=" + this.layerIndex + ", layerDependencies=" + this.layerDependencies + ", inZipPath=" + this.inZipPath + ']';
        }
    }

    public static class SessionViewportData {
        private final LatLon center;
        private final double meterPerPixel;

        public SessionViewportData(LatLon latLon, double d) {
            CheckParameterUtil.ensureParameterNotNull(latLon);
            this.center = latLon;
            this.meterPerPixel = d;
        }

        public LatLon getCenter() {
            return this.center;
        }

        public double getScale() {
            return this.meterPerPixel;
        }

        public ViewportData getEastNorthViewport(Projection projection) {
            EastNorth eastNorth = projection.latlon2eastNorth(this.center);
            double d = 0.01 * projection.getDefaultZoomInPPD();
            LatLon latLon = projection.eastNorth2latlon(new EastNorth(eastNorth.east() - d, eastNorth.north()));
            LatLon latLon2 = projection.eastNorth2latlon(new EastNorth(eastNorth.east() + d, eastNorth.north()));
            double d2 = latLon.greatCircleDistance(latLon2) / d / 2.0;
            double d3 = this.meterPerPixel / d2;
            return new ViewportData(eastNorth, d3);
        }
    }

    public static class SessionProjectionChoiceData {
        private final String projectionChoiceId;
        private final Collection<String> subPreferences;

        public SessionProjectionChoiceData(String string, Collection<String> collection) {
            this.projectionChoiceId = string;
            this.subPreferences = collection;
        }

        public String getProjectionChoiceId() {
            return this.projectionChoiceId;
        }

        public Collection<String> getSubPreferences() {
            return this.subPreferences;
        }
    }
}

