/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import org.openstreetmap.josm.tools.Utils;

public final class ColorScale {
    private double min;
    private double max;
    private Color noDataColor;
    private Color belowMinColor;
    private Color aboveMaxColor;
    private Color[] colors;
    private String title = "";
    private int intervalCount = 5;

    private ColorScale() {
    }

    public static ColorScale createHSBScale(int n) {
        ColorScale colorScale = new ColorScale();
        colorScale.colors = new Color[n];
        for (int i = 0; i < n; ++i) {
            colorScale.colors[i] = Color.getHSBColor((float)i / 300.0f, 1.0f, 1.0f);
        }
        colorScale.setRange(0.0, 255.0);
        colorScale.addBounds();
        return colorScale;
    }

    public static ColorScale createCyclicScale(int n) {
        ColorScale colorScale = new ColorScale();
        int[] nArray = new int[]{0, 59, 127, 244, 360};
        int[] nArray2 = new int[]{100, 84, 99, 100};
        int[] nArray3 = new int[]{90, 93, 74, 83};
        colorScale.colors = new Color[n];
        for (int i = 0; i < colorScale.colors.length; ++i) {
            float f = (float)i / 256.0f * 4.0f;
            int n2 = (int)f;
            f -= (float)n2;
            n2 = Utils.mod(n2 + 1, 4);
            float f2 = (float)nArray[n2] * ColorScale.weighted(f) + (float)nArray[n2 + 1] * (1.0f - ColorScale.weighted(f));
            float f3 = (float)nArray2[n2] * ColorScale.weighted(f) + (float)nArray2[Utils.mod(n2 + 1, 4)] * (1.0f - ColorScale.weighted(f));
            float f4 = (float)nArray3[n2] * ColorScale.weighted(f) + (float)nArray3[Utils.mod(n2 + 1, 4)] * (1.0f - ColorScale.weighted(f));
            colorScale.colors[i] = Color.getHSBColor(f2 / 360.0f, f3 / 100.0f, f4 / 100.0f);
        }
        colorScale.setRange(0.0, Math.PI * 2);
        colorScale.addBounds();
        return colorScale;
    }

    private static float weighted(float f) {
        if ((double)f < 0.5) {
            return 1.0f - 2.0f * f * f;
        }
        return 2.0f * (1.0f - f) * (1.0f - f);
    }

    public void setRange(double d, double d2) {
        this.min = d;
        this.max = d2;
    }

    public void addBounds() {
        this.aboveMaxColor = this.colors[this.colors.length - 1];
        this.belowMinColor = this.colors[0];
    }

    public Color getColor(double d) {
        if (d < this.min) {
            return this.belowMinColor;
        }
        if (d > this.max) {
            return this.aboveMaxColor;
        }
        if (Double.isNaN(d)) {
            return this.noDataColor;
        }
        int n = this.colors.length;
        int n2 = (int)((d - this.min) * (double)this.colors.length / (this.max - this.min));
        if (n2 < this.colors.length) {
            return this.colors[n2];
        }
        return this.colors[n - 1];
    }

    public Color getColor(Number number) {
        return number == null ? this.noDataColor : this.getColor(number.doubleValue());
    }

    public Color getNoDataColor() {
        return this.noDataColor;
    }

    public void setNoDataColor(Color color) {
        this.noDataColor = color;
    }

    public ColorScale makeTransparent(int n) {
        for (int i = 0; i < this.colors.length; ++i) {
            this.colors[i] = new Color(this.colors[i].getRGB() & 0xFFFFFF | (n & 0xFF) << 24, true);
        }
        return this;
    }

    public ColorScale addTitle(String string) {
        this.title = string;
        return this;
    }

    public ColorScale setIntervalCount(int n) {
        this.intervalCount = n;
        return this;
    }

    public ColorScale makeReversed() {
        Color color;
        int n = this.colors.length;
        for (int i = 0; i < n / 2; ++i) {
            color = this.colors[i];
            this.colors[i] = this.colors[n - 1 - i];
            this.colors[n - 1 - i] = color;
        }
        color = this.belowMinColor;
        this.belowMinColor = this.aboveMaxColor;
        this.aboveMaxColor = color;
        return this;
    }

    public void drawColorBar(Graphics2D graphics2D, int n, int n2, int n3, int n4, double d) {
        int n5;
        int n6 = this.colors.length;
        for (n5 = 0; n5 < n6; ++n5) {
            graphics2D.setColor(this.colors[n5]);
            if (n3 < n4) {
                graphics2D.fillRect(n, n2 + n5 * n4 / n6, n3, n4 / n6 + 1);
                continue;
            }
            graphics2D.fillRect(n + n5 * n3 / n6, n2, n3 / n6 + 1, n4);
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n7 = fontMetrics.getHeight() / 2;
        n5 = fontMetrics.stringWidth(String.valueOf(Math.max((int)Math.abs(this.max * d), (int)Math.abs(this.min * d)))) + fontMetrics.stringWidth("0.123");
        graphics2D.setColor(this.noDataColor);
        if (this.title != null) {
            graphics2D.drawString(this.title, n - n5 - 3, n2 - n7 * 3 / 2);
        }
        for (int i = 0; i <= this.intervalCount; ++i) {
            graphics2D.setColor(this.colors[(int)(1.0 * (double)i * (double)n6 / (double)this.intervalCount - 1.0E-10)]);
            double d2 = this.min + (double)i * (this.max - this.min) / (double)this.intervalCount;
            String string = String.format("%.3f", d2 * d);
            if (n3 < n4) {
                graphics2D.drawString(string, n - n5 - 3, n2 + i * n4 / this.intervalCount + n7 / 2);
                continue;
            }
            graphics2D.drawString(string, n + i * n3 / this.intervalCount - n5 / 2, n2 + n7 - 3);
        }
    }
}

