/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Desktop;
import java.awt.Image;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.UIManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.OpenFileAction;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.PlatformHook;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public class PlatformHookOsx
implements PlatformHook,
InvocationHandler {
    private static final PlatformHookOsx INVOCATION_HANDLER = new PlatformHookOsx();
    private String oSBuildNumber;

    @Override
    public void preStartupHook() {
        Utils.updateSystemProperty("apple.laf.useScreenMenuBar", "true");
        Utils.updateSystemProperty("apple.awt.application.name", "JOSM");
    }

    @Override
    public void startupHook() {
        try {
            Class<?> clazz = Class.forName("com.apple.eawt.Application");
            Class<?> clazz2 = this.findHandlerClass("QuitHandler");
            Class<?> clazz3 = this.findHandlerClass("AboutHandler");
            Class<?> clazz4 = this.findHandlerClass("OpenFilesHandler");
            Class<?> clazz5 = this.findHandlerClass("PreferencesHandler");
            Object object = Proxy.newProxyInstance(PlatformHookOsx.class.getClassLoader(), new Class[]{clazz2, clazz3, clazz4, clazz5}, (InvocationHandler)INVOCATION_HANDLER);
            Object obj = clazz.getConstructor(null).newInstance(null);
            if (Utils.getJavaVersion() >= 9) {
                this.setHandlers(Desktop.class, clazz2, clazz3, clazz4, clazz5, object, Desktop.getDesktop());
            } else {
                this.setHandlers(clazz, clazz2, clazz3, clazz4, clazz5, object, obj);
                clazz.getDeclaredMethod("setEnabledPreferencesMenu", Boolean.TYPE).invoke(obj, Boolean.TRUE);
            }
            clazz.getDeclaredMethod("setDockIconImage", Image.class).invoke(obj, ImageProvider.get("logo").getImage());
            PlatformHookOsx.enableOSXFullscreen((Window)Main.parent);
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException exception) {
            Main.warn("Failed to register with OSX: " + exception);
        }
        this.checkExpiredJava();
    }

    protected void setHandlers(Class<?> clazz, Class<?> clazz2, Class<?> clazz3, Class<?> clazz4, Class<?> clazz5, Object object, Object object2) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        clazz.getDeclaredMethod("setQuitHandler", clazz2).invoke(object2, object);
        clazz.getDeclaredMethod("setAboutHandler", clazz3).invoke(object2, object);
        clazz.getDeclaredMethod("setOpenFileHandler", clazz4).invoke(object2, object);
        clazz.getDeclaredMethod("setPreferencesHandler", clazz5).invoke(object2, object);
    }

    protected Class<?> findHandlerClass(String string) throws ClassNotFoundException {
        try {
            return Class.forName("com.apple.eawt." + string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Main.trace(classNotFoundException);
            return Class.forName("java.awt.desktop." + string);
        }
    }

    public static void enableOSXFullscreen(Window window) {
        CheckParameterUtil.ensureParameterNotNull(window, "window");
        try {
            Class<?> clazz = Class.forName("com.apple.eawt.FullScreenUtilities");
            clazz.getDeclaredMethod("setWindowCanFullScreen", Window.class, Boolean.TYPE).invoke(clazz, window, Boolean.TRUE);
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException exception) {
            Main.warn("Failed to register with OSX: " + exception);
        }
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        if (Main.isDebugEnabled()) {
            Main.debug("OSX handler: " + method.getName() + " - " + Arrays.toString(objectArray));
        }
        switch (method.getName()) {
            case "openFiles": {
                if (objectArray[0] == null) break;
                try {
                    Object object2 = objectArray[0].getClass().getMethod("getFiles", new Class[0]).invoke(objectArray[0], new Object[0]);
                    if (!(object2 instanceof List)) break;
                    Main.worker.submit(new OpenFileAction.OpenFileTask((List)object2, null){

                        @Override
                        protected void realRun() throws SAXException, IOException, OsmTransferException {
                            while (Main.parent == null || !Main.parent.isVisible()) {
                                try {
                                    Thread.sleep(25L);
                                }
                                catch (InterruptedException interruptedException) {
                                    Main.warn(interruptedException);
                                    Thread.currentThread().interrupt();
                                }
                            }
                            super.realRun();
                        }
                    });
                }
                catch (IllegalArgumentException | ReflectiveOperationException | SecurityException exception) {
                    Main.warn("Failed to access open files event: " + exception);
                }
                break;
            }
            case "handleQuitRequestWith": {
                boolean bl = Main.exitJosm(false, 0, null);
                if (objectArray[1] == null) break;
                try {
                    objectArray[1].getClass().getDeclaredMethod(bl ? "performQuit" : "cancelQuit", new Class[0]).invoke(objectArray[1], new Object[0]);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Main.debug(illegalAccessException);
                    Class.forName("java.awt.desktop.QuitResponse").getMethod(bl ? "performQuit" : "cancelQuit", new Class[0]).invoke(objectArray[1], new Object[0]);
                }
                break;
            }
            case "handleAbout": {
                Main.main.menu.about.actionPerformed(null);
                break;
            }
            case "handlePreferences": {
                Main.main.menu.preferences.actionPerformed(null);
                break;
            }
            default: {
                Main.warn("OSX unsupported method: " + method.getName());
            }
        }
        return null;
    }

    @Override
    public void openUrl(String string) throws IOException {
        Runtime.getRuntime().exec("open " + string);
    }

    @Override
    public void initSystemShortcuts() {
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-01", I18n.tr("reserved", new Object[0]), 32, 256));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-02", I18n.tr("reserved", new Object[0]), 32, 320));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-03", I18n.tr("reserved", new Object[0]), 32, 768));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-04", I18n.tr("reserved", new Object[0]), 32, 384));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-05", I18n.tr("reserved", new Object[0]), 9, 64));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-06", I18n.tr("reserved", new Object[0]), 9, 256));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-07", I18n.tr("reserved", new Object[0]), 9, 320));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-08", I18n.tr("reserved", new Object[0]), 9, 128));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-09", I18n.tr("reserved", new Object[0]), 9, 192));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-10", I18n.tr("reserved", new Object[0]), 27, 256));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-11", I18n.tr("reserved", new Object[0]), 27, 768));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-12", I18n.tr("reserved", new Object[0]), 112, 128));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-13", I18n.tr("reserved", new Object[0]), 113, 128));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-14", I18n.tr("reserved", new Object[0]), 114, 128));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-15", I18n.tr("reserved", new Object[0]), 115, 128));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-16", I18n.tr("reserved", new Object[0]), 115, 192));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-17", I18n.tr("reserved", new Object[0]), 116, 128));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-18", I18n.tr("reserved", new Object[0]), 116, 256));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-19", I18n.tr("reserved", new Object[0]), 117, 128));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-20", I18n.tr("reserved", new Object[0]), 117, 192));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-21", I18n.tr("reserved", new Object[0]), 118, 128));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-26", I18n.tr("reserved", new Object[0]), 128, 256));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-27", I18n.tr("reserved", new Object[0]), 128, 320));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-28", I18n.tr("reserved", new Object[0]), 128, 768));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-30", I18n.tr("reserved", new Object[0]), 45, 768));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("system:preferences", I18n.tr("reserved", new Object[0]), 44, 256));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-31", I18n.tr("reserved", new Object[0]), 44, 832));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-32", I18n.tr("reserved", new Object[0]), 46, 832));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-33", I18n.tr("reserved", new Object[0]), 47, 768));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-34", I18n.tr("reserved", new Object[0]), 61, 320));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-35", I18n.tr("reserved", new Object[0]), 61, 768));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-36", I18n.tr("reserved", new Object[0]), 51, 320));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-37", I18n.tr("reserved", new Object[0]), 51, 448));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-38", I18n.tr("reserved", new Object[0]), 52, 320));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-39", I18n.tr("reserved", new Object[0]), 52, 448));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-40", I18n.tr("reserved", new Object[0]), 56, 768));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-41", I18n.tr("reserved", new Object[0]), 56, 896));
        Shortcut.registerSystemShortcut("system:selectall", I18n.tr("reserved", new Object[0]), 65, 256);
        Shortcut.registerSystemShortcut("system:copy", I18n.tr("reserved", new Object[0]), 67, 256);
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-42", I18n.tr("reserved", new Object[0]), 68, 768));
        Shortcut.registerSystemShortcut("system:dictionarylookup", I18n.tr("reserved", new Object[0]), 68, 384);
        Shortcut.registerSystemShortcut("system:find", I18n.tr("reserved", new Object[0]), 70, 256);
        Shortcut.registerSystemShortcut("system:search", I18n.tr("reserved", new Object[0]), 70, 768);
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("system:hide", I18n.tr("reserved", new Object[0]), 72, 256));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("system:hideothers", I18n.tr("reserved", new Object[0]), 72, 768));
        Shortcut.registerSystemShortcut("system:new", I18n.tr("reserved", new Object[0]), 78, 256);
        Shortcut.registerSystemShortcut("system:open", I18n.tr("reserved", new Object[0]), 79, 256);
        Shortcut.registerSystemShortcut("system:print", I18n.tr("reserved", new Object[0]), 80, 256);
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("system:menuexit", I18n.tr("reserved", new Object[0]), 81, 256));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-43", I18n.tr("reserved", new Object[0]), 81, 320));
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-44", I18n.tr("reserved", new Object[0]), 81, 832));
        Shortcut.registerSystemShortcut("system:save", I18n.tr("reserved", new Object[0]), 83, 256);
        Shortcut.registerSystemShortcut("system:saveas", I18n.tr("reserved", new Object[0]), 83, 320);
        Shortcut.registerSystemShortcut("system:toggletoolbar", I18n.tr("reserved", new Object[0]), 84, 768);
        Shortcut.registerSystemShortcut("system:paste", I18n.tr("reserved", new Object[0]), 86, 256);
        Shortcut.registerSystemShortcut("system:closefile", I18n.tr("reserved", new Object[0]), 87, 320);
        Shortcut.registerSystemShortcut("system:closeallwindows", I18n.tr("reserved", new Object[0]), 87, 768);
        Shortcut.registerSystemShortcut("system:cut", I18n.tr("reserved", new Object[0]), 88, 256);
        Shortcut.registerSystemShortcut("system:undo", I18n.tr("reserved", new Object[0]), 90, 256);
        Shortcut.registerSystemShortcut("system:redo", I18n.tr("reserved", new Object[0]), 90, 320);
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-45", I18n.tr("reserved", new Object[0]), 39, 256));
        Shortcut.registerSystemShortcut("system:movefocusright", I18n.tr("reserved", new Object[0]), 39, 128);
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("apple-reserved-49", I18n.tr("reserved", new Object[0]), 37, 256));
        Shortcut.registerSystemShortcut("system:movefocusleft", I18n.tr("reserved", new Object[0]), 37, 128);
        Shortcut.registerSystemShortcut("system:movefocusup", I18n.tr("reserved", new Object[0]), 38, 128);
        Shortcut.registerSystemShortcut("system:movefocusdown", I18n.tr("reserved", new Object[0]), 40, 128);
        PlatformHookOsx.auto(Shortcut.registerSystemShortcut("system:about", I18n.tr("reserved", new Object[0]), 0, -1));
        Shortcut.registerSystemShortcut("view:zoomin", I18n.tr("reserved", new Object[0]), 107, 256);
        Shortcut.registerSystemShortcut("view:zoomout", I18n.tr("reserved", new Object[0]), 109, 256);
    }

    private static void auto(Shortcut shortcut) {
        if (shortcut != null) {
            shortcut.setAutomatic();
        }
    }

    @Override
    public String makeTooltip(String string, Shortcut shortcut) {
        String string2 = UIManager.getLookAndFeel().getID();
        boolean bl = true;
        if (string2.contains("Mac") || string2.contains("Aqua")) {
            bl = false;
        }
        StringBuilder stringBuilder = new StringBuilder(48);
        if (bl) {
            stringBuilder.append("<html>");
        }
        stringBuilder.append(string);
        if (shortcut != null && !shortcut.getKeyText().isEmpty()) {
            stringBuilder.append(' ');
            if (bl) {
                stringBuilder.append("<font size='-2'>");
            }
            stringBuilder.append('(').append(shortcut.getKeyText()).append(')');
            if (bl) {
                stringBuilder.append("</font>");
            }
        }
        if (bl) {
            stringBuilder.append("&nbsp;</html>");
        }
        return stringBuilder.toString();
    }

    @Override
    public String getDefaultStyle() {
        return "com.apple.laf.AquaLookAndFeel";
    }

    @Override
    public boolean canFullscreen() {
        return false;
    }

    @Override
    public String getOSDescription() {
        return System.getProperty("os.name") + ' ' + System.getProperty("os.version");
    }

    private String buildOSBuildNumber() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            stringBuilder.append(this.exec("sw_vers", "-productName")).append(' ').append(this.exec("sw_vers", "-productVersion")).append(" (").append(this.exec("sw_vers", "-buildVersion")).append(')');
        }
        catch (IOException iOException) {
            Main.error(iOException);
        }
        return stringBuilder.toString();
    }

    @Override
    public String getOSBuildNumber() {
        if (this.oSBuildNumber == null) {
            this.oSBuildNumber = this.buildOSBuildNumber();
        }
        return this.oSBuildNumber;
    }

    @Override
    public File getDefaultCacheDirectory() {
        return new File(System.getProperty("user.home") + "/Library/Caches", Main.pref.getJOSMDirectoryBaseName());
    }

    @Override
    public File getDefaultPrefDirectory() {
        return new File(System.getProperty("user.home") + "/Library/Preferences", Main.pref.getJOSMDirectoryBaseName());
    }

    @Override
    public File getDefaultUserDataDirectory() {
        return new File(System.getProperty("user.home") + "/Library", Main.pref.getJOSMDirectoryBaseName());
    }

    @Override
    public List<File> getDefaultProj4NadshiftDirectories() {
        return Collections.emptyList();
    }
}

