/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageAccessibilityStatementElement
extends CompositeElement {
    public PackageAccessibilityStatementElement(@NotNull IElementType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/PackageAccessibilityStatementElement", "<init>"));
        }
        super(type2);
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/impl/source/PackageAccessibilityStatementElement", "deleteChildInternal"));
        }
        if (child.getElementType() == JavaElementType.MODULE_REFERENCE) {
            ASTNode comma = PackageAccessibilityStatementElement.findNearestComma(child);
            if (comma != null) {
                super.deleteChildInternal(comma);
            } else {
                ASTNode toKeyword = this.findChildByType(JavaTokenType.TO_KEYWORD);
                if (toKeyword != null) {
                    super.deleteChildInternal(toKeyword);
                }
            }
        }
        super.deleteChildInternal(child);
    }

    @Nullable
    private static ASTNode findNearestComma(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/psi/impl/source/PackageAccessibilityStatementElement", "findNearestComma"));
        }
        ASTNode next = PsiImplUtil.skipWhitespaceAndComments(child.getTreeNext());
        if (next != null && next.getElementType() == JavaTokenType.COMMA) {
            return next;
        }
        ASTNode prev = PsiImplUtil.skipWhitespaceAndCommentsBack(child.getTreePrev());
        if (prev != null && prev.getElementType() == JavaTokenType.COMMA) {
            return prev;
        }
        return null;
    }
}

