/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.text.CharSequenceWithStringHash;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceBackedByArray;
import org.jetbrains.annotations.NotNull;

public class CharArrayCharSequence
implements CharSequenceWithStringHash,
CharSequenceBackedByArray {
    protected final char[] myChars;
    protected final int myStart;
    protected final int myEnd;
    private transient int hash;

    public CharArrayCharSequence(char ... chars) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/util/text/CharArrayCharSequence", "<init>"));
        }
        this(chars, 0, chars.length);
    }

    public CharArrayCharSequence(@NotNull char[] chars, int start, int end) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/util/text/CharArrayCharSequence", "<init>"));
        }
        if (start < 0 || end > chars.length || start > end) {
            throw new IndexOutOfBoundsException("chars.length:" + chars.length + ", start:" + start + ", end:" + end);
        }
        this.myChars = chars;
        this.myStart = start;
        this.myEnd = end;
    }

    @Override
    public final int length() {
        return this.myEnd - this.myStart;
    }

    @Override
    public final char charAt(int index2) {
        return this.myChars[index2 + this.myStart];
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        CharArrayCharSequence charArrayCharSequence = start == 0 && end == this.length() ? this : new CharArrayCharSequence(this.myChars, this.myStart + start, this.myStart + end);
        if (charArrayCharSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/CharArrayCharSequence", "subSequence"));
        }
        return charArrayCharSequence;
    }

    @Override
    @NotNull
    public String toString() {
        String string = new String(this.myChars, this.myStart, this.myEnd - this.myStart);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/CharArrayCharSequence", "toString"));
        }
        return string;
    }

    @Override
    @NotNull
    public char[] getChars() {
        if (this.myStart == 0) {
            if (this.myChars == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/CharArrayCharSequence", "getChars"));
            }
            return this.myChars;
        }
        char[] chars = new char[this.length()];
        this.getChars(chars, 0);
        if (chars == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/CharArrayCharSequence", "getChars"));
        }
        return chars;
    }

    @Override
    public void getChars(@NotNull char[] dst, int dstOffset) {
        if (dst == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dst", "com/intellij/util/text/CharArrayCharSequence", "getChars"));
        }
        System.arraycopy(this.myChars, this.myStart, dst, dstOffset, this.length());
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject == null || this.getClass() != anObject.getClass() || this.length() != ((CharSequence)anObject).length()) {
            return false;
        }
        return CharArrayUtil.regionMatches(this.myChars, this.myStart, this.myEnd, (CharSequence)anObject);
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = StringUtil.stringHashCode(this, 0, this.length());
        }
        return h;
    }
}

