#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: zlib
version: 0.6.1.2
id: zlib-0.6.1.2-GcLmGV5PElZD6CJvjR9umm
key: zlib-0.6.1.2-GcLmGV5PElZD6CJvjR9umm
license: BSD3
copyright: (c) 2006-2016 Duncan Coutts
maintainer: Duncan Coutts <duncan@community.haskell.org>
synopsis: Compression and decompression in the gzip and zlib formats
description:
    This package provides a pure interface for compressing and
    decompressing streams of data represented as lazy
    '\''ByteString'\''s. It uses the
    <https://en.wikipedia.org/wiki/Zlib zlib C library>
    so it has high performance. It supports the \"zlib\",
    \"gzip\" and \"raw\" compression formats.
    .
    It provides a convenient high level API suitable for most
    tasks and for the few cases where more control is needed it
    provides access to the full zlib feature set.
category: Codec
author: Duncan Coutts <duncan@community.haskell.org>
exposed: True
exposed-modules:
    Codec.Compression.GZip Codec.Compression.Zlib
    Codec.Compression.Zlib.Raw Codec.Compression.Zlib.Internal
hidden-modules: Codec.Compression.Zlib.Stream
abi: f543dc4089eb17b09132c324f61bae5a
trusted: False
import-dirs: /usr/lib/ghc-8.0.2/site-local/zlib-0.6.1.2
library-dirs: /usr/lib/ghc-8.0.2/site-local/zlib-0.6.1.2
dynamic-library-dirs: /usr/lib/arm-linux-ghc-8.0.2
data-dir: /usr/share/arm-linux-ghc-8.0.2/zlib-0.6.1.2
hs-libraries: HSzlib-0.6.1.2-GcLmGV5PElZD6CJvjR9umm
extra-libraries:
    z
includes:
    zlib.h
depends:
    base-4.9.1.0 bytestring-0.10.8.1
haddock-interfaces: /usr/share/doc/haskell-zlib/html/zlib.haddock
haddock-html: /usr/share/doc/haskell-zlib/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
