#ifndef _EFL_CANVAS_EO_H_
#define _EFL_CANVAS_EO_H_

#ifndef _EFL_CANVAS_EO_CLASS_TYPE
#define _EFL_CANVAS_EO_CLASS_TYPE

typedef Eo Efl_Canvas;

#endif

#ifndef _EFL_CANVAS_EO_TYPES
#define _EFL_CANVAS_EO_TYPES


#endif
/** Common interface for Window and some internal classes in EFL.
 *
 * @ingroup Efl_Canvas
 */
#define EFL_CANVAS_INTERFACE efl_canvas_interface_get()

EWAPI const Eo_Class *efl_canvas_interface_get(void);

/**
 * @brief This function returns the current known pointer coordinates
 *
 * This function returns the current known canvas unit coordinates of the mouse
 * pointer and sets the contents of the Evas_Coords pointed to by @c x and @c y
 * to contain these coordinates. If @c e is not a valid canvas the results of
 * this function are undefined.
 *
 * @param[out] x The pointer to hold the return value of pointer's x position.
 * @param[out] y The pointer to hold the return value of pointer's y position.
 *
 * @ingroup Efl_Canvas
 */
EOAPI void efl_canvas_pointer_canvas_xy_get(const Eo *obj, int *x, int *y);

/**
 * @brief Returns whether the mouse pointer is logically inside the canvas.
 *
 * When this function is called it will return a value of either @c false or
 * @c true, depending on if event_feed_mouse_in or event_feed_mouse_out have
 * been called to feed in a  mouse enter event into the canvas.
 *
 * A return value of @c true indicates the mouse is logically inside the
 * canvas, and @c false implies it is logically outside the canvas.
 *
 * A canvas begins with the mouse being assumed outside ($false).
 *
 * If @c e is not a valid canvas, the return value is undefined.
 *
 * @ingroup Efl_Canvas
 */
EOAPI Eina_Bool efl_canvas_pointer_inside_get(const Eo *obj);

/**
 * @brief Get the maximum image size evas can possibly handle.
 *
 * This function returns the largest image or surface size that evas can handle
 * in pixels, and if there is one, returns @c true. It returns @c false if no
 * extra constraint on maximum image size exists. You still should check the
 * return values of @c maxw and @c maxh as there may still be a limit, just a
 * much higher one.
 *
 * @param[out] maxw Pointer to hold the return value in pixels of the maximum
 * width.
 * @param[out] maxh Pointer to hold the return value in pixels of the maximum
 * height.
 *
 * @ingroup Efl_Canvas
 */
EOAPI Eina_Bool efl_canvas_image_max_size_get(const Eo *obj, int *maxw, int *maxh);

/** Call user-provided @c calculate smart functions and unset the flag
 * signalling that the object needs to get recalculated to all smart objects in
 * the canvas.
 *
 * @ingroup Efl_Canvas
 */
EOAPI void efl_canvas_smart_objects_calculate(Eo *obj);

/**
 * @brief Retrieve a list of objects lying over a given position in a canvas.
 *
 * This function will traverse all the layers of the given canvas, from top to
 * bottom, querying for objects with areas covering the given position. The
 * user can remove from query objects which are hidden and/or which are set to
 * pass events.
 *
 * @warning This function will skip objects parented by smart objects, acting
 * only on the ones at the "top level", with regard to object parenting.
 *
 * @param[in] x The horizontal coordinate of the position.
 * @param[in] y The vertical coordinate of the position.
 * @param[in] include_pass_events_objects Boolean flag to include or not
 * objects which pass events in this calculation.
 * @param[in] include_hidden_objects Boolean flag to include or not hidden
 * objects in this calculation.
 *
 * @return The list of objects that are over the given position in @c e.
 *
 * @ingroup Efl_Canvas
 */
EOAPI Eina_Iterator *efl_canvas_objects_at_xy_get(const Eo *obj, int x, int y, Eina_Bool include_pass_events_objects, Eina_Bool include_hidden_objects);

/**
 * @brief Retrieve the object stacked at the top of a given position in a
 * canvas.
 *
 * This function will traverse all the layers of the given canvas, from top to
 * bottom, querying for objects with areas covering the given position. The
 * user can remove from the query objects which are hidden and/or which are set
 * to pass events.
 *
 * @warning This function will skip objects parented by smart objects, acting
 * only on the ones at the "top level", with regard to object parenting.
 *
 * @param[in] x The horizontal coordinate of the position.
 * @param[in] y The vertical coordinate of the position.
 * @param[in] include_pass_events_objects Boolean flag to include or not
 * objects which pass events in this calculation.
 * @param[in] include_hidden_objects Boolean flag to include or not hidden
 * objects in this calculation.
 *
 * @return The Evas object that is over all other objects at the given
 * position.
 *
 * @ingroup Efl_Canvas
 */
EOAPI Efl_Gfx *efl_canvas_object_top_at_xy_get(const Eo *obj, int x, int y, Eina_Bool include_pass_events_objects, Eina_Bool include_hidden_objects);

/**
 * @brief Retrieve a list of objects lying over a given rectangular region in a
 * canvas.
 *
 * This function will traverse all the layers of the given canvas, from top to
 * bottom, querying for objects with areas overlapping with the given
 * rectangular region inside @c e. The user can remove from the query objects
 * which are hidden and/or which are set to pass events.
 *
 * @warning This function will skip objects parented by smart objects, acting
 * only on the ones at the "top level", with regard to object parenting.
 *
 * @param[in] x
 * @param[in] y
 * @param[in] w
 * @param[in] h
 * @param[in] include_pass_events_objects
 * @param[in] include_hidden_objects
 *
 * @ingroup Efl_Canvas
 */
EOAPI Eina_Iterator *efl_canvas_objects_in_rectangle_get(const Eo *obj, int x, int y, int w, int h, Eina_Bool include_pass_events_objects, Eina_Bool include_hidden_objects);

/**
 * @brief Retrieve the Evas object stacked at the top of a given rectangular
 * region in a canvas
 *
 * This function will traverse all the layers of the given canvas, from top to
 * bottom, querying for objects with areas overlapping with the given
 * rectangular region inside @c e. The user can remove from the query objects
 * which are hidden and/or which are set to pass events.
 *
 * @warning This function will skip objects parented by smart objects, acting
 * only on the ones at the "top level", with regard to object parenting.
 *
 * @param[in] x The top left corner's horizontal coordinate for the rectangular
 * region.
 * @param[in] y The top left corner's vertical coordinate for the rectangular
 * region.
 * @param[in] w The width of the rectangular region.
 * @param[in] h The height of the rectangular region.
 * @param[in] include_pass_events_objects Boolean flag to include or not
 * objects which pass events in this calculation.
 * @param[in] include_hidden_objects Boolean flag to include or not hidden
 * objects in this calculation.
 *
 * @return The object that is over all other objects at the given rectangular
 * region.
 *
 * @ingroup Efl_Canvas
 */
EOAPI Efl_Gfx *efl_canvas_object_top_in_rectangle_get(const Eo *obj, int x, int y, int w, int h, Eina_Bool include_pass_events_objects, Eina_Bool include_hidden_objects);

EOAPI extern const Eo_Event_Description _EFL_CANVAS_EVENT_FOCUS_IN;
EOAPI extern const Eo_Event_Description _EFL_CANVAS_EVENT_FOCUS_OUT;
EOAPI extern const Eo_Event_Description _EFL_CANVAS_EVENT_OBJECT_FOCUS_IN;
EOAPI extern const Eo_Event_Description _EFL_CANVAS_EVENT_OBJECT_FOCUS_OUT;
EOAPI extern const Eo_Event_Description _EFL_CANVAS_EVENT_RENDER_PRE;
EOAPI extern const Eo_Event_Description _EFL_CANVAS_EVENT_RENDER_POST;
EOAPI extern const Eo_Event_Description _EFL_CANVAS_EVENT_DEVICE_CHANGED;

/**
 * No description
 */
#define EFL_CANVAS_EVENT_FOCUS_IN (&(_EFL_CANVAS_EVENT_FOCUS_IN))

/**
 * No description
 */
#define EFL_CANVAS_EVENT_FOCUS_OUT (&(_EFL_CANVAS_EVENT_FOCUS_OUT))

/**
 * No description
 */
#define EFL_CANVAS_EVENT_OBJECT_FOCUS_IN (&(_EFL_CANVAS_EVENT_OBJECT_FOCUS_IN))

/**
 * No description
 */
#define EFL_CANVAS_EVENT_OBJECT_FOCUS_OUT (&(_EFL_CANVAS_EVENT_OBJECT_FOCUS_OUT))

/**
 * No description
 */
#define EFL_CANVAS_EVENT_RENDER_PRE (&(_EFL_CANVAS_EVENT_RENDER_PRE))

/**
 * No description
 */
#define EFL_CANVAS_EVENT_RENDER_POST (&(_EFL_CANVAS_EVENT_RENDER_POST))

/**
 * No description
 */
#define EFL_CANVAS_EVENT_DEVICE_CHANGED (&(_EFL_CANVAS_EVENT_DEVICE_CHANGED))

#endif
