#ifndef _EFL_CONTAINER_EO_H_
#define _EFL_CONTAINER_EO_H_

#ifndef _EFL_CONTAINER_EO_CLASS_TYPE
#define _EFL_CONTAINER_EO_CLASS_TYPE

typedef Eo Efl_Container;

#endif

#ifndef _EFL_CONTAINER_EO_TYPES
#define _EFL_CONTAINER_EO_TYPES


#endif
/** API common to all UI container objects.
 *
 * @ingroup Efl_Container
 */
#define EFL_CONTAINER_INTERFACE efl_container_interface_get()

EWAPI const Eo_Class *efl_container_interface_get(void);

/**
 * @brief The name of the part under which an object is swallowed.
 *
 * @param[in] content
 *
 * @ingroup Efl_Container
 */
EOAPI const char *efl_content_part_name_get(const Eo *obj, Efl_Gfx * content);

/**
 * @brief Swallowed sub-object contained in this object.
 *
 * @return the object to swallow.
 *
 * @ingroup Efl_Container
 */
EOAPI Efl_Gfx *efl_content_get(const Eo *obj);

/**
 * @brief Swallowed sub-object contained in this object.
 *
 * @param[in] content the object to swallow.
 *
 * @ingroup Efl_Container
 */
EOAPI Eina_Bool efl_content_set(Eo *obj, Efl_Gfx *content);

/** Unswallow the object in the current container and return it.
 *
 * @ingroup Efl_Container
 */
EOAPI Efl_Gfx *efl_content_unset(Eo *obj);

/**
 * @brief Unswallow an object from this container.
 *
 * @param[in] content
 *
 * @return @c false if @c content was not a child or can not be removed.
 *
 * @ingroup Efl_Container
 */
EOAPI Eina_Bool efl_content_remove(Eo *obj, Efl_Gfx *content);

/** Begin iterating over this object's contents.
 *
 * @ingroup Efl_Container
 */
EOAPI Eina_Iterator *efl_content_iterate(Eo *obj);

/** Returns the number of UI elements packed in this container.
 *
 * @ingroup Efl_Container
 */
EOAPI int efl_content_count(Eo *obj);

EOAPI extern const Eo_Event_Description _EFL_CONTAINER_EVENT_CONTENT_ADDED;
EOAPI extern const Eo_Event_Description _EFL_CONTAINER_EVENT_CONTENT_REMOVED;

/** Sent after a new item was added.
 *
 * @ingroup Efl_Container
 */
#define EFL_CONTAINER_EVENT_CONTENT_ADDED (&(_EFL_CONTAINER_EVENT_CONTENT_ADDED))

/** Sent after an item was removed, before unref.
 *
 * @ingroup Efl_Container
 */
#define EFL_CONTAINER_EVENT_CONTENT_REMOVED (&(_EFL_CONTAINER_EVENT_CONTENT_REMOVED))

#endif
