#ifndef EFL_EVENT_EO_HH
#define EFL_EVENT_EO_HH
#include <Eo.h>

extern "C" {
#include "efl_event.eo.h"
}
#include <Eina.hh>
#include <Eo.hh>
namespace efl { 
struct Event;
} 
namespace efl { namespace eo { template<> struct is_eolian_object< ::efl::Event> : ::std::true_type {}; } }

namespace eo_cxx {
namespace efl { 
struct Event {
   ::efl::eolian::return_traits<double>::type timestamp_get() const;
   ::efl::eolian::return_traits<void>::type timestamp_set( ::efl::eolian::in_traits<double>::type ms) const;
   ::efl::eolian::return_traits<void>::type reset() const;
   ::efl::eolian::return_traits< ::efl::Event>::type dup() const;
   static Eo_Class const* _eo_class()
   {
      return EFL_EVENT_INTERFACE;
   }
   Eo* _eo_ptr() const { return *(Eo**)this; }
   operator ::efl::Event() const;
   operator ::efl::Event&();
   operator ::efl::Event const&() const;
   /// @cond LOCAL
    ::efl::eolian::address_of_operator<Event> operator&() { return {this}; }
    ::efl::eolian::address_of_operator<Event const > operator&() const { return {this}; }
   /// @endcond
};
} 
}
namespace efl { 
struct Event : ::efl::eo::concrete
{
   explicit Event( ::Eo* eo)
      : ::efl::eo::concrete(eo) {}
   explicit Event(std::nullptr_t)
      : ::efl::eo::concrete(nullptr) {}
   Event(Event const& other) = default;
   Event(Event&& other) = default;
   Event& operator=(Event const& other) = default;
   Event& operator=(Event&& other) = default;
   Event()
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, ::efl::eo::concrete{nullptr}, _eo_class());
   }
   Event( ::efl::eo::concrete parent)
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, parent, _eo_class());
   }
   template <typename F> Event(F f, typename ::std::enable_if< ::efl::eolian::is_callable<F>::value>::type* = 0)
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, ::efl::eo::concrete{nullptr}, _eo_class(), f);
   }
   ::efl::eolian::return_traits<double>::type timestamp_get() const;
   ::efl::eolian::return_traits<void>::type timestamp_set( ::efl::eolian::in_traits<double>::type ms) const;
   ::efl::eolian::return_traits<void>::type reset() const;
   ::efl::eolian::return_traits< ::efl::Event>::type dup() const;
   static Eo_Class const* _eo_class()
   {
      return EFL_EVENT_INTERFACE;
   }
   Eo* _eo_ptr() const { return *(Eo**)this; }
   /// @cond LOCAL
    ::efl::eolian::address_of_operator<Event> operator&() { return {this}; }
    ::efl::eolian::address_of_operator<Event const > operator&() const { return {this}; }
   /// @endcond
};
static_assert(sizeof(Event) == sizeof(Eo*), "");
static_assert(std::is_standard_layout<Event>::value, "");
} 
#include "efl_event.eo.impl.hh"
#endif
