#include <glib-object.h>
#include <dbus/dbus-glib.h>

G_BEGIN_DECLS

/**
 * SwVideoUploadIface:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _SwVideoUploadIface SwVideoUploadIface;

/**
 * SwVideoUploadIfaceClass:
 *
 * The class of SwVideoUploadIface.
 */
typedef struct _SwVideoUploadIfaceClass SwVideoUploadIfaceClass;

GType sw_video_upload_iface_get_type (void);
#define SW_TYPE_VIDEO_UPLOAD_IFACE \
  (sw_video_upload_iface_get_type ())
#define SW_VIDEO_UPLOAD_IFACE(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), SW_TYPE_VIDEO_UPLOAD_IFACE, SwVideoUploadIface))
#define SW_IS_VIDEO_UPLOAD_IFACE(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), SW_TYPE_VIDEO_UPLOAD_IFACE))
#define SW_VIDEO_UPLOAD_IFACE_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), SW_TYPE_VIDEO_UPLOAD_IFACE, SwVideoUploadIfaceClass))


typedef void (*sw_video_upload_iface_upload_video_impl) (SwVideoUploadIface *self,
    const gchar *in_local_filename,
    GHashTable *in_fields,
    DBusGMethodInvocation *context);
void sw_video_upload_iface_implement_upload_video (SwVideoUploadIfaceClass *klass, sw_video_upload_iface_upload_video_impl impl);
/**
 * sw_video_upload_iface_return_from_upload_video:
 * @context: The D-Bus method invocation context
 * @out_opid: gint  (FIXME, generate documentation)
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void sw_video_upload_iface_return_from_upload_video (DBusGMethodInvocation *context,
    gint out_opid);
static inline void
sw_video_upload_iface_return_from_upload_video (DBusGMethodInvocation *context,
    gint out_opid)
{
  dbus_g_method_return (context,
      out_opid);
}

void sw_video_upload_iface_emit_video_upload_progress (gpointer instance,
    gint arg_opid,
    gint arg_progress,
    const gchar *arg_error_message);


G_END_DECLS
