/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import groovy.lang.Closure;
import java.io.File;
import java.net.URI;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ScriptHandlerInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.metaobject.BeanDynamicObject;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.resource.ResourceLocation;
import org.gradle.util.ConfigureUtil;

public class DefaultScriptHandler
implements ScriptHandler,
ScriptHandlerInternal,
DynamicObjectAware {
    private static final Logger LOGGER = Logging.getLogger(DefaultScriptHandler.class);
    private final ResourceLocation scriptResource;
    private final ClassLoaderScope classLoaderScope;
    private final DependencyResolutionServices dependencyResolutionServices;
    private RepositoryHandler repositoryHandler;
    private DependencyHandler dependencyHandler;
    private ConfigurationContainer configContainer;
    private Configuration classpathConfiguration;
    private DynamicObject dynamicObject;

    public DefaultScriptHandler(ScriptSource scriptSource, DependencyResolutionServices dependencyResolutionServices, ClassLoaderScope classLoaderScope) {
        this.dependencyResolutionServices = dependencyResolutionServices;
        this.scriptResource = scriptSource.getResource().getLocation();
        this.classLoaderScope = classLoaderScope;
    }

    public void dependencies(Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.getDependencies());
    }

    public void addScriptClassPathDependency(Object notation) {
        this.getDependencies().add("classpath", notation);
    }

    public ClassPath getScriptClassPath() {
        if (this.classpathConfiguration == null) {
            return new DefaultClassPath(new File[0]);
        }
        return new DefaultClassPath(this.classpathConfiguration.getFiles());
    }

    public DependencyHandler getDependencies() {
        this.defineConfiguration();
        if (this.dependencyHandler == null) {
            this.dependencyHandler = this.dependencyResolutionServices.getDependencyHandler();
        }
        return this.dependencyHandler;
    }

    public RepositoryHandler getRepositories() {
        if (this.repositoryHandler == null) {
            this.repositoryHandler = this.dependencyResolutionServices.getResolveRepositoryHandler();
        }
        return this.repositoryHandler;
    }

    public void repositories(Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.getRepositories());
    }

    public ConfigurationContainer getConfigurations() {
        this.defineConfiguration();
        return this.configContainer;
    }

    private void defineConfiguration() {
        if (this.configContainer == null) {
            this.configContainer = this.dependencyResolutionServices.getConfigurationContainer();
        }
        if (this.classpathConfiguration == null) {
            this.classpathConfiguration = (Configuration)this.configContainer.create("classpath");
        }
    }

    public File getSourceFile() {
        return this.scriptResource.getFile();
    }

    public URI getSourceURI() {
        return this.scriptResource.getURI();
    }

    public ClassLoader getClassLoader() {
        if (!this.classLoaderScope.isLocked()) {
            LOGGER.debug("Eager creation of script class loader for {}. This may result in performance issues.", (Object)this.scriptResource.getDisplayName());
        }
        return this.classLoaderScope.getLocalClassLoader();
    }

    public DynamicObject getAsDynamicObject() {
        if (this.dynamicObject == null) {
            this.dynamicObject = new BeanDynamicObject(this);
        }
        return this.dynamicObject;
    }
}

