/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.internal.changedetection.TaskArtifactState;
import org.gradle.api.internal.project.taskfactory.TaskClassInfo;
import org.gradle.api.internal.project.taskfactory.TaskClassInfoStore;
import org.gradle.api.internal.project.taskfactory.TaskClassValidator;
import org.gradle.api.internal.project.taskfactory.TaskClassValidatorExtractor;
import org.gradle.api.internal.tasks.ClassLoaderAwareTaskAction;
import org.gradle.api.internal.tasks.ContextAwareTaskAction;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.internal.Factory;
import org.gradle.internal.reflect.JavaReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskClassInfoStore
implements TaskClassInfoStore {
    private final TaskClassValidatorExtractor validatorExtractor;
    private final LoadingCache<Class<? extends Task>, TaskClassInfo> classInfos = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<Class<? extends Task>, TaskClassInfo>(){

        public TaskClassInfo load(Class<? extends Task> type) throws Exception {
            TaskClassInfo taskClassInfo = new TaskClassInfo();
            DefaultTaskClassInfoStore.this.findTaskActions(type, taskClassInfo);
            TaskClassValidator validator = DefaultTaskClassInfoStore.this.validatorExtractor.extractValidator(type);
            taskClassInfo.setValidator(validator);
            return taskClassInfo;
        }
    });

    public DefaultTaskClassInfoStore(TaskClassValidatorExtractor validatorExtractor) {
        this.validatorExtractor = validatorExtractor;
    }

    @Override
    public TaskClassInfo getTaskClassInfo(Class<? extends Task> type) {
        return (TaskClassInfo)this.classInfos.getUnchecked(type);
    }

    private void findTaskActions(Class<? extends Task> type, TaskClassInfo taskClassInfo) {
        HashSet<String> methods = new HashSet<String>();
        for (Class<? extends Task> current = type; current != null; current = current.getSuperclass()) {
            for (Method method : current.getDeclaredMethods()) {
                this.attachTaskAction(type, method, taskClassInfo, methods);
            }
        }
    }

    private void attachTaskAction(Class<? extends Task> type, Method method, TaskClassInfo taskClassInfo, Collection<String> processedMethods) {
        if (method.getAnnotation(TaskAction.class) == null) {
            return;
        }
        if (Modifier.isStatic(method.getModifiers())) {
            throw new GradleException(String.format("Cannot use @TaskAction annotation on static method %s.%s().", method.getDeclaringClass().getSimpleName(), method.getName()));
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length > 1) {
            throw new GradleException(String.format("Cannot use @TaskAction annotation on method %s.%s() as this method takes multiple parameters.", method.getDeclaringClass().getSimpleName(), method.getName()));
        }
        if (parameterTypes.length == 1) {
            if (!parameterTypes[0].equals(IncrementalTaskInputs.class)) {
                throw new GradleException(String.format("Cannot use @TaskAction annotation on method %s.%s() because %s is not a valid parameter to an action method.", method.getDeclaringClass().getSimpleName(), method.getName(), parameterTypes[0]));
            }
            if (taskClassInfo.isIncremental()) {
                throw new GradleException(String.format("Cannot have multiple @TaskAction methods accepting an %s parameter.", IncrementalTaskInputs.class.getSimpleName()));
            }
            taskClassInfo.setIncremental(true);
        }
        if (processedMethods.contains(method.getName())) {
            return;
        }
        taskClassInfo.getTaskActions().add(this.createActionFactory(type, method, parameterTypes));
        processedMethods.add(method.getName());
    }

    private Factory<Action<Task>> createActionFactory(final Class<? extends Task> type, final Method method, final Class<?>[] parameterTypes) {
        return new Factory<Action<Task>>(){

            public Action<Task> create() {
                if (parameterTypes.length == 1) {
                    return new IncrementalTaskAction(type, method);
                }
                return new StandardTaskAction(type, method);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IncrementalTaskAction
    extends StandardTaskAction
    implements ContextAwareTaskAction {
        private TaskArtifactState taskArtifactState;

        public IncrementalTaskAction(Class<? extends Task> type, Method method) {
            super(type, method);
        }

        @Override
        public void contextualise(TaskExecutionContext context) {
            this.taskArtifactState = context == null ? null : context.getTaskArtifactState();
        }

        @Override
        protected void doExecute(Task task, String methodName) {
            JavaReflectionUtil.method((Object)task, Object.class, (String)methodName, (Class[])new Class[]{IncrementalTaskInputs.class}).invoke((Object)task, new Object[]{this.taskArtifactState.getInputChanges()});
            this.taskArtifactState = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StandardTaskAction
    implements ClassLoaderAwareTaskAction {
        private final Class<? extends Task> type;
        private final Method method;

        public StandardTaskAction(Class<? extends Task> type, Method method) {
            this.type = type;
            this.method = method;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Task task) {
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.method.getDeclaringClass().getClassLoader());
            try {
                this.doExecute(task, this.method.getName());
            }
            finally {
                Thread.currentThread().setContextClassLoader(original);
            }
        }

        protected void doExecute(Task task, String methodName) {
            JavaReflectionUtil.method((Object)task, Object.class, (String)methodName, (Class[])new Class[0]).invoke((Object)task, new Object[0]);
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.method.getDeclaringClass().getClassLoader();
        }

        @Override
        public String getActionClassName() {
            return this.type.getName();
        }
    }
}

