/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.deployment.internal;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.deployment.internal.DeploymentHandle;
import org.gradle.deployment.internal.DeploymentRegistry;
import org.gradle.internal.Cast;
import org.gradle.internal.concurrent.CompositeStoppable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDeploymentRegistry
implements DeploymentRegistry {
    private static final Logger LOGGER = Logging.getLogger(DefaultDeploymentRegistry.class);
    private final Lock lock = new ReentrantLock();
    private final Map<String, DeploymentHandle> handles = Maps.newHashMap();
    private boolean stopped;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(String id, DeploymentHandle handle) {
        block4: {
            this.lock.lock();
            try {
                this.failIfStopped();
                if (!this.handles.containsKey(id)) {
                    this.handles.put(id, handle);
                    break block4;
                }
                throw new IllegalStateException("A deployment with id '" + id + "' is already registered.");
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends DeploymentHandle> T get(Class<T> handleType, String id) {
        this.lock.lock();
        try {
            this.failIfStopped();
            DeploymentHandle deploymentHandle = (DeploymentHandle)Cast.cast(handleType, (Object)this.handles.get(id));
            return (T)deploymentHandle;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNewBuild(Gradle gradle) {
        this.lock.lock();
        try {
            for (DeploymentHandle handle : this.handles.values()) {
                handle.onNewBuild(gradle);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.lock.lock();
        try {
            LOGGER.debug("Stopping {} deployment handles", (Object)this.handles.size());
            CompositeStoppable.stoppable(this.handles.values()).stop();
        }
        finally {
            LOGGER.debug("Stopped deployment handles");
            this.stopped = true;
            this.handles.clear();
            this.lock.unlock();
        }
    }

    private void failIfStopped() {
        if (this.stopped) {
            throw new IllegalStateException("Cannot modify deployment handles once the registry has been stopped.");
        }
    }
}

