/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cleanup;

import java.io.Closeable;
import java.io.File;
import java.util.Collections;
import org.gradle.api.Action;
import org.gradle.api.invocation.Gradle;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.IoActions;
import org.gradle.internal.cleanup.BuildOutputCleanupCache;
import org.gradle.internal.cleanup.BuildOutputCleanupRegistry;
import org.gradle.internal.cleanup.BuildOutputDeleter;
import org.gradle.util.GFileUtils;
import org.gradle.util.GradleVersion;

public class DefaultBuildOutputCleanupCache
implements BuildOutputCleanupCache {
    private static final String CACHE_DISPLAY_NAME = "Build Output Cleanup Cache";
    private final CacheRepository cacheRepository;
    private final Gradle gradle;
    private final BuildOutputDeleter buildOutputDeleter;
    private final BuildOutputCleanupRegistry buildOutputCleanupRegistry;

    public DefaultBuildOutputCleanupCache(CacheRepository cacheRepository, Gradle gradle, BuildOutputDeleter buildOutputDeleter, BuildOutputCleanupRegistry buildOutputCleanupRegistry) {
        this.cacheRepository = cacheRepository;
        this.gradle = gradle;
        this.buildOutputDeleter = buildOutputDeleter;
        this.buildOutputCleanupRegistry = buildOutputCleanupRegistry;
    }

    public void cleanIfStale() {
        IoActions.withResource((Closeable)this.createCache(), (Action)new Action<PersistentCache>(){

            public void execute(PersistentCache cache) {
                final File markerFile = new File(cache.getBaseDir(), "built.bin");
                cache.useCache(new Runnable(){

                    public void run() {
                        boolean markerFileExists = markerFile.exists();
                        if (!markerFileExists) {
                            DefaultBuildOutputCleanupCache.this.buildOutputDeleter.delete(DefaultBuildOutputCleanupCache.this.buildOutputCleanupRegistry.getOutputs());
                            GFileUtils.touch(markerFile);
                        }
                    }
                });
            }
        });
    }

    protected PersistentCache createCache() {
        return this.cacheRepository.cache(this.gradle, "buildOutputCleanup").withCrossVersionCache(CacheBuilder.LockTarget.CachePropertiesFile).withDisplayName(CACHE_DISPLAY_NAME).withLockOptions(LockOptionsBuilder.mode(FileLockManager.LockMode.None).useCrossVersionImplementation()).withProperties(Collections.singletonMap("gradle.version", GradleVersion.current().getVersion())).open();
    }
}

