/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations.notify;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.Nullable;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.operations.notify.BuildOperationFinishedNotification;
import org.gradle.internal.operations.notify.BuildOperationNotificationListener;
import org.gradle.internal.operations.notify.BuildOperationNotificationListenerRegistrar;
import org.gradle.internal.operations.notify.BuildOperationStartedNotification;
import org.gradle.internal.progress.BuildOperationDescriptor;
import org.gradle.internal.progress.BuildOperationListener;
import org.gradle.internal.progress.BuildOperationListenerManager;
import org.gradle.internal.progress.OperationFinishEvent;
import org.gradle.internal.progress.OperationStartEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BuildOperationNotificationBridge
implements BuildOperationNotificationListenerRegistrar,
Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildOperationNotificationBridge.class);
    private Listener operationListener;
    private final BuildOperationListenerManager buildOperationListenerManager;

    BuildOperationNotificationBridge(BuildOperationListenerManager buildOperationListenerManager) {
        this.buildOperationListenerManager = buildOperationListenerManager;
    }

    public void registerBuildScopeListener(BuildOperationNotificationListener notificationListener) {
        if (this.operationListener != null) {
            throw new IllegalStateException("listener is already registered");
        }
        this.operationListener = new Listener(notificationListener);
        this.buildOperationListenerManager.addListener(this.operationListener);
    }

    public void stop() {
        if (this.operationListener != null) {
            this.buildOperationListenerManager.removeListener(this.operationListener);
        }
    }

    private static class Finished
    implements BuildOperationFinishedNotification {
        private final Object id;
        private final Object parentId;
        private final Object details;
        private final Object result;
        private final Throwable failure;

        private Finished(Object id, Object parentId, Object details, Object result, Throwable failure) {
            this.id = id;
            this.parentId = parentId;
            this.details = details;
            this.result = result;
            this.failure = failure;
        }

        public Object getNotificationOperationId() {
            return this.id;
        }

        @Nullable
        public Object getNotificationOperationParentId() {
            return this.parentId;
        }

        public Object getNotificationOperationDetails() {
            return this.details;
        }

        public Object getNotificationOperationResult() {
            return this.result;
        }

        public Throwable getNotificationOperationFailure() {
            return this.failure;
        }

        public String toString() {
            return "BuildOperationFinishedNotification{id=" + this.id + ", parentId=" + this.parentId + ", details=" + this.details + ", result=" + this.result + ", failure=" + this.failure + '}';
        }
    }

    private static class Started
    implements BuildOperationStartedNotification {
        private final Object id;
        private final Object parentId;
        private final Object details;

        private Started(Object id, Object parentId, Object details) {
            this.id = id;
            this.parentId = parentId;
            this.details = details;
        }

        public Object getNotificationOperationId() {
            return this.id;
        }

        public Object getNotificationOperationParentId() {
            return this.parentId;
        }

        public Object getNotificationOperationDetails() {
            return this.details;
        }

        public String toString() {
            return "BuildOperationStartedNotification{id=" + this.id + ", parentId=" + this.parentId + ", details=" + this.details + '}';
        }
    }

    private static class Listener
    implements BuildOperationListener {
        private final BuildOperationNotificationListener notificationListener;
        private final Map<Object, Object> parents = new ConcurrentHashMap<Object, Object>();
        private final Map<Object, Object> active = new ConcurrentHashMap<Object, Object>();

        private Listener(BuildOperationNotificationListener notificationListener) {
            this.notificationListener = notificationListener;
        }

        public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
            Object id = buildOperation.getId();
            Object parentId = buildOperation.getParentId();
            if (parentId != null) {
                if (this.active.containsKey(parentId)) {
                    this.parents.put(id, parentId);
                } else if ((parentId = this.parents.get(parentId)) != null) {
                    this.parents.put(id, parentId);
                }
            }
            if (buildOperation.getDetails() == null) {
                return;
            }
            this.active.put(id, "");
            Started notification = new Started(id, parentId, buildOperation.getDetails());
            try {
                this.notificationListener.started((BuildOperationStartedNotification)notification);
            }
            catch (Throwable e) {
                LOGGER.debug("Build operation notification listener threw an error on " + notification, e);
                this.maybeThrow(e);
            }
        }

        private void maybeThrow(Throwable e) {
            if (e instanceof Error && !(e instanceof LinkageError)) {
                throw (Error)e;
            }
        }

        public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
            Object id = buildOperation.getId();
            Object parentId = this.parents.remove(id);
            if (this.active.remove(id) == null) {
                return;
            }
            Finished notification = new Finished(id, parentId, buildOperation.getDetails(), finishEvent.getResult(), finishEvent.getFailure());
            try {
                this.notificationListener.finished((BuildOperationFinishedNotification)notification);
            }
            catch (Throwable e) {
                LOGGER.debug("Build operation notification listener threw an error on " + notification, e);
                this.maybeThrow(e);
            }
        }
    }
}

