/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaFile;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.ClsStubPsiFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.SourceStubPsiFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.StubPsiFactory;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStubImpl;
import org.jetbrains.kotlin.com.intellij.psi.tree.IStubFileElementType;
import org.jetbrains.kotlin.com.intellij.util.io.StringRef;

public class PsiJavaFileStubImpl
extends PsiFileStubImpl<PsiJavaFile>
implements PsiJavaFileStub {
    private final StringRef myPackageName;
    private final boolean myCompiled;
    private StubPsiFactory myFactory;

    public PsiJavaFileStubImpl(PsiJavaFile file2, StringRef packageName, boolean compiled) {
        super(file2);
        this.myPackageName = packageName;
        this.myCompiled = compiled;
        this.myFactory = compiled ? ClsStubPsiFactory.INSTANCE : SourceStubPsiFactory.INSTANCE;
    }

    public PsiJavaFileStubImpl(String packageName, boolean compiled) {
        this(null, StringRef.fromString(packageName), compiled);
    }

    @Override
    @NotNull
    public IStubFileElementType getType() {
        IStubFileElementType iStubFileElementType = JavaStubElementTypes.JAVA_FILE;
        if (iStubFileElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/impl/PsiJavaFileStubImpl", "getType"));
        }
        return iStubFileElementType;
    }

    @Override
    @NotNull
    public PsiClass[] getClasses() {
        PsiClass[] psiClassArray = (PsiClass[])this.getChildrenByType(JavaStubElementTypes.CLASS, PsiClass.ARRAY_FACTORY);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/impl/PsiJavaFileStubImpl", "getClasses"));
        }
        return psiClassArray;
    }

    @Override
    public String getPackageName() {
        return StringRef.toString(this.myPackageName);
    }

    @Override
    public boolean isCompiled() {
        return this.myCompiled;
    }

    @Override
    public StubPsiFactory getPsiFactory() {
        return this.myFactory;
    }

    @Override
    public void setPsiFactory(StubPsiFactory factory2) {
        this.myFactory = factory2;
    }

    @Override
    public String toString() {
        return "PsiJavaFileStub [" + this.myPackageName + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsiJavaFileStubImpl stub = (PsiJavaFileStubImpl)o;
        if (this.myCompiled != stub.myCompiled) {
            return false;
        }
        return !(this.myPackageName != null ? !this.myPackageName.equals(stub.myPackageName) : stub.myPackageName != null);
    }

    public int hashCode() {
        int result2 = this.myPackageName != null ? this.myPackageName.hashCode() : 0;
        result2 = 31 * result2 + (this.myCompiled ? 1 : 0);
        return result2;
    }
}

