/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactoryWithPsiElement;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.diagnostics.Severity;

public abstract class AbstractDiagnostic<E extends PsiElement>
implements ParametrizedDiagnostic<E> {
    private final E psiElement;
    private final DiagnosticFactoryWithPsiElement<E, ?> factory;
    private final Severity severity;

    public AbstractDiagnostic(@NotNull E psiElement, @NotNull DiagnosticFactoryWithPsiElement<E, ?> factory2, @NotNull Severity severity) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/kotlin/diagnostics/AbstractDiagnostic", "<init>"));
        }
        if (factory2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/kotlin/diagnostics/AbstractDiagnostic", "<init>"));
        }
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "org/jetbrains/kotlin/diagnostics/AbstractDiagnostic", "<init>"));
        }
        this.psiElement = psiElement;
        this.factory = factory2;
        this.severity = severity;
    }

    @NotNull
    public DiagnosticFactoryWithPsiElement<E, ?> getFactory() {
        DiagnosticFactoryWithPsiElement<E, ?> diagnosticFactoryWithPsiElement = this.factory;
        if (diagnosticFactoryWithPsiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/diagnostics/AbstractDiagnostic", "getFactory"));
        }
        return diagnosticFactoryWithPsiElement;
    }

    @Override
    @NotNull
    public PsiFile getPsiFile() {
        PsiFile psiFile = this.psiElement.getContainingFile();
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/diagnostics/AbstractDiagnostic", "getPsiFile"));
        }
        return psiFile;
    }

    @Override
    @NotNull
    public Severity getSeverity() {
        Severity severity = this.severity;
        if (severity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/diagnostics/AbstractDiagnostic", "getSeverity"));
        }
        return severity;
    }

    @Override
    @NotNull
    public E getPsiElement() {
        E e = this.psiElement;
        if (e == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/diagnostics/AbstractDiagnostic", "getPsiElement"));
        }
        return e;
    }

    @Override
    @NotNull
    public List<TextRange> getTextRanges() {
        List<TextRange> list2 = ((DiagnosticFactoryWithPsiElement)this.getFactory()).getTextRanges(this);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/diagnostics/AbstractDiagnostic", "getTextRanges"));
        }
        return list2;
    }

    @Override
    public boolean isValid() {
        return ((DiagnosticFactoryWithPsiElement)this.getFactory()).isValid(this);
    }
}

