/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.context;

import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.psi.KtExpression;

public class AliasingContext {
    @Nullable
    private final Map<DeclarationDescriptor, JsExpression> aliasesForDescriptors;
    @Nullable
    private final Map<KtExpression, JsExpression> aliasesForExpressions;
    @Nullable
    private final AliasingContext parent;

    @NotNull
    public static AliasingContext getCleanContext() {
        AliasingContext aliasingContext = new AliasingContext(null, null, null);
        if (aliasingContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/AliasingContext", "getCleanContext"));
        }
        return aliasingContext;
    }

    private AliasingContext(@Nullable AliasingContext parent2, @Nullable Map<DeclarationDescriptor, JsExpression> aliasesForDescriptors, @Nullable Map<KtExpression, JsExpression> aliasesForExpressions) {
        this.parent = parent2;
        this.aliasesForDescriptors = aliasesForDescriptors;
        this.aliasesForExpressions = aliasesForExpressions;
    }

    @NotNull
    public AliasingContext inner() {
        AliasingContext aliasingContext = new AliasingContext(this, null, null);
        if (aliasingContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/AliasingContext", "inner"));
        }
        return aliasingContext;
    }

    @NotNull
    public AliasingContext inner(@NotNull DeclarationDescriptor descriptor2, @NotNull JsExpression alias) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/AliasingContext", "inner"));
        }
        if (alias == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alias", "org/jetbrains/kotlin/js/translate/context/AliasingContext", "inner"));
        }
        AliasingContext aliasingContext = new AliasingContext(this, Collections.singletonMap(descriptor2, alias), null);
        if (aliasingContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/AliasingContext", "inner"));
        }
        return aliasingContext;
    }

    @NotNull
    public AliasingContext withExpressionsAliased(@NotNull Map<KtExpression, JsExpression> aliasesForExpressions) {
        if (aliasesForExpressions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aliasesForExpressions", "org/jetbrains/kotlin/js/translate/context/AliasingContext", "withExpressionsAliased"));
        }
        AliasingContext aliasingContext = new AliasingContext(this, null, aliasesForExpressions);
        if (aliasingContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/AliasingContext", "withExpressionsAliased"));
        }
        return aliasingContext;
    }

    @NotNull
    public AliasingContext withDescriptorsAliased(@NotNull Map<DeclarationDescriptor, JsExpression> aliases) {
        if (aliases == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aliases", "org/jetbrains/kotlin/js/translate/context/AliasingContext", "withDescriptorsAliased"));
        }
        AliasingContext aliasingContext = new AliasingContext(this, aliases, null);
        if (aliasingContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/AliasingContext", "withDescriptorsAliased"));
        }
        return aliasingContext;
    }

    @Nullable
    public JsExpression getAliasForDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/context/AliasingContext", "getAliasForDescriptor"));
        }
        JsExpression alias = this.aliasesForDescriptors != null ? this.aliasesForDescriptors.get(descriptor2.getOriginal()) : null;
        return alias != null || this.parent == null ? alias : this.parent.getAliasForDescriptor(descriptor2);
    }

    @Nullable
    public JsExpression getAliasForExpression(@NotNull KtExpression element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/js/translate/context/AliasingContext", "getAliasForExpression"));
        }
        JsExpression alias = this.aliasesForExpressions != null ? this.aliasesForExpressions.get(element) : null;
        return alias != null || this.parent == null ? alias : this.parent.getAliasForExpression(element);
    }
}

