/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.nativeintegration.filesystem;

import org.gradle.internal.nativeintegration.filesystem.FileMetadataSnapshot;
import org.gradle.internal.nativeintegration.filesystem.FileType;

public class DefaultFileMetadata
implements FileMetadataSnapshot {
    private static final FileMetadataSnapshot DIR = new DefaultFileMetadata(FileType.Directory, 0L, 0L);
    private static final FileMetadataSnapshot MISSING = new DefaultFileMetadata(FileType.Missing, 0L, 0L);
    private final FileType type;
    private final long lastModified;
    private final long length;

    public DefaultFileMetadata(FileType type, long lastModified, long length) {
        this.type = type;
        this.lastModified = lastModified;
        this.length = length;
    }

    public static FileMetadataSnapshot file(long lastModified, long length) {
        return new DefaultFileMetadata(FileType.RegularFile, lastModified, length);
    }

    public static FileMetadataSnapshot directory() {
        return DIR;
    }

    public static FileMetadataSnapshot missing() {
        return MISSING;
    }

    public FileType getType() {
        return this.type;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public long getLength() {
        return this.length;
    }
}

