/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.apache.fop.layoutmgr.FootnoteBodyLayoutManager;
import org.apache.fop.layoutmgr.KnuthBlockBox;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.inline.KnuthInlineBox;

public final class FootenoteUtil {
    private FootenoteUtil() {
    }

    public static List<FootnoteBodyLayoutManager> getFootnotes(List<ListElement> elemenList) {
        return FootenoteUtil.getFootnotes(elemenList, 0, elemenList.size() - 1);
    }

    public static List<FootnoteBodyLayoutManager> getFootnotes(List<ListElement> elemenList, int startIndex, int endIndex) {
        ListIterator<ListElement> iter = elemenList.listIterator(startIndex);
        List footnotes = null;
        while (iter.nextIndex() <= endIndex) {
            ListElement element = iter.next();
            if (element instanceof KnuthInlineBox && ((KnuthInlineBox)element).isAnchor()) {
                footnotes = FootenoteUtil.getFootnoteList(footnotes);
                footnotes.add(((KnuthInlineBox)element).getFootnoteBodyLM());
                continue;
            }
            if (!(element instanceof KnuthBlockBox) || !((KnuthBlockBox)element).hasAnchors()) continue;
            footnotes = FootenoteUtil.getFootnoteList(footnotes);
            footnotes.addAll(((KnuthBlockBox)element).getFootnoteBodyLMs());
        }
        if (footnotes == null) {
            return Collections.emptyList();
        }
        return footnotes;
    }

    private static <T> List<T> getFootnoteList(List<T> footnotes) {
        if (footnotes == null) {
            return new ArrayList();
        }
        return footnotes;
    }
}

