#ifndef _EFL_UI_DRAGGABLE_EO_H_
#define _EFL_UI_DRAGGABLE_EO_H_

#ifndef _EFL_UI_DRAGGABLE_EO_CLASS_TYPE
#define _EFL_UI_DRAGGABLE_EO_CLASS_TYPE

typedef Eo Efl_Ui_Draggable;

#endif

#ifndef _EFL_UI_DRAGGABLE_EO_TYPES
#define _EFL_UI_DRAGGABLE_EO_TYPES


#endif
#define EFL_UI_DRAGGABLE_INTERFACE efl_ui_draggable_interface_get()

EWAPI const Eo_Class *efl_ui_draggable_interface_get(void);

/**
 * @brief Contrtol whether the object's content is changed by drag and drop.
 *
 * If @c drag_target is true, the object can be target of dragging object and
 * the content of this object can be changed into dragging content. For
 * example, If object deals with image and @c drag_target is true, user can
 * drag new image and drop it into this object. And then this object's image
 * can be changed into new image.
 *
 * @return Turn on or off drop_target. Default is @c false.
 *
 * @ingroup Efl_Ui_Draggable
 */
EOAPI Eina_Bool efl_ui_draggable_drag_target_get(const Eo *obj);

/**
 * @brief Contrtol whether the object's content is changed by drag and drop.
 *
 * If @c drag_target is true, the object can be target of dragging object and
 * the content of this object can be changed into dragging content. For
 * example, If object deals with image and @c drag_target is true, user can
 * drag new image and drop it into this object. And then this object's image
 * can be changed into new image.
 *
 * @param[in] set Turn on or off drop_target. Default is @c false.
 *
 * @ingroup Efl_Ui_Draggable
 */
EOAPI void efl_ui_draggable_drag_target_set(Eo *obj, Eina_Bool set);

EOAPI extern const Eo_Event_Description _EFL_UI_EVENT_DRAG;
EOAPI extern const Eo_Event_Description _EFL_UI_EVENT_DRAG_START;
EOAPI extern const Eo_Event_Description _EFL_UI_EVENT_DRAG_STOP;
EOAPI extern const Eo_Event_Description _EFL_UI_EVENT_DRAG_END;
EOAPI extern const Eo_Event_Description _EFL_UI_EVENT_DRAG_START_UP;
EOAPI extern const Eo_Event_Description _EFL_UI_EVENT_DRAG_START_DOWN;
EOAPI extern const Eo_Event_Description _EFL_UI_EVENT_DRAG_START_RIGHT;
EOAPI extern const Eo_Event_Description _EFL_UI_EVENT_DRAG_START_LEFT;

/**
 * No description
 */
#define EFL_UI_EVENT_DRAG (&(_EFL_UI_EVENT_DRAG))

/**
 * No description
 */
#define EFL_UI_EVENT_DRAG_START (&(_EFL_UI_EVENT_DRAG_START))

/**
 * No description
 */
#define EFL_UI_EVENT_DRAG_STOP (&(_EFL_UI_EVENT_DRAG_STOP))

/**
 * No description
 */
#define EFL_UI_EVENT_DRAG_END (&(_EFL_UI_EVENT_DRAG_END))

/**
 * No description
 */
#define EFL_UI_EVENT_DRAG_START_UP (&(_EFL_UI_EVENT_DRAG_START_UP))

/**
 * No description
 */
#define EFL_UI_EVENT_DRAG_START_DOWN (&(_EFL_UI_EVENT_DRAG_START_DOWN))

/**
 * No description
 */
#define EFL_UI_EVENT_DRAG_START_RIGHT (&(_EFL_UI_EVENT_DRAG_START_RIGHT))

/**
 * No description
 */
#define EFL_UI_EVENT_DRAG_START_LEFT (&(_EFL_UI_EVENT_DRAG_START_LEFT))

#endif
