-- EFL LuaJIT bindings: efl_event.eo (class Efl.Event)
-- For use with Elua; automatically generated, do not modify

local cutil = require("cutil")
local util  = require("util")
local ffi   = require("ffi")
local eo    = require("eo")

local M, __lib = ...

local __class
local __body

local init = function()
    __class = __lib.efl_event_interface_get()
    eo.class_register("Efl_Event", nil, nil, __body, __class)
end

cutil.init_module(init, function() end)

ffi.cdef [[
    const Eo_Class *efl_event_interface_get(void);
    void efl_event_timestamp_set(double ms);
    double efl_event_timestamp_get(void);
    void efl_event_reset(void);
    Efl_Event *efl_event_dup(void);
]]

__body = {
    timestamp_set = function(self, ms)
        eo.__do_start(self, __class)
        __lib.efl_event_timestamp_set(ms)
        eo.__do_end()
    end,

    timestamp_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.efl_event_timestamp_get()
        eo.__do_end()
        return tonumber(v)
    end,

    reset = function(self)
        eo.__do_start(self, __class)
        __lib.efl_event_reset()
        eo.__do_end()
    end,

    dup = function(self)
        eo.__do_start(self, __class)
        local v = __lib.efl_event_dup()
        eo.__do_end()
        return v
    end,

    __properties = {
        ["timestamp"] = { 0, 0, 1, 1, true, true }
    }
}
__body["__iface_Efl_Event"] = true

return M
