/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.ChangeFirer;
import org.netbeans.DuplicateException;
import org.netbeans.Events;
import org.netbeans.FixedModule;
import org.netbeans.InvalidException;
import org.netbeans.JarClassLoader;
import org.netbeans.JaveleonModule;
import org.netbeans.MainImpl;
import org.netbeans.Module;
import org.netbeans.ModuleFactory;
import org.netbeans.ModuleInstaller;
import org.netbeans.NbInstrumentation;
import org.netbeans.NetigsoFramework;
import org.netbeans.NetigsoHandle;
import org.netbeans.NetigsoModule;
import org.netbeans.Stamps;
import org.netbeans.TaskFuture;
import org.netbeans.TopSecurityManager;
import org.netbeans.Util;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;
import org.openide.modules.Modules;
import org.openide.modules.Places;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Enumerations;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Task;
import org.openide.util.TopologicalSortException;
import org.openide.util.Union2;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class ModuleManager
extends Modules {
    private static final Logger LOG = Logger.getLogger(ModuleManager.class.getName());
    public static final String PROP_MODULES = "modules";
    public static final String PROP_ENABLED_MODULES = "enabledModules";
    public static final String PROP_CLASS_LOADER = "classLoader";
    static boolean PRINT_TOPOLOGICAL_EXCEPTION_STACK_TRACES = !Boolean.getBoolean("suppress.topological.exception");
    private final Set<Module> modules = new HashSet<Module>(100);
    private final Map<String, Module> modulesByName = new HashMap<String, Module>(100);
    private final Object MODULE_PROBLEMS_LOCK = new Object();
    private final Map<Module, Set<Union2<Dependency, InvalidException>>> moduleProblemsWithoutNeeds = new HashMap<Module, Set<Union2<Dependency, InvalidException>>>(100);
    private final Map<Module, Set<Union2<Dependency, InvalidException>>> moduleProblemsWithNeeds = new HashMap<Module, Set<Union2<Dependency, InvalidException>>>(100);
    private static final Set<Union2<Dependency, InvalidException>> EMPTY_COLLECTION = Collections.emptySet();
    private final ProvidersOf providersOf = new ProvidersOf();
    private final ModuleInstaller installer;
    private ModuleFactory moduleFactory;
    private SystemClassLoader classLoader;
    private List<File> classLoaderPatches;
    private final Object classLoaderLock = new String("ModuleManager.classLoaderLock");
    private final Events ev;
    private final ModuleDataCache mdc = new ModuleDataCache();
    private final NetigsoHandle netigso;
    private final Mutex.Privileged MUTEX_PRIVILEGED = new Mutex.Privileged();
    private final Mutex MUTEX = new Mutex(this.MUTEX_PRIVILEGED);
    private ChangeFirer firer = new ChangeFirer(this);
    private boolean readOnly = false;
    private PropertyChangeSupport changeSupport;
    private final Util.ModuleLookup lookup = new Util.ModuleLookup();
    private final Lookup completeLookup = new ProxyLookup(new Lookup[]{Lookups.fixed((Object[])new Object[]{this}), this.lookup});
    private static final Union2<Dependency, InvalidException> PROBING_IN_PROCESS = Union2.createSecond((Object)new InvalidException("PROBING_IN_PROCESS"));

    public ModuleManager(ModuleInstaller moduleInstaller, Events events) {
        this.installer = moduleInstaller;
        this.ev = events;
        this.netigso = new NetigsoHandle(this);
        String string = System.getProperty("netbeans.systemclassloader.patches");
        if (string != null) {
            System.err.println("System class loader patches: " + string);
            this.classLoaderPatches = new ArrayList<File>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                this.classLoaderPatches.add(new File(stringTokenizer.nextToken()));
            }
        } else {
            this.classLoaderPatches = Collections.emptyList();
        }
        this.classLoader = new SystemClassLoader(this.classLoaderPatches, new ClassLoader[]{moduleInstaller.getClass().getClassLoader()}, Collections.<Module>emptySet());
        ModuleManager.updateContextClassLoaders(this.classLoader, true);
        this.moduleFactory = (ModuleFactory)Lookup.getDefault().lookup(ModuleFactory.class);
        if (this.moduleFactory == null) {
            this.moduleFactory = new ModuleFactory();
        } else {
            this.classLoader.setSystemClassLoader(this.moduleFactory.getClasspathDelegateClassLoader(this, ModuleManager.class.getClassLoader()));
        }
    }

    public final Events getEvents() {
        return this.ev;
    }

    public final Mutex mutex() {
        return this.MUTEX;
    }

    public final Mutex.Privileged mutexPrivileged() {
        return this.MUTEX_PRIVILEGED;
    }

    public void releaseModuleManifests() {
        for (Module module : this.modules) {
            module.releaseManifest();
        }
    }

    void readOnly(boolean bl) {
        this.readOnly = bl;
    }

    void assertWritable() throws IllegalThreadStateException {
        if (this.readOnly) {
            throw new IllegalThreadStateException("You are attempting to make changes to " + (Object)((Object)this) + " in a property change callback. This is illegal. You may only make module system changes while holding a write mutex and not inside a change callback. See #16328.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        ModuleManager moduleManager = this;
        synchronized (moduleManager) {
            if (this.changeSupport == null) {
                this.changeSupport = new PropertyChangeSupport((Object)this);
            }
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    final void firePropertyChange(String string, Object object, Object object2) {
        if (Util.err.isLoggable(Level.FINE)) {
            Util.err.fine("ModuleManager.propertyChange: " + string + ": " + object + " -> " + object2);
        }
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(string, object, object2);
        }
    }

    final void fireReloadable(Module module) {
        this.firer.change(new ChangeFirer.Change((Object)module, "reloadable", null, null));
        this.firer.fire();
    }

    public Lookup getModuleLookup() {
        return this.completeLookup;
    }

    final void fireModulesCreatedDeleted(Set set, Set set2) {
        Util.err.fine("lookup created: " + set + " deleted: " + set2);
        this.lookup.changed();
    }

    public Set<Module> getModules() {
        return new HashSet<Module>(this.modules);
    }

    final int getModuleCount() {
        return this.modules.size();
    }

    public final Set<Module> getEnabledModules() {
        HashSet<Module> hashSet = new HashSet<Module>(this.modules);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Module module = (Module)((Object)iterator.next());
            if (module.isEnabled()) continue;
            iterator.remove();
        }
        return hashSet;
    }

    public final Module get(String string) {
        return this.modulesByName.get(string);
    }

    public ModuleInfo findCodeNameBase(String string) {
        return this.get(string);
    }

    public ModuleInfo ownerOf(Class<?> clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader instanceof Util.ModuleProvider) {
            return ((Util.ModuleProvider)((Object)classLoader)).getModule();
        }
        String string = Module.findClasspathModuleCodeName(clazz);
        if (string != null) {
            return this.get(string.replaceFirst("/\\d+$", ""));
        }
        return null;
    }

    @Deprecated
    public Set<Module> getModuleInterdependencies(Module module, boolean bl, boolean bl2) {
        return Util.moduleInterdependencies(module, bl, bl2, true, this.modules, this.modulesByName, this.getProvidersOf());
    }

    public Set<Module> getModuleInterdependencies(Module module, boolean bl, boolean bl2, boolean bl3) {
        return Util.moduleInterdependencies(module, bl, bl2, bl3, this.modules, this.modulesByName, this.getProvidersOf());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getClassLoader() {
        Object object = this.classLoaderLock;
        synchronized (object) {
            return this.classLoader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateClassLoader() {
        Object object2;
        HashSet<ClassLoader> hashSet = this.classLoaderLock;
        synchronized (hashSet) {
            this.classLoader.destroy();
        }
        hashSet = new HashSet<ClassLoader>(this.modules.size() * 4 / 3 + 2);
        ArrayList<ClassLoader> arrayList = new ArrayList<ClassLoader>(this.modules.size() + 1);
        ClassLoader classLoader = ModuleManager.class.getClassLoader();
        hashSet.add(classLoader);
        arrayList.add(classLoader);
        for (Object object2 : this.modules) {
            if (!object2.isEnabled() || !hashSet.add(object2.getClassLoader())) continue;
            arrayList.add(object2.getClassLoader());
        }
        if (this.moduleFactory.removeBaseClassLoader()) {
            arrayList.remove(classLoader);
        }
        ClassLoader[] classLoaderArray = arrayList.toArray(new ClassLoader[arrayList.size()]);
        try {
            object2 = new SystemClassLoader(this.classLoaderPatches, classLoaderArray, this.modules);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Util.err.log(Level.WARNING, null, illegalArgumentException);
            object2 = new SystemClassLoader(this.classLoaderPatches, new ClassLoader[]{ModuleManager.class.getClassLoader()}, Collections.<Module>emptySet());
        }
        Object object3 = this.classLoaderLock;
        synchronized (object3) {
            this.classLoader = object2;
            ModuleManager.updateContextClassLoaders(this.classLoader, false);
        }
        this.firer.change(new ChangeFirer.Change((Object)this, PROP_CLASS_LOADER, null, null));
    }

    private static void updateContextClassLoaders(ClassLoader classLoader, boolean bl) {
        int n;
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        while (true) {
            int n2;
            Thread[] threadArray;
            if ((n = threadGroup.enumerate(threadArray = new Thread[n2 = threadGroup.activeCount() + 1], true)) < n2) {
                for (int i = 0; i < n; ++i) {
                    if (bl || threadArray[i].getContextClassLoader() instanceof SystemClassLoader) {
                        try {
                            threadArray[i].setContextClassLoader(classLoader);
                        }
                        catch (SecurityException securityException) {
                            LOG.log(Level.FINE, "Cannot set context ClassLoader to the Thread: {0}", threadArray[i]);
                        }
                        continue;
                    }
                    Util.err.fine("Not touching context class loader " + threadArray[i].getContextClassLoader() + " on thread " + threadArray[i].getName());
                }
                break;
            }
            Util.err.fine("Race condition getting all threads, restarting...");
        }
        Util.err.fine("Set context class loader on " + n + " threads");
    }

    public void replaceJaveleonModule(Module module, Module module2) {
        assert (module2 instanceof JaveleonModule);
        this.modules.remove((Object)module);
        this.modulesByName.remove(module.getCodeNameBase());
        this.modules.add(module2);
        this.modulesByName.put(module2.getCodeNameBase(), module2);
        this.invalidateClassLoader();
    }

    private static void checkMissingModules(Set<Module> set, List<Module> list) throws InvalidException {
        InvalidException invalidException = null;
        HashSet<Module> hashSet = new HashSet<Module>(list);
        for (Module module : set) {
            if (hashSet.contains((Object)module)) continue;
            InvalidException invalidException2 = new InvalidException(module, "Requested by OSGi bundle");
            if (invalidException != null) {
                invalidException2.initCause(invalidException);
            }
            invalidException = invalidException2;
        }
        if (invalidException != null) {
            throw invalidException;
        }
    }

    private static int countEnabled(List<Module> list) {
        int n = 0;
        for (Module module : list) {
            if (!module.isEnabled()) continue;
            ++n;
        }
        return n;
    }

    final Boolean isOSGi(File file) {
        return this.mdc.isOSGi(file.getPath());
    }

    final InputStream dataFor(File file) {
        if (file == null) {
            return null;
        }
        byte[] byArray = this.mdc.getModuleState(file.getPath());
        return byArray == null ? null : new ByteArrayInputStream(byArray);
    }

    final String cnbFor(File file) {
        if (file == null) {
            return null;
        }
        return this.mdc.getCnb(file.getPath());
    }

    private Map<String, Set<Module>> getProvidersOf() {
        return this.providersOf.getProvidersOf();
    }

    static void registerProviders(Module module, Map<String, Set<Module>> map) {
        String[] stringArray = module.getProvides();
        for (int i = 0; i < stringArray.length; ++i) {
            Set<Module> set = map.get(stringArray[i]);
            if (set == null) {
                set = new HashSet<Module>(16);
                map.put(stringArray[i], set);
            }
            set.add(module);
        }
    }

    final NetigsoFramework netigso() {
        return this.netigso.getDefault();
    }

    final void netigsoLoaderUp(NetigsoModule netigsoModule) throws IOException {
        this.netigso.classLoaderUp(netigsoModule);
    }

    final void netigsoLoaderDown(NetigsoModule netigsoModule) {
        this.netigso.classLoaderDown(netigsoModule);
    }

    @Deprecated
    public Module create(File file, Object object, boolean bl, boolean bl2) throws IOException, DuplicateException {
        return this.create(file, object, bl, bl2, false);
    }

    public Module create(File file, Object object, boolean bl, boolean bl2, boolean bl3) throws IOException, DuplicateException {
        this.assertWritable();
        this.ev.log("startCreateRegularModule", file);
        Module module = this.moduleFactory.create(file.getAbsoluteFile(), object, bl, bl2, bl3, this, this.ev);
        this.ev.log("finishCreateRegularModule", file);
        this.subCreate(module);
        return module;
    }

    public Module createBundle(File file, Object object, boolean bl, boolean bl2, boolean bl3, int n) throws IOException, DuplicateException {
        this.assertWritable();
        this.ev.log("startCreateRegularModule", file);
        Module module = this.moduleFactory.create(file.getAbsoluteFile(), object, bl, bl2, bl3, this, this.ev);
        if (!(module instanceof NetigsoModule)) {
            throw new InvalidException("Expecting an OSGI bundle in " + file);
        }
        NetigsoModule netigsoModule = (NetigsoModule)module;
        netigsoModule.setStartLevel(n);
        this.ev.log("finishCreateRegularModule", file);
        this.subCreate(module);
        return module;
    }

    public Module createFixed(Manifest manifest, Object object, ClassLoader classLoader) throws InvalidException, DuplicateException {
        return this.createFixed(manifest, object, classLoader, false, false);
    }

    public Module createFixed(Manifest manifest, Object object, ClassLoader classLoader, boolean bl, boolean bl2) throws InvalidException, DuplicateException {
        this.assertWritable();
        if (manifest == null || classLoader == null) {
            throw new IllegalArgumentException("null manifest or loader");
        }
        this.ev.log("startCreateBootModule", object);
        Module module = this.moduleFactory.createFixed(manifest, object, classLoader, bl, bl2, this, this.ev);
        this.ev.log("finishCreateBootModule", object);
        this.subCreate(module);
        return module;
    }

    void refineDependencies(Module module, Set<Dependency> set) {
        this.installer.refineDependencies(module, set);
    }

    Set<Dependency> loadDependencies(String string) {
        return this.installer.loadDependencies(string);
    }

    String[] refineProvides(Module module) {
        return this.installer.refineProvides(module);
    }

    public void refineClassLoader(Module module, List list) {
        this.installer.refineClassLoader(module, list);
    }

    public boolean shouldDelegateResource(Module module, Module module2, String string) {
        Module.PackageExport[] packageExportArray;
        Module.PackageExport[] packageExportArray2 = packageExportArray = module2 == null ? null : module2.getPublicPackages();
        if (packageExportArray != null) {
            int n;
            boolean bl = false;
            if (module2.isDeclaredAsFriend(module)) {
                for (n = 0; n < packageExportArray.length; ++n) {
                    if (!(packageExportArray[n].recursive ? string.startsWith(packageExportArray[n].pkg) : string.equals(packageExportArray[n].pkg))) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                n = 0;
                Dependency[] dependencyArray = module.getDependenciesArray();
                for (int i = 0; i < dependencyArray.length; ++i) {
                    if (dependencyArray[i].getType() != 1 || dependencyArray[i].getComparison() != 2 || !dependencyArray[i].getName().equals(module2.getCodeName())) continue;
                    n = 1;
                    break;
                }
                if (n == 0) {
                    if (Util.err.isLoggable(Level.FINE)) {
                        Util.err.fine("Refusing to load non-public package " + string + " for " + (Object)((Object)module) + " from parent module " + (Object)((Object)module2) + " without an impl dependency");
                    }
                    return false;
                }
            }
        }
        if (string.startsWith("META-INF/")) {
            return false;
        }
        return this.installer.shouldDelegateResource(module, module2, string);
    }

    Manifest loadManifest(File file) throws IOException {
        return this.installer.loadManifest(file);
    }

    private void subCreate(Module module) throws DuplicateException {
        Module module2 = this.get(module.getCodeNameBase());
        if (module2 != null) {
            if (!Boolean.getBoolean("netbeans.ignore.dupmodule")) {
                throw new DuplicateException(module2, module);
            }
            Util.err.warning("Duplicate loading ignored: " + (Object)((Object)module2) + " and " + (Object)((Object)module));
            return;
        }
        this.modules.add(module);
        this.modulesByName.put(module.getCodeNameBase(), module);
        this.providersOf.possibleProviderAdded(module);
        this.lookup.add(module);
        this.firer.created(module);
        this.firer.change(new ChangeFirer.Change((Object)this, PROP_MODULES, null, null));
        this.clearProblemCache();
        this.firer.fire();
    }

    public void delete(Module module) throws IllegalArgumentException {
        this.assertWritable();
        if (module.isFixed()) {
            throw new IllegalArgumentException("fixed module: " + (Object)((Object)module));
        }
        if (module.isEnabled()) {
            throw new IllegalArgumentException("enabled module: " + (Object)((Object)module));
        }
        this.ev.log("deleteModule", new Object[]{module});
        this.modules.remove((Object)module);
        this.modulesByName.remove(module.getCodeNameBase());
        this.providersOf.possibleProviderRemoved(module);
        this.lookup.remove(module);
        this.firer.deleted(module);
        this.firer.change(new ChangeFirer.Change((Object)this, PROP_MODULES, null, null));
        this.firer.change(new ChangeFirer.Change((Object)module, "valid", Boolean.TRUE, Boolean.FALSE));
        this.clearProblemCache();
        module.destroy();
        this.firer.fire();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(Module module) throws IllegalArgumentException, IOException {
        this.assertWritable();
        Util.err.fine("reload: " + (Object)((Object)module));
        if (module.isFixed()) {
            throw new IllegalArgumentException("reload fixed module: " + (Object)((Object)module));
        }
        if (module.isEnabled()) {
            throw new IllegalArgumentException("reload enabled module: " + (Object)((Object)module));
        }
        this.providersOf.possibleProviderRemoved(module);
        try {
            module.reload();
        }
        catch (IOException iOException) {
            this.delete(module);
            throw iOException;
        }
        this.providersOf.possibleProviderAdded(module);
        this.firer.change(new ChangeFirer.Change((Object)module, "manifest", null, null));
        Object object = this.MODULE_PROBLEMS_LOCK;
        synchronized (object) {
            this.moduleProblemsWithoutNeeds.remove((Object)module);
            this.moduleProblemsWithNeeds.remove((Object)module);
        }
        this.firer.change(new ChangeFirer.Change((Object)module, "problems", null, null));
        this.clearProblemCache();
        this.firer.fire();
    }

    public final void enable(Module module) throws IllegalArgumentException, InvalidException {
        this.enable(module, true);
    }

    final void enable(Module module, boolean bl) throws IllegalArgumentException, InvalidException {
        this.enable(Collections.singleton(module), bl);
    }

    public final void disable(Module module) throws IllegalArgumentException {
        this.disable(Collections.singleton(module));
    }

    public void enable(Set<Module> set) throws IllegalArgumentException, InvalidException {
        this.enable(set, true);
    }

    /*
     * WARNING - void declaration
     */
    private void enable(Set<Module> set, boolean bl) throws IllegalArgumentException, InvalidException {
        Object object;
        this.assertWritable();
        Util.err.log(Level.FINE, "enable: {0}", set);
        this.ev.log("perfStart", "ModuleManager.enable");
        List<Module> list = this.simulateEnable(set, bl);
        this.ev.log("perfTick", "checked the required ordering and autoloads");
        Util.err.fine("enable: toEnable=" + list);
        Iterator<Module> iterator = new HashSet<Module>(list);
        if (!iterator.containsAll(set)) {
            HashSet<Module> hashSet = new HashSet<Module>(set);
            hashSet.removeAll((Collection<?>)((Object)iterator));
            throw new IllegalArgumentException("Not all requested modules can be enabled: " + hashSet);
        }
        Iterator iterator2 = iterator.iterator();
        while (iterator2.hasNext()) {
            object = (Module)((Object)iterator2.next());
            if (set.contains(object) || object.isAutoload() || object.isEager()) continue;
            throw new IllegalArgumentException("Would also need to enable " + (Object)object);
        }
        Util.err.fine("enable: verified dependencies");
        this.ev.log("perfTick", "verified dependencies");
        this.ev.log("startEnableModules", list);
        this.netigso.willEnable(list);
        while (true) {
            Set<Module> set2;
            Object object2;
            Object object422;
            iterator = new LinkedList();
            boolean bl2 = false;
            object = null;
            try {
                this.ev.log("perfStart", "module preparation");
                for (Object object422 : list) {
                    if (object422.isEnabled()) continue;
                    ((LinkedList)((Object)iterator)).addFirst(object422);
                    Util.err.fine("enable: bringing up: " + (Object)object422);
                    this.ev.log("perfStart", "bringing up classloader on " + object422.getCodeNameBase());
                    try {
                        Set<Module> iOException = this.calculateParents((Module)((Object)object422));
                        object422.classLoaderUp(iOException);
                    }
                    catch (IOException iOException) {
                        bl2 = true;
                        InvalidException invalidException = new InvalidException((Module)((Object)object422), iOException.toString());
                        invalidException.initCause(iOException);
                        throw invalidException;
                    }
                    object422.setEnabled(true);
                    this.ev.log("perfEnd", "bringing up classloader on " + object422.getCodeNameBase());
                    Util.err.fine("enable: checking package dependencies for " + (Object)object422);
                    Dependency[] dependencyArray = object422.getDependenciesArray();
                    for (int i = 0; i < dependencyArray.length; ++i) {
                        object2 = dependencyArray[i];
                        if (object2.getType() != 2) continue;
                        if (!Util.checkPackageDependency((Dependency)object2, object422.getClassLoader())) {
                            object = object2;
                            String string = (String)object422.getLocalizedAttribute("OpenIDE-Module-Package-Dependency-Message");
                            throw new InvalidException((Module)((Object)object422), "Dependency failed on " + (Object)object2, string);
                        }
                        Util.err.fine("Successful check for: " + (Object)object2);
                    }
                    this.ev.log("perfStart", "ModuleInstaller.prepare " + object422.getCodeName());
                    this.installer.prepare((Module)((Object)object422));
                    this.ev.log("perfEnd", "ModuleInstaller.prepare " + object422.getCodeName());
                }
                this.ev.log("perfEnd", "module preparation");
            }
            catch (InvalidException invalidException) {
                void var9_21;
                object422 = invalidException.getModule();
                if (object422 == null) {
                    throw new IllegalStateException("Problem with no associated module: " + invalidException, invalidException);
                }
                Set<Union2<Dependency, InvalidException>> set3 = this.moduleProblemsWithNeeds.get(object422);
                if (set3 == null) {
                    throw new IllegalStateException("Were trying to install a module that had never been checked: " + (Object)object422, invalidException);
                }
                if (!set3.isEmpty()) {
                    throw new IllegalStateException("Were trying to install a module that was known to be bad: " + (Object)object422 + " " + set3, invalidException);
                }
                if (set3 == EMPTY_COLLECTION) {
                    HashSet hashSet = new HashSet(8);
                    this.moduleProblemsWithNeeds.put((Module)((Object)object422), hashSet);
                }
                if (object != null) {
                    var9_21.add(Union2.createFirst((Object)object));
                } else {
                    var9_21.add(Union2.createSecond((Object)invalidException));
                }
                this.clearProblemCache();
                this.firer.change(new ChangeFirer.Change(object422, "problems", Collections.EMPTY_SET, Collections.singleton("something")));
                Util.err.fine("enable: will roll back from: " + invalidException);
                Iterator iterator3 = ((AbstractSequentialList)((Object)iterator)).iterator();
                while (iterator3.hasNext()) {
                    object2 = (Module)((Object)iterator3.next());
                    if (object2.isFixed()) continue;
                    object2.setEnabled(false);
                    if (bl2) {
                        bl2 = false;
                        continue;
                    }
                    object2.classLoaderDown();
                    System.gc();
                    System.runFinalization();
                    object2.cleanup();
                }
                this.firer.fire();
                throw invalidException;
            }
            if (this.classLoader != null) {
                Util.err.fine("enable: adding to system classloader");
                set2 = new LinkedList();
                if (this.moduleFactory.removeBaseClassLoader()) {
                    object422 = ModuleManager.class.getClassLoader();
                    ((LinkedList)((Object)set2)).add((Module)((Object)this.moduleFactory.getClasspathDelegateClassLoader(this, (ClassLoader)object422)));
                    for (Module module : list) {
                        object2 = module.getClassLoader();
                        if (object2 == object422) continue;
                        ((LinkedList)((Object)set2)).add((Module)((Object)object2));
                    }
                } else {
                    for (Module module : list) {
                        if (module.getClassLoader() == ClassLoader.getSystemClassLoader()) {
                            ((LinkedList)((Object)set2)).addFirst((Module)((Object)module.getClassLoader()));
                            continue;
                        }
                        ((LinkedList)((Object)set2)).add((Module)((Object)module.getClassLoader()));
                    }
                }
                this.classLoader.append(((LinkedList)((Object)set2)).toArray(new ClassLoader[((LinkedList)((Object)set2)).size()]));
                this.classLoader.size += list.size();
            } else {
                Util.err.fine("enable: no class loader yet, not appending");
            }
            Util.err.fine("enable: fixing classloader");
            this.installer.classLoaderUp(this.classLoader);
            Util.err.fine("enable: continuing to installation");
            set2 = this.netigso.turnOn(this.classLoader, Collections.unmodifiableCollection(new ArrayList<Module>(this.modules)));
            if (set2.isEmpty()) break;
            Util.err.log(Level.FINE, "netigso needs additional modules: {0}", set2);
            object422 = this.simulateEnable(set2, false);
            ModuleManager.checkMissingModules(set2, (List<Module>)object422);
            list.addAll((Collection<Module>)object422);
            Util.err.log(Level.FINE, "Adding {0} and trying again", object422);
        }
        if (!list.isEmpty() && ModuleManager.countEnabled(list) == 0) {
            throw new InvalidException("No module could be enabled: " + list);
        }
        this.installer.load(list);
        this.netigso.startFramework();
        for (Module module : list) {
            try {
                object = module.dataWithCheck().getAgentClass();
                if (object == null) continue;
                module.assignInstrumentation(NbInstrumentation.registerAgent(module.getClassLoader(), (String)object));
            }
            catch (InvalidException invalidException) {
                Util.err.log(Level.FINE, null, invalidException);
            }
        }
        Util.err.fine("enable: firing changes");
        this.firer.change(new ChangeFirer.Change((Object)this, PROP_ENABLED_MODULES, null, null));
        for (Module module : list) {
            this.firer.change(new ChangeFirer.Change((Object)module, "enabled", Boolean.FALSE, Boolean.TRUE));
            if (module.isFixed()) continue;
            this.firer.change(new ChangeFirer.Change((Object)module, PROP_CLASS_LOADER, null, null));
        }
        this.ev.log("finishEnableModules", list);
        this.firer.fire();
    }

    public void disable(Set<Module> set) throws IllegalArgumentException {
        this.assertWritable();
        Util.err.fine("disable: " + set);
        if (set.isEmpty()) {
            return;
        }
        List<Module> list = this.simulateDisable(set);
        Util.err.fine("disable: toDisable=" + list);
        for (Module module : list) {
            if (set.contains((Object)module) || module.isAutoload() || module.isEager()) continue;
            throw new IllegalArgumentException("Would also need to disable: " + (Object)((Object)module));
        }
        Util.err.fine("disable: verified dependencies");
        this.ev.log("startDisableModules", list);
        this.installer.unload(list);
        for (Module module : list) {
            this.installer.dispose(module);
            module.setEnabled(false);
            module.unregisterInstrumentation();
            module.classLoaderDown();
        }
        System.gc();
        System.runFinalization();
        for (Module module : list) {
            module.cleanup();
        }
        Util.err.fine("disable: finished, will notify changes");
        this.firer.change(new ChangeFirer.Change((Object)this, PROP_ENABLED_MODULES, null, null));
        this.invalidateClassLoader();
        for (Module module : list) {
            this.firer.change(new ChangeFirer.Change((Object)module, "enabled", Boolean.TRUE, Boolean.FALSE));
            this.firer.change(new ChangeFirer.Change((Object)module, PROP_CLASS_LOADER, null, null));
        }
        this.ev.log("finishDisableModules", list);
        this.firer.fire();
    }

    private final Set<Module> calculateParents(Module module) throws NumberFormatException, IOException {
        Dependency[] dependencyArray = module.getDependenciesArray();
        HashSet<Module> hashSet = new HashSet<Module>(dependencyArray.length * 4 / 3 + 1);
        for (int i = 0; i < dependencyArray.length; ++i) {
            Dependency dependency = dependencyArray[i];
            if (dependency.getType() != 1) continue;
            String string = (String)Util.parseCodeName(dependency.getName())[0];
            Module module2 = this.get(string);
            if (module2 == null) {
                throw new IOException("Parent " + string + " not found!");
            }
            hashSet.add(module2);
        }
        return hashSet;
    }

    public List<Module> simulateEnable(Set<Module> set) throws IllegalArgumentException {
        return this.simulateEnable(set, true);
    }

    final List<Module> simulateEnable(Set<Module> set, boolean bl) throws IllegalArgumentException {
        Object object;
        List<String> list = this.mdc.simulateEnable(set);
        if (list != null) {
            ArrayList<Module> arrayList = new ArrayList<Module>(list.size());
            for (String string : list) {
                arrayList.add(this.get(string));
            }
            assert (!arrayList.contains(null)) : arrayList;
            return arrayList;
        }
        TreeSet<Module> treeSet = new TreeSet<Module>(new CodeNameBaseComparator());
        for (Module object22 : set) {
            if (bl) {
                if (object22.isAutoload()) {
                    throw new IllegalArgumentException("Cannot simulate enabling an autoload: " + (Object)((Object)object22));
                }
                if (object22.isEager()) {
                    throw new IllegalArgumentException("Cannot simulate enabling an eager module: " + (Object)((Object)object22));
                }
            }
            if (object22.isEnabled()) {
                throw new IllegalArgumentException("Already enabled: " + (Object)((Object)object22));
            }
            if (!object22.isValid()) {
                throw new IllegalArgumentException("Not managed by me: " + (Object)((Object)object22) + " in " + (Object)((Object)object22));
            }
            this.maybeAddToEnableList(treeSet, set, object22, true);
        }
        HashSet<Module> hashSet = new HashSet<Module>(this.modules);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object = (Module)((Object)iterator.next());
            if (!object.isEnabled() && !treeSet.contains(object)) continue;
            iterator.remove();
        }
        while (this.searchForPossibleEager(treeSet, (Set<Module>)hashSet, set)) {
        }
        object = Util.moduleDependencies(treeSet, this.modulesByName, this.getProvidersOf());
        try {
            List topologicalSortException = Utilities.topologicalSort(treeSet, (Map)object);
            Collections.reverse(topologicalSortException);
            this.mdc.registerEnable(set, topologicalSortException);
            return topologicalSortException;
        }
        catch (TopologicalSortException topologicalSortException) {
            if (PRINT_TOPOLOGICAL_EXCEPTION_STACK_TRACES) {
                Util.err.log(Level.WARNING, null, topologicalSortException);
            }
            Util.err.warning("Cyclic module dependencies, will refuse to enable: " + (Object)object);
            return Collections.emptyList();
        }
    }

    private void maybeAddToEnableList(Set<Module> set, Set<Module> set2, Module module, boolean bl) {
        if (!this.missingDependencies(module).isEmpty()) {
            assert (bl) : "Module " + (Object)((Object)module) + " had unexpected problems: " + this.missingDependencies(module) + " (willEnable: " + set + " mightEnable: " + set2 + ")";
            return;
        }
        if (!set.add(module)) {
            return;
        }
        for (Dependency dependency : module.getDependenciesArray()) {
            Set<Module> set3;
            if (dependency.getType() == 1) {
                set3 = (String)Util.parseCodeName(dependency.getName())[0];
                Module module2 = this.get((String)((Object)set3));
                if (module2 == null) {
                    throw new IllegalStateException("Should have found module: " + (String)((Object)set3));
                }
                if (module2.isEnabled()) continue;
                this.maybeAddToEnableList(set, set2, module2, false);
                continue;
            }
            if (dependency.getType() != 5 && dependency.getType() != 6 && dependency.getType() != 7) continue;
            set3 = this.getProvidersOf().get(dependency.getName());
            if (set3 == null) {
                assert (dependency.getType() == 7) : "Should have found a provider of " + dependency;
                continue;
            }
            boolean bl2 = false;
            for (Module module3 : set3) {
                if (!module3.isEnabled() && (!module3.getProblems().isEmpty() || !set2.contains((Object)module3))) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            for (Module module3 : set3) {
                this.maybeAddToEnableList(set, set2, module3, true);
                if (bl2 || !set.contains((Object)module3)) continue;
                bl2 = true;
            }
            assert (bl2 || dependency.getType() == 7) : "Should have found a nonproblematic provider of " + dependency + " among " + set3 + " with willEnable=" + set + " mightEnable=" + set2;
        }
    }

    private boolean searchForPossibleEager(Set<Module> set, Set<Module> set2, Set<Module> set3) {
        boolean bl = false;
        Iterator<Module> iterator = set2.iterator();
        while (iterator.hasNext()) {
            Module module = iterator.next();
            if (set.contains((Object)module)) {
                iterator.remove();
                continue;
            }
            if (!module.isEager() || !this.couldBeEnabledWithEagers(module, set, new HashSet<Module>())) continue;
            bl = true;
            iterator.remove();
            this.maybeAddToEnableList(set, set3, module, false);
        }
        return bl;
    }

    private boolean couldBeEnabledWithEagers(Module module, Set<Module> set, Set<Module> set2) {
        if (module.isEnabled() || set.contains((Object)module)) {
            return true;
        }
        if (!module.isAutoload() && !module.isEager()) {
            return false;
        }
        if (!module.getProblems().isEmpty()) {
            return false;
        }
        if (!set2.add(module)) {
            return true;
        }
        Dependency[] dependencyArray = module.getDependenciesArray();
        for (int i = 0; i < dependencyArray.length; ++i) {
            Set<Module> set3;
            Dependency dependency = dependencyArray[i];
            if (dependency.getType() == 1) {
                set3 = (String)Util.parseCodeName(dependency.getName())[0];
                Module module2 = this.get((String)((Object)set3));
                if (module2 == null) {
                    throw new IllegalStateException("Should have found module: " + (String)((Object)set3));
                }
                if (this.couldBeEnabledWithEagers(module2, set, set2)) continue;
                return false;
            }
            if (dependency.getType() != 5 && dependency.getType() != 6) continue;
            set3 = this.getProvidersOf().get(dependency.getName());
            if (set3 == null) {
                throw new IllegalStateException("Should have found a provider of: " + dependency.getName());
            }
            boolean bl = false;
            for (Module module3 : set3) {
                if (!this.couldBeEnabledWithEagers(module3, set, set2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public List<Module> simulateJaveleonReload(Module module) throws IllegalArgumentException {
        HashSet<Module> hashSet = new HashSet<Module>(20);
        this.addToJaveleonDisableList(hashSet, module);
        Map<Module, List<Module>> map = Util.moduleDependencies(hashSet, this.modulesByName, this.getProvidersOf());
        try {
            LinkedList<Module> linkedList = new LinkedList<Module>();
            for (Module module2 : Utilities.topologicalSort(hashSet, map)) {
                if (module2 == module) continue;
                linkedList.addFirst(module2);
            }
            return linkedList;
        }
        catch (TopologicalSortException topologicalSortException) {
            return new ArrayList<Module>(hashSet);
        }
    }

    private void addToJaveleonDisableList(Set<Module> set, Module module) {
        if (set.contains((Object)module)) {
            return;
        }
        set.add(module);
        block0: for (Module module2 : this.modules) {
            if (!module2.isEnabled() || set.contains((Object)module2)) continue;
            Dependency[] dependencyArray = module2.getDependenciesArray();
            for (int i = 0; i < dependencyArray.length; ++i) {
                Dependency dependency = dependencyArray[i];
                if (dependency.getType() != 1 || !Util.parseCodeName(dependency.getName())[0].equals(module.getCodeNameBase())) continue;
                this.addToJaveleonDisableList(set, module2);
                continue block0;
            }
        }
    }

    public List<Module> simulateDisable(Set<Module> set) throws IllegalArgumentException {
        Object object2;
        if (set.isEmpty()) {
            return Collections.emptyList();
        }
        TreeSet<Module> treeSet = new TreeSet<Module>(new CodeNameBaseComparator());
        for (Object object2 : set) {
            if (object2.isAutoload()) {
                throw new IllegalArgumentException("Cannot disable autoload: " + (Object)object2);
            }
            if (object2.isEager()) {
                throw new IllegalArgumentException("Cannot disable eager module: " + (Object)object2);
            }
            if (object2.isFixed()) {
                throw new IllegalArgumentException("Cannot disable fixed module: " + (Object)object2);
            }
            if (!object2.isEnabled()) {
                throw new IllegalArgumentException("Already disabled: " + (Object)object2);
            }
            this.addToDisableList((Set<Module>)treeSet, (Module)((Object)object2));
        }
        HashSet<Module> hashSet = new HashSet<Module>(this.getEnabledModules());
        hashSet.removeAll(treeSet);
        while (this.searchForUnusedAutoloads(treeSet, (Set<Module>)hashSet)) {
        }
        object2 = Util.moduleDependencies(treeSet, this.modulesByName, this.getProvidersOf());
        try {
            return Utilities.topologicalSort(treeSet, (Map)object2);
        }
        catch (TopologicalSortException topologicalSortException) {
            if (PRINT_TOPOLOGICAL_EXCEPTION_STACK_TRACES) {
                Util.err.log(Level.WARNING, null, topologicalSortException);
            }
            Util.err.warning("Cyclic module dependencies, will turn them off in a random order: " + (Object)object2);
            return new ArrayList<Module>(treeSet);
        }
    }

    private void addToDisableList(Set<Module> set, Module module) {
        if (set.contains((Object)module)) {
            return;
        }
        set.add(module);
        block0: for (Module module2 : this.modules) {
            if (module2.isFixed() || !module2.isEnabled() || set.contains((Object)module2)) continue;
            Dependency[] dependencyArray = module2.getDependenciesArray();
            for (int i = 0; i < dependencyArray.length; ++i) {
                Dependency dependency = dependencyArray[i];
                if (dependency.getType() == 1) {
                    if (!Util.parseCodeName(dependency.getName())[0].equals(module.getCodeNameBase())) continue;
                    this.addToDisableList(set, module2);
                    continue block0;
                }
                if (dependency.getType() != 5 && dependency.getType() != 6 || !module.provides(dependency.getName())) continue;
                boolean bl = false;
                for (Module module3 : this.getEnabledModules()) {
                    if (!module3.isEnabled() || set.contains((Object)module3) || !module3.provides(dependency.getName())) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                this.addToDisableList(set, module2);
                continue block0;
            }
        }
    }

    private boolean searchForUnusedAutoloads(Set<Module> set, Set<Module> set2) {
        boolean bl = false;
        Iterator<Module> iterator = set2.iterator();
        block0: while (iterator.hasNext()) {
            Module module = iterator.next();
            if (!module.isAutoload()) continue;
            for (Module module2 : set2) {
                Dependency[] dependencyArray = module2.getDependenciesArray();
                for (int i = 0; i < dependencyArray.length; ++i) {
                    Dependency dependency = dependencyArray[i];
                    if (dependency.getType() == 1 ? Util.parseCodeName(dependency.getName())[0].equals(module.getCodeNameBase()) : (dependency.getType() == 5 || dependency.getType() == 6 || dependency.getType() == 7) && module.provides(dependency.getName())) continue block0;
                }
            }
            bl = true;
            iterator.remove();
            set.add(module);
        }
        return bl;
    }

    Set<Union2<Dependency, InvalidException>> missingDependencies(Module module) {
        return this.missingDependencies(module, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Union2<Dependency, InvalidException>> missingDependencies(Module module, boolean bl) {
        Object object = this.MODULE_PROBLEMS_LOCK;
        synchronized (object) {
            Map<Module, Set<Union2<Dependency, InvalidException>>> map = bl ? this.moduleProblemsWithNeeds : this.moduleProblemsWithoutNeeds;
            Set<Union2<Dependency, InvalidException>> set = map.get((Object)module);
            if (set == null) {
                set = new HashSet<Union2<Dependency, InvalidException>>(8);
                if (bl) {
                    set.addAll(this.missingDependencies(module, false));
                }
                set.add(PROBING_IN_PROCESS);
                map.put(module, set);
                for (Dependency dependency : module.getDependenciesArray()) {
                    int n;
                    Set<Module> set2;
                    Object object2;
                    if (dependency.getType() == 2) continue;
                    if (dependency.getType() == 1) {
                        object2 = Util.parseCodeName(dependency.getName());
                        set2 = (String)object2[0];
                        n = object2[1] != null ? (Integer)object2[1] : -1;
                        int n2 = object2[2] != null ? (Integer)object2[2] : n;
                        Module module2 = this.get((String)((Object)set2));
                        if (module2 == null) {
                            set.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)dependency));
                            continue;
                        }
                        SpecificationVersion specificationVersion = module2.getSpecificationVersion();
                        if (specificationVersion == null) {
                            specificationVersion = new SpecificationVersion("0");
                        }
                        if (n == n2) {
                            if (n != module2.getCodeNameRelease()) {
                                set.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)dependency));
                                continue;
                            }
                            if (dependency.getComparison() == 2 && !Utilities.compareObjects((Object)dependency.getVersion(), (Object)module2.getImplementationVersion())) {
                                set.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)dependency));
                                continue;
                            }
                            if (dependency.getComparison() == 1 && new SpecificationVersion(dependency.getVersion()).compareTo((Object)specificationVersion) > 0) {
                                set.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)dependency));
                                continue;
                            }
                        } else if (n < n2) {
                            int n3 = module2.getCodeNameRelease();
                            if (n3 < n || n3 > n2) {
                                set.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)dependency));
                                continue;
                            }
                            if (dependency.getComparison() == 2) {
                                throw new IllegalStateException("No such thing as ranged impl dep");
                            }
                            if (dependency.getComparison() == 1 && n3 == n && new SpecificationVersion(dependency.getVersion()).compareTo((Object)specificationVersion) > 0) {
                                set.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)dependency));
                                continue;
                            }
                        } else {
                            throw new IllegalStateException("Upside-down rel vers range");
                        }
                        if (module2.isEnabled() || (bl || this.missingDependencies(module2, false).isEmpty()) && (!bl || ModuleManager.isAlmostEmpty(this.missingDependencies(module2, true)))) continue;
                        set.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)dependency));
                        continue;
                    }
                    if (dependency.getType() == 5 || bl && dependency.getType() == 6) {
                        object2 = dependency.getName();
                        set2 = this.getProvidersOf().get(object2);
                        if (set2 == null) {
                            set.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)dependency));
                            continue;
                        }
                        n = 0;
                        for (Module module2 : set2) {
                            if (n != 0) break;
                            if (module2.isEnabled()) {
                                n = 1;
                                continue;
                            }
                            if ((bl || !this.missingDependencies(module2, false).isEmpty()) && (!bl || !ModuleManager.isAlmostEmpty(this.missingDependencies(module2, true)))) continue;
                            n = 1;
                        }
                        if (n != 0) continue;
                        set.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)dependency));
                        continue;
                    }
                    if (dependency.getType() != 3 || Util.checkJavaDependency(dependency)) continue;
                    set.add((Union2<Dependency, InvalidException>)Union2.createFirst((Object)dependency));
                }
                set.remove(PROBING_IN_PROCESS);
                if (set.isEmpty()) {
                    map.put(module, EMPTY_COLLECTION);
                }
            }
            return set;
        }
    }

    private static boolean isAlmostEmpty(Set<Union2<Dependency, InvalidException>> set) {
        return set.isEmpty() || set.equals(Collections.singleton(PROBING_IN_PROCESS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearProblemCache() {
        Object object = this.MODULE_PROBLEMS_LOCK;
        synchronized (object) {
            this.clearProblemCache(this.moduleProblemsWithoutNeeds);
            this.clearProblemCache(this.moduleProblemsWithNeeds);
        }
    }

    private void clearProblemCache(Map<Module, Set<Union2<Dependency, InvalidException>>> map) {
        Iterator<Map.Entry<Module, Set<Union2<Dependency, InvalidException>>>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Set<Union2<Dependency, InvalidException>> set;
            Map.Entry<Module, Set<Union2<Dependency, InvalidException>>> entry = iterator.next();
            Module module = entry.getKey();
            if (module.isEnabled() || (set = entry.getValue()) == null) continue;
            boolean bl = false;
            for (Union2<Dependency, InvalidException> union2 : set) {
                Dependency dependency;
                if (union2.hasSecond() || (dependency = (Dependency)union2.first()).getType() != 1 && dependency.getType() != 5 && dependency.getType() != 6 && dependency.getType() != 7) continue;
                bl = true;
                break;
            }
            if (!bl && !set.isEmpty()) continue;
            iterator.remove();
            this.firer.change(new ChangeFirer.Change((Object)module, "problems", null, null));
        }
    }

    public boolean shutDown() {
        return this.shutDown(null);
    }

    public boolean shutDown(Runnable runnable) {
        try {
            return this.shutDownAsync(runnable).get();
        }
        catch (InterruptedException interruptedException) {
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            Exceptions.printStackTrace((Throwable)executionException);
        }
        return false;
    }

    public Future<Boolean> shutDownAsync(Runnable runnable) {
        Object object2;
        this.assertWritable();
        Set<Module> set = this.getEnabledModules();
        HashMap<String, Set<Module>> hashMap = new HashMap<String, Set<Module>>();
        for (Object object2 : set) {
            ModuleManager.registerProviders(object2, hashMap);
        }
        Map<Module, List<Module>> map = Util.moduleDependencies(set, this.modulesByName, hashMap);
        try {
            object2 = Utilities.topologicalSort(set, (Map)map);
        }
        catch (TopologicalSortException topologicalSortException) {
            if (PRINT_TOPOLOGICAL_EXCEPTION_STACK_TRACES) {
                Util.err.log(Level.WARNING, null, topologicalSortException);
            }
            Util.err.warning("Cyclic module dependencies, will not shut down cleanly: " + map);
            return new TaskFuture(true, Task.EMPTY);
        }
        if (!TopSecurityManager.officialExit && !this.installer.closing((List<Module>)object2)) {
            return new TaskFuture(false, Task.EMPTY);
        }
        if (runnable != null) {
            try {
                runnable.run();
            }
            catch (RuntimeException runtimeException) {
                Util.err.log(Level.WARNING, null, runtimeException);
            }
            catch (LinkageError linkageError) {
                Util.err.log(Level.WARNING, null, linkageError);
            }
        }
        this.netigso.shutdownFramework();
        Task task = this.installer.closeAsync((List<Module>)object2);
        return new TaskFuture(true, task);
    }

    private class ModuleDataCache
    implements Stamps.Updater {
        private static final String CACHE = "all-manifests.dat";
        private final Map<String, byte[]> path2Data;
        private final Map<String, Boolean> path2OSGi;
        private final Map<String, String> path2Cnb;
        private final int moduleCount;
        private Set<String> toEnable;
        private List<String> willEnable;

        public ModuleDataCache() {
            char c;
            InputStream inputStream = Stamps.getModulesJARs().asStream(CACHE);
            HashMap<String, byte[]> hashMap = null;
            HashMap<String, Boolean> hashMap2 = null;
            HashMap<String, String> hashMap3 = null;
            Set set = null;
            List list = null;
            int n = -1;
            char c2 = c = File.separatorChar == '/' ? (char)'\\' : '/';
            if (inputStream != null) {
                try {
                    String string;
                    DataInputStream dataInputStream = new DataInputStream(inputStream);
                    String string2 = dataInputStream.readUTF();
                    String string3 = dataInputStream.readUTF();
                    if (!Locale.getDefault().toString().equals(string2)) {
                        throw new IOException();
                    }
                    if (!string3.equals(this.nonNullBranding())) {
                        throw new IOException();
                    }
                    hashMap = new HashMap<String, byte[]>();
                    hashMap2 = new HashMap<String, Boolean>();
                    hashMap3 = new HashMap<String, String>();
                    n = dataInputStream.readInt();
                    while (!(string = Stamps.readRelativePath(dataInputStream).replace(c, File.separatorChar)).isEmpty()) {
                        boolean bl = dataInputStream.readBoolean();
                        hashMap2.put(string, bl);
                        hashMap3.put(string, dataInputStream.readUTF());
                        int n2 = dataInputStream.readInt();
                        byte[] byArray = new byte[n2];
                        dataInputStream.readFully(byArray);
                        hashMap.put(string, byArray);
                    }
                    set = this.readCnbs(dataInputStream, new HashSet());
                    list = this.readCnbs(dataInputStream, new ArrayList());
                    dataInputStream.close();
                }
                catch (IOException iOException) {
                    Util.err.log(Level.FINE, "Cannot read " + Places.getCacheSubfile((String)CACHE), iOException);
                    hashMap = null;
                    hashMap2 = null;
                    hashMap3 = null;
                    set = null;
                    list = null;
                }
            }
            this.path2Data = hashMap;
            this.path2OSGi = hashMap2;
            this.path2Cnb = hashMap3;
            this.toEnable = set;
            this.willEnable = list;
            this.moduleCount = n;
            if (hashMap == null) {
                this.reset();
            }
        }

        public Boolean isOSGi(String string) {
            if (this.path2OSGi == null) {
                return null;
            }
            return this.path2OSGi.get(string);
        }

        public synchronized byte[] getModuleState(String string) {
            byte[] byArray = null;
            if (this.path2Data != null) {
                byArray = this.path2Data.remove(string);
            }
            if (byArray == null) {
                this.reset();
            }
            return byArray;
        }

        final String getCnb(String string) {
            return this.path2Cnb == null ? null : this.path2Cnb.get(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flushCaches(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeUTF(Locale.getDefault().toString());
            dataOutputStream.writeUTF(this.nonNullBranding());
            Set<Module> set = ModuleManager.this.getModules();
            dataOutputStream.writeInt(set.size());
            for (Module module : set) {
                File file = module.getJarFile();
                if (file == null) {
                    assert (module instanceof FixedModule) : "Only fixed modules are excluded from caches " + (Object)((Object)module);
                    continue;
                }
                Stamps.writeRelativePath(file.getPath(), dataOutputStream);
                dataOutputStream.writeBoolean(module.isNetigso());
                dataOutputStream.writeUTF(module.getCodeNameBase());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                module.writeData(objectOutputStream);
                objectOutputStream.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                dataOutputStream.writeInt(byArray.length);
                dataOutputStream.write(byArray);
            }
            Stamps.writeRelativePath("", dataOutputStream);
            ModuleDataCache moduleDataCache = this;
            synchronized (moduleDataCache) {
                this.writeCnbs(dataOutputStream, this.toEnable);
                this.writeCnbs(dataOutputStream, this.willEnable);
            }
        }

        @Override
        public void cacheReady() {
        }

        private synchronized void reset() {
            this.toEnable = null;
            this.willEnable = null;
        }

        final synchronized void registerEnable(Set<Module> set, List<Module> list) {
            this.toEnable = new HashSet<String>();
            for (Module object : set) {
                this.toEnable.add(object.getCodeNameBase());
            }
            ArrayList arrayList = new ArrayList(list.size());
            for (Module module : list) {
                arrayList.add(module.getCodeNameBase());
            }
            this.willEnable = Collections.unmodifiableList(arrayList);
            Stamps.getModulesJARs().scheduleSave(this, CACHE, false);
        }

        final synchronized List<String> simulateEnable(Set<Module> set) {
            if (this.toEnable != null && set.size() == this.toEnable.size() && this.moduleCount == ModuleManager.this.getModuleCount()) {
                HashSet<String> hashSet = new HashSet<String>(this.toEnable);
                for (Module module : set) {
                    if (hashSet.remove(module.getCodeNameBase())) continue;
                    return null;
                }
                if (hashSet.isEmpty()) {
                    return this.willEnable;
                }
            }
            return null;
        }

        private <T extends Collection<String>> T readCnbs(DataInputStream dataInputStream, T t) throws IOException {
            int n = dataInputStream.readInt();
            if (n == -1) {
                return null;
            }
            while (n-- > 0) {
                t.add((String)dataInputStream.readUTF());
            }
            return t;
        }

        private void writeCnbs(DataOutputStream dataOutputStream, Collection<String> collection) throws IOException {
            if (collection == null) {
                dataOutputStream.writeInt(-1);
                return;
            }
            dataOutputStream.writeInt(collection.size());
            for (String string : collection) {
                dataOutputStream.writeUTF(string);
            }
        }

        private String nonNullBranding() {
            String string = NbBundle.getBranding();
            return string == null ? "" : string;
        }
    }

    private static class CodeNameBaseComparator
    implements Comparator<Module> {
        private CodeNameBaseComparator() {
        }

        @Override
        public int compare(Module module, Module module2) {
            return module.getCodeNameBase().compareTo(module2.getCodeNameBase());
        }
    }

    private final class SystemClassLoader
    extends JarClassLoader {
        private final PermissionCollection allPermissions;
        int size;
        private final Set<String> JRE_PROVIDED_FACTORIES;

        public SystemClassLoader(List<File> list, ClassLoader[] classLoaderArray, Set<Module> set) throws IllegalArgumentException {
            super(list, classLoaderArray, false);
            this.JRE_PROVIDED_FACTORIES = new HashSet<String>(Arrays.asList("META-INF/services/javax.xml.parsers.SAXParserFactory", "META-INF/services/javax.xml.parsers.DocumentBuilderFactory", "META-INF/services/javax.xml.transform.TransformerFactory", "META-INF/services/javax.xml.validation.SchemaFactory"));
            this.allPermissions = new Permissions();
            this.allPermissions.add(new AllPermission());
            this.allPermissions.setReadOnly();
            this.size = set.size();
        }

        protected void finalize() throws Throwable {
            super.finalize();
            Util.err.fine("Collected system class loader");
        }

        public String toString() {
            return "SystemClassLoader[" + this.size + " modules]";
        }

        @Override
        protected PermissionCollection getPermissions(CodeSource codeSource) {
            return this.allPermissions;
        }

        @Override
        public InputStream getResourceAsStream(String string) {
            ClassLoader classLoader;
            if (this.JRE_PROVIDED_FACTORIES.contains(string)) {
                return new ByteArrayInputStream(new byte[0]);
            }
            InputStream inputStream = super.getResourceAsStream(string);
            if (inputStream == null && (classLoader = ModuleManager.this.netigso.findFallbackLoader()) != null && classLoader != this) {
                inputStream = classLoader.getResourceAsStream(string);
            }
            return inputStream;
        }

        @Override
        final URL getResourceImpl(String string) {
            ClassLoader classLoader;
            URL uRL = super.getResourceImpl(string);
            if (uRL == null && (classLoader = ModuleManager.this.netigso.findFallbackLoader()) != null && classLoader != this) {
                uRL = classLoader.getResource(string);
            }
            return uRL;
        }

        @Override
        synchronized Enumeration<URL> getResourcesImpl(String string) throws IOException {
            Enumeration<URL> enumeration = super.getResourcesImpl(string);
            ClassLoader classLoader = ModuleManager.this.netigso.findFallbackLoader();
            if (classLoader != null && classLoader != this) {
                return Enumerations.removeDuplicates((Enumeration)Enumerations.concat(enumeration, classLoader.getResources(string)));
            }
            return enumeration;
        }

        @Override
        protected boolean shouldDelegateResource(String string, ClassLoader classLoader) {
            ClassLoader classLoader2 = this.getParent();
            boolean bl = classLoader2 != null && classLoader2.getClass().getName().equals("com.sun.jnlp.JNLPClassLoader") ? false : (classLoader == null ? true : classLoader instanceof MainImpl.BootClassLoader);
            if (bl && !ModuleManager.this.installer.shouldDelegateClasspathResource(string)) {
                return false;
            }
            return super.shouldDelegateResource(string, classLoader);
        }

        @Override
        protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
            try {
                return super.loadClass(string, bl);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ClassLoader classLoader = ModuleManager.this.netigso.findFallbackLoader();
                if (classLoader == null || classLoader == this) {
                    throw classNotFoundException;
                }
                return Class.forName(string, bl, classLoader);
            }
        }
    }

    private class ProvidersOf {
        private Map<String, Set<Module>> providersOf;

        final synchronized Map<String, Set<Module>> getProvidersOf() {
            if (this.providersOf == null) {
                this.providersOf = new HashMap<String, Set<Module>>();
                for (Module module : ModuleManager.this.modules) {
                    this.possibleProviderAdded(module);
                }
            }
            return this.providersOf;
        }

        final synchronized void possibleProviderAdded(Module module) {
            if (this.providersOf == null) {
                return;
            }
            ModuleManager.registerProviders(module, this.providersOf);
        }

        final synchronized void possibleProviderRemoved(Module module) {
            if (this.providersOf == null) {
                return;
            }
            for (String string : module.getProvides()) {
                Set<Module> set = this.providersOf.get(string);
                if (set == null) continue;
                set.remove((Object)module);
                if (!set.isEmpty()) continue;
                this.providersOf.remove(string);
            }
        }
    }
}

