/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.common.plugins;

import freemind.extensions.PermanentNodeHookAdapter;
import freemind.main.XMLElement;
import freemind.modes.MindIcon;
import freemind.modes.MindMapNode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.Timer;

public abstract class ReminderHookBase
extends PermanentNodeHookAdapter {
    public static final String PLUGIN_LABEL = "plugins/TimeManagementReminder.xml";
    private static final int CLOCK_INVISIBLE = 0;
    private static final int CLOCK_VISIBLE = 1;
    private static final int REMOVE_CLOCK = -1;
    public static final String REMINDUSERAT = "REMINDUSERAT";
    private static final int BLINK_INTERVAL_IN_MILLIES = 3000;
    private long remindUserAt = 0L;
    private Timer timer;
    private static ImageIcon clockIcon = null;
    private static ImageIcon bellIcon;
    private static ImageIcon flagIcon;
    private final String STATE_TOOLTIP = TimerBlinkTask.class.getName() + "_STATE_";
    private String mStateTooltipName = null;

    @Override
    public void loadFrom(XMLElement child) {
        super.loadFrom(child);
        HashMap hash = this.loadNameValuePairs(child);
        if (hash.containsKey(REMINDUSERAT)) {
            String remindAt = (String)hash.get(REMINDUSERAT);
            this.setRemindUserAt(new Long(remindAt));
        }
    }

    @Override
    public void save(XMLElement xml) {
        super.save(xml);
        HashMap<String, Long> nameValuePairs = new HashMap<String, Long>();
        nameValuePairs.put(REMINDUSERAT, new Long(this.remindUserAt));
        this.saveNameValuePairs(nameValuePairs, xml);
    }

    @Override
    public void shutdownMapHook() {
        this.setToolTip(this.getNode(), this.getName(), null);
        if (this.timer != null) {
            this.timer.stop();
        }
        this.displayState(-1, this.getNode(), true);
        super.shutdownMapHook();
    }

    @Override
    public void invoke(MindMapNode node) {
        super.invoke(node);
        if (this.remindUserAt == 0L) {
            return;
        }
        if (this.timer == null) {
            this.scheduleTimer();
            Date date = new Date(this.remindUserAt);
            Object[] messageArguments = new Object[]{date};
            MessageFormat formatter = new MessageFormat(this.getResourceString("plugins/TimeManagement.xml_reminderNode_tooltip"));
            String message = formatter.format(messageArguments);
            this.setToolTip(node, this.getName(), message);
            this.displayState(1, this.getNode(), false);
        }
        this.logger.info("Invoke for node: " + node.getObjectId(this.getController()));
    }

    private void scheduleTimer() {
        this.timer = new Timer(this.getRemindUserAtAsSecondsFromNow(), new TimerBlinkTask(false));
        this.timer.setDelay(3000);
        this.timer.start();
    }

    private ImageIcon getClockIcon() {
        if (clockIcon == null) {
            clockIcon = MindIcon.factory("clock2").getIcon();
        }
        return clockIcon;
    }

    private ImageIcon getBellIcon() {
        if (bellIcon == null) {
            bellIcon = MindIcon.factory("bell").getIcon();
        }
        return bellIcon;
    }

    private ImageIcon getFlagIcon() {
        if (flagIcon == null) {
            flagIcon = MindIcon.factory("flag").getIcon();
        }
        return flagIcon;
    }

    public void displayState(int stateAdded, MindMapNode pNode, boolean recurse) {
        ImageIcon icon = null;
        if (stateAdded == 1) {
            icon = this.getClockIcon();
        } else if (stateAdded == 0) {
            icon = pNode == this.getNode() ? this.getBellIcon() : this.getFlagIcon();
        }
        pNode.setStateIcon(this.getStateKey(), icon);
        this.nodeRefresh(pNode);
        if (recurse && !pNode.isRoot()) {
            this.displayState(stateAdded, pNode.getParentNode(), recurse);
        }
    }

    protected abstract void nodeRefresh(MindMapNode var1);

    @Override
    protected abstract void setToolTip(MindMapNode var1, String var2, String var3);

    public long getRemindUserAt() {
        return this.remindUserAt;
    }

    public int getRemindUserAtAsSecondsFromNow() {
        long timeDiff = this.remindUserAt - System.currentTimeMillis();
        if (timeDiff > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (timeDiff < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)timeDiff;
    }

    public void setRemindUserAt(long remindUserAt) {
        this.remindUserAt = remindUserAt;
    }

    public String getStateKey() {
        if (this.mStateTooltipName == null) {
            this.mStateTooltipName = this.STATE_TOOLTIP;
        }
        return this.mStateTooltipName;
    }

    public class TimerBlinkTask
    implements ActionListener {
        private boolean stateAdded = false;

        public TimerBlinkTask(boolean stateAdded) {
            this.stateAdded = stateAdded;
        }

        @Override
        public void actionPerformed(ActionEvent pE) {
            int remindAt = ReminderHookBase.this.getRemindUserAtAsSecondsFromNow();
            if (remindAt > 3000) {
                ReminderHookBase.this.timer.stop();
                ReminderHookBase.this.scheduleTimer();
                return;
            }
            this.stateAdded = !this.stateAdded;
            ReminderHookBase.this.setRemindUserAt(System.currentTimeMillis() + 3000L);
            ReminderHookBase.this.displayState(this.stateAdded ? 1 : 0, ReminderHookBase.this.getNode(), true);
        }
    }
}

