/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.webserver;

import fi.iki.elonen.NanoHTTPD;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.StringTokenizer;
import org.fibs.geotag.webserver.ContextHandler;
import org.fibs.geotag.webserver.WebServer;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class MapHandler
implements ContextHandler {
    private static final I18n i18n = I18nFactory.getI18n(MapHandler.class);

    @Override
    public NanoHTTPD.Response serve(WebServer server, String uri, String method, Properties header, Properties parms) {
        InputStream stream = this.createPage(uri);
        if (stream != null) {
            WebServer webServer = server;
            webServer.getClass();
            NanoHTTPD.Response response = (NanoHTTPD)webServer.new NanoHTTPD.Response("200 OK", server.mimeType(uri), stream);
            try {
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return response;
        }
        WebServer webServer = server;
        webServer.getClass();
        return (NanoHTTPD)webServer.new NanoHTTPD.Response("404 Not Found", "text/plain", WebServer.FILE_NOT_FOUND);
    }

    public InputStream createPage(String uri) {
        StringBuilder page = new StringBuilder();
        try {
            String line;
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream("htdocs" + uri);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(stream));
            while ((line = bufferedReader.readLine()) != null) {
                if (line.startsWith("#includescript")) {
                    StringTokenizer tokenizer = new StringTokenizer(line);
                    tokenizer.nextToken();
                    String filename = tokenizer.nextToken();
                    page.append("<script type=\"text/javascript\">\n");
                    InputStream includeStream = this.getClass().getClassLoader().getResourceAsStream("htdocs/" + filename);
                    BufferedReader includeReader = new BufferedReader(new InputStreamReader(includeStream));
                    while ((line = includeReader.readLine()) != null) {
                        if (line.startsWith("//#includeI18N")) {
                            this.createJavascriptLanguageStrings(page);
                            continue;
                        }
                        page.append(line).append('\n');
                    }
                    includeReader.close();
                    page.append("</script>\n");
                    continue;
                }
                page.append(line).append('\n');
            }
            bufferedReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new ByteArrayInputStream(page.toString().getBytes());
    }

    private void createJavascriptLanguageStrings(StringBuilder page) {
        JavascriptVaraibles[] javascriptVaraiblesArray = JavascriptVaraibles.values();
        int n = javascriptVaraiblesArray.length;
        int n2 = 0;
        while (n2 < n) {
            JavascriptVaraibles variable = javascriptVaraiblesArray[n2];
            this.addVariable(page, variable);
            ++n2;
        }
    }

    private void addVariable(StringBuilder page, JavascriptVaraibles variable) {
        String value = i18n.tr(variable.getMessagesKey());
        StringBuffer buffer = new StringBuffer();
        int index = 0;
        while (index < value.length()) {
            char character = value.charAt(index);
            if (character < ' ' || character >= '\u0080' && character < '\u00a0' || character >= '\u2000' && character < '\u2100') {
                System.out.println("Invalid character at posistion " + index + " in " + value);
            }
            if (character < ' ' || character > '\u007f') {
                buffer.append("&#" + character + ";");
            } else {
                buffer.append(character);
            }
            ++index;
        }
        page.append("  var ").append(variable.toString()).append(" = '").append(buffer.toString()).append("'\n");
    }

    static /* synthetic */ I18n access$0() {
        return i18n;
    }

    private static enum JavascriptVaraibles {
        title("Geotag"),
        showMenuText(MapHandler.access$0().tr("Show <u>m</u>enu")),
        hideMenuText(MapHandler.access$0().tr("Hide <u>m</u>enu")),
        mouseZoomText(MapHandler.access$0().tr("Enable scroll wheel <u>z</u>oom")),
        showTracksText(MapHandler.access$0().tr("Display <u>t</u>racks")),
        showWikipediaText(MapHandler.access$0().tr("Show <u>W</u>ikipedia entries")),
        currentImageText(MapHandler.access$0().tr("Center on <u>c</u>urrent image")),
        nextImageText(MapHandler.access$0().tr("<u>N</u>ext image")),
        previousImageText(MapHandler.access$0().tr("<u>P</u>revious image")),
        showAllText(MapHandler.access$0().tr("Show <u>a</u>ll images")),
        instructions(MapHandler.access$0().tr("Move the marker to<br>select a different location.")),
        instructionsWithDirection(MapHandler.access$0().tr("Move camera marker to<br>select a different location.<br>Move other marker to<br>change image direction."));

        private final String messagesKey;

        private JavascriptVaraibles(String messagesKey) {
            this.messagesKey = JavascriptVaraibles.safeEncode(messagesKey);
        }

        public String getMessagesKey() {
            return this.messagesKey;
        }

        public static String safeEncode(String text) {
            StringBuffer buffer = new StringBuffer();
            int index = 0;
            while (index < text.length()) {
                char character = text.charAt(index);
                if (character == '\'') {
                    buffer.append("&#").append((int)character).append(";");
                } else {
                    buffer.append(character);
                }
                ++index;
            }
            return buffer.toString();
        }
    }
}

