/* -*-  mode:c; tab-width:8; c-basic-offset:8; indent-tabs-mode:nil;  -*- */
/*
 * The definitions in this file are based on RFC3530.
 */

/* RFC3530 contains the following copyright statement:


   Copyright (C) The Internet Society (2003).  All Rights Reserved.

   This document and translations of it may be copied and furnished to
   others, and derivative works that comment on or otherwise explain it
   or assist in its implementation may be prepared, copied, published
   and distributed, in whole or in part, without restriction of any
   kind, provided that the above copyright notice and this paragraph are
   included on all such copies and derivative works.  However, this
   document itself may not be modified in any way, such as by removing
   the copyright notice or references to the Internet Society or other
   Internet organizations, except as needed for the purpose of
   developing Internet standards in which case the procedures for
   copyrights defined in the Internet Standards process must be
   followed, or as required to translate it into languages other than
   English.

   The limited permissions granted above are perpetual and will not be
   revoked by the Internet Society or its successors or assigns.

   This document and the information contained herein is provided on an
   "AS IS" basis and THE INTERNET SOCIETY AND THE INTERNET ENGINEERING
/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#ifndef _NFS4_H_RPCGEN
#define _NFS4_H_RPCGEN

#include <nfsc/libnfs-zdr.h>


#ifdef __cplusplus
extern "C" {
#endif

#define NFS4_FHSIZE 128
#define NFS4_VERIFIER_SIZE 8
#define NFS4_OPAQUE_LIMIT 1024

enum nfs_ftype4 {
	NF4REG = 1,
	NF4DIR = 2,
	NF4BLK = 3,
	NF4CHR = 4,
	NF4LNK = 5,
	NF4SOCK = 6,
	NF4FIFO = 7,
	NF4ATTRDIR = 8,
	NF4NAMEDATTR = 9,
};
typedef enum nfs_ftype4 nfs_ftype4;

enum nfsstat4 {
	NFS4_OK = 0,
	NFS4ERR_PERM = 1,
	NFS4ERR_NOENT = 2,
	NFS4ERR_IO = 5,
	NFS4ERR_NXIO = 6,
	NFS4ERR_ACCESS = 13,
	NFS4ERR_EXIST = 17,
	NFS4ERR_XDEV = 18,
	NFS4ERR_NOTDIR = 20,
	NFS4ERR_ISDIR = 21,
	NFS4ERR_INVAL = 22,
	NFS4ERR_FBIG = 27,
	NFS4ERR_NOSPC = 28,
	NFS4ERR_ROFS = 30,
	NFS4ERR_MLINK = 31,
	NFS4ERR_NAMETOOLONG = 63,
	NFS4ERR_NOTEMPTY = 66,
	NFS4ERR_DQUOT = 69,
	NFS4ERR_STALE = 70,
	NFS4ERR_BADHANDLE = 10001,
	NFS4ERR_BAD_COOKIE = 10003,
	NFS4ERR_NOTSUPP = 10004,
	NFS4ERR_TOOSMALL = 10005,
	NFS4ERR_SERVERFAULT = 10006,
	NFS4ERR_BADTYPE = 10007,
	NFS4ERR_DELAY = 10008,
	NFS4ERR_SAME = 10009,
	NFS4ERR_DENIED = 10010,
	NFS4ERR_EXPIRED = 10011,
	NFS4ERR_LOCKED = 10012,
	NFS4ERR_GRACE = 10013,
	NFS4ERR_FHEXPIRED = 10014,
	NFS4ERR_SHARE_DENIED = 10015,
	NFS4ERR_WRONGSEC = 10016,
	NFS4ERR_CLID_INUSE = 10017,
	NFS4ERR_RESOURCE = 10018,
	NFS4ERR_MOVED = 10019,
	NFS4ERR_NOFILEHANDLE = 10020,
	NFS4ERR_MINOR_VERS_MISMATCH = 10021,
	NFS4ERR_STALE_CLIENTID = 10022,
	NFS4ERR_STALE_STATEID = 10023,
	NFS4ERR_OLD_STATEID = 10024,
	NFS4ERR_BAD_STATEID = 10025,
	NFS4ERR_BAD_SEQID = 10026,
	NFS4ERR_NOT_SAME = 10027,
	NFS4ERR_LOCK_RANGE = 10028,
	NFS4ERR_SYMLINK = 10029,
	NFS4ERR_RESTOREFH = 10030,
	NFS4ERR_LEASE_MOVED = 10031,
	NFS4ERR_ATTRNOTSUPP = 10032,
	NFS4ERR_NO_GRACE = 10033,
	NFS4ERR_RECLAIM_BAD = 10034,
	NFS4ERR_RECLAIM_CONFLICT = 10035,
	NFS4ERR_BADZDR = 10036,
	NFS4ERR_LOCKS_HELD = 10037,
	NFS4ERR_OPENMODE = 10038,
	NFS4ERR_BADOWNER = 10039,
	NFS4ERR_BADCHAR = 10040,
	NFS4ERR_BADNAME = 10041,
	NFS4ERR_BAD_RANGE = 10042,
	NFS4ERR_LOCK_NOTSUPP = 10043,
	NFS4ERR_OP_ILLEGAL = 10044,
	NFS4ERR_DEADLOCK = 10045,
	NFS4ERR_FILE_OPEN = 10046,
	NFS4ERR_ADMIN_REVOKED = 10047,
	NFS4ERR_CB_PATH_DOWN = 10048,
};
typedef enum nfsstat4 nfsstat4;

typedef struct {
	u_int bitmap4_len;
	uint32_t *bitmap4_val;
} bitmap4;

typedef uint64_t offset4;

typedef uint32_t count4;

typedef uint64_t length4;

typedef uint64_t clientid4;

typedef uint32_t seqid4;

typedef struct {
	u_int utf8string_len;
	char *utf8string_val;
} utf8string;

typedef utf8string utf8str_cis;

typedef utf8string utf8str_cs;

typedef utf8string utf8str_mixed;

typedef utf8str_cs component4;

typedef struct {
	u_int pathname4_len;
	component4 *pathname4_val;
} pathname4;

typedef uint64_t nfs_lockid4;

typedef uint64_t nfs_cookie4;

typedef utf8str_cs linktext4;

typedef struct {
	u_int sec_oid4_len;
	char *sec_oid4_val;
} sec_oid4;

typedef uint32_t qop4;

typedef uint32_t mode4;

typedef uint64_t changeid4;

typedef char verifier4[NFS4_VERIFIER_SIZE];

struct nfstime4 {
	int64_t seconds;
	uint32_t nseconds;
};
typedef struct nfstime4 nfstime4;

enum time_how4 {
	SET_TO_SERVER_TIME4 = 0,
	SET_TO_CLIENT_TIME4 = 1,
};
typedef enum time_how4 time_how4;

struct settime4 {
	time_how4 set_it;
	union {
		nfstime4 time;
	} settime4_u;
};
typedef struct settime4 settime4;

typedef struct {
	u_int nfs_fh4_len;
	char *nfs_fh4_val;
} nfs_fh4;

struct fsid4 {
	uint64_t major;
	uint64_t minor;
};
typedef struct fsid4 fsid4;

struct fs_location4 {
	struct {
		u_int server_len;
		utf8str_cis *server_val;
	} server;
	pathname4 rootpath;
};
typedef struct fs_location4 fs_location4;

struct fs_locations4 {
	pathname4 fs_root;
	struct {
		u_int locations_len;
		fs_location4 *locations_val;
	} locations;
};
typedef struct fs_locations4 fs_locations4;
#define ACL4_SUPPORT_ALLOW_ACL 0x00000001
#define ACL4_SUPPORT_DENY_ACL 0x00000002
#define ACL4_SUPPORT_AUDIT_ACL 0x00000004
#define ACL4_SUPPORT_ALARM_ACL 0x00000008

typedef uint32_t acetype4;
#define ACE4_ACCESS_ALLOWED_ACE_TYPE 0x00000000
#define ACE4_ACCESS_DENIED_ACE_TYPE 0x00000001
#define ACE4_SYSTEM_AUDIT_ACE_TYPE 0x00000002
#define ACE4_SYSTEM_ALARM_ACE_TYPE 0x00000003

typedef uint32_t aceflag4;
#define ACE4_FILE_INHERIT_ACE 0x00000001
#define ACE4_DIRECTORY_INHERIT_ACE 0x00000002
#define ACE4_NO_PROPAGATE_INHERIT_ACE 0x00000004
#define ACE4_INHERIT_ONLY_ACE 0x00000008
#define ACE4_SUCCESSFUL_ACCESS_ACE_FLAG 0x00000010
#define ACE4_FAILED_ACCESS_ACE_FLAG 0x00000020
#define ACE4_IDENTIFIER_GROUP 0x00000040

typedef uint32_t acemask4;
#define ACE4_READ_DATA 0x00000001
#define ACE4_LIST_DIRECTORY 0x00000001
#define ACE4_WRITE_DATA 0x00000002
#define ACE4_ADD_FILE 0x00000002
#define ACE4_APPEND_DATA 0x00000004
#define ACE4_ADD_SUBDIRECTORY 0x00000004
#define ACE4_READ_NAMED_ATTRS 0x00000008
#define ACE4_WRITE_NAMED_ATTRS 0x00000010
#define ACE4_EXECUTE 0x00000020
#define ACE4_DELETE_CHILD 0x00000040
#define ACE4_READ_ATTRIBUTES 0x00000080
#define ACE4_WRITE_ATTRIBUTES 0x00000100
#define ACE4_DELETE 0x00010000
#define ACE4_READ_ACL 0x00020000
#define ACE4_WRITE_ACL 0x00040000
#define ACE4_WRITE_OWNER 0x00080000
#define ACE4_SYNCHRONIZE 0x00100000
#define ACE4_GENERIC_READ 0x00120081
#define ACE4_GENERIC_WRITE 0x00160106
#define ACE4_GENERIC_EXECUTE 0x001200A0

struct nfsace4 {
	acetype4 type;
	aceflag4 flag;
	acemask4 access_mask;
	utf8str_mixed who;
};
typedef struct nfsace4 nfsace4;
#define MODE4_SUID 0x800
#define MODE4_SGID 0x400
#define MODE4_SVTX 0x200
#define MODE4_RUSR 0x100
#define MODE4_WUSR 0x080
#define MODE4_XUSR 0x040
#define MODE4_RGRP 0x020
#define MODE4_WGRP 0x010
#define MODE4_XGRP 0x008
#define MODE4_ROTH 0x004
#define MODE4_WOTH 0x002
#define MODE4_XOTH 0x001

struct specdata4 {
	uint32_t specdata1;
	uint32_t specdata2;
};
typedef struct specdata4 specdata4;
#define FH4_PERSISTENT 0x00000000
#define FH4_NOEXPIRE_WITH_OPEN 0x00000001
#define FH4_VOLATILE_ANY 0x00000002
#define FH4_VOL_MIGRATION 0x00000004
#define FH4_VOL_RENAME 0x00000008

typedef bitmap4 fattr4_supported_attrs;

typedef nfs_ftype4 fattr4_type;

typedef uint32_t fattr4_fh_expire_type;

typedef changeid4 fattr4_change;

typedef uint64_t fattr4_size;

typedef uint32_t fattr4_link_support;

typedef uint32_t fattr4_symlink_support;

typedef uint32_t fattr4_named_attr;

typedef fsid4 fattr4_fsid;

typedef uint32_t fattr4_unique_handles;

typedef uint32_t fattr4_lease_time;

typedef nfsstat4 fattr4_rdattr_error;

typedef struct {
	u_int fattr4_acl_len;
	nfsace4 *fattr4_acl_val;
} fattr4_acl;

typedef uint32_t fattr4_aclsupport;

typedef uint32_t fattr4_archive;

typedef uint32_t fattr4_cansettime;

typedef uint32_t fattr4_case_insensitive;

typedef uint32_t fattr4_case_preserving;

typedef uint32_t fattr4_chown_restricted;

typedef uint64_t fattr4_fileid;

typedef uint64_t fattr4_files_avail;

typedef nfs_fh4 fattr4_filehandle;

typedef uint64_t fattr4_files_free;

typedef uint64_t fattr4_files_total;

typedef fs_locations4 fattr4_fs_locations;

typedef uint32_t fattr4_hidden;

typedef uint32_t fattr4_homogeneous;

typedef uint64_t fattr4_maxfilesize;

typedef uint32_t fattr4_maxlink;

typedef uint32_t fattr4_maxname;

typedef uint64_t fattr4_maxread;

typedef uint64_t fattr4_maxwrite;

typedef utf8str_cs fattr4_mimetype;

typedef mode4 fattr4_mode;

typedef uint64_t fattr4_mounted_on_fileid;

typedef uint32_t fattr4_no_trunc;

typedef uint32_t fattr4_numlinks;

typedef utf8str_mixed fattr4_owner;

typedef utf8str_mixed fattr4_owner_group;

typedef uint64_t fattr4_quota_avail_hard;

typedef uint64_t fattr4_quota_avail_soft;

typedef uint64_t fattr4_quota_used;

typedef specdata4 fattr4_rawdev;

typedef uint64_t fattr4_space_avail;

typedef uint64_t fattr4_space_free;

typedef uint64_t fattr4_space_total;

typedef uint64_t fattr4_space_used;

typedef uint32_t fattr4_system;

typedef nfstime4 fattr4_time_access;

typedef settime4 fattr4_time_access_set;

typedef nfstime4 fattr4_time_backup;

typedef nfstime4 fattr4_time_create;

typedef nfstime4 fattr4_time_delta;

typedef nfstime4 fattr4_time_metadata;

typedef nfstime4 fattr4_time_modify;

typedef settime4 fattr4_time_modify_set;
#define FATTR4_SUPPORTED_ATTRS 0
#define FATTR4_TYPE 1
#define FATTR4_FH_EXPIRE_TYPE 2
#define FATTR4_CHANGE 3
#define FATTR4_SIZE 4
#define FATTR4_LINK_SUPPORT 5
#define FATTR4_SYMLINK_SUPPORT 6
#define FATTR4_NAMED_ATTR 7
#define FATTR4_FSID 8
#define FATTR4_UNIQUE_HANDLES 9
#define FATTR4_LEASE_TIME 10
#define FATTR4_RDATTR_ERROR 11
#define FATTR4_FILEHANDLE 19
#define FATTR4_ACL 12
#define FATTR4_ACLSUPPORT 13
#define FATTR4_ARCHIVE 14
#define FATTR4_CANSETTIME 15
#define FATTR4_CASE_INSENSITIVE 16
#define FATTR4_CASE_PRESERVING 17
#define FATTR4_CHOWN_RESTRICTED 18
#define FATTR4_FILEID 20
#define FATTR4_FILES_AVAIL 21
#define FATTR4_FILES_FREE 22
#define FATTR4_FILES_TOTAL 23
#define FATTR4_FS_LOCATIONS 24
#define FATTR4_HIDDEN 25
#define FATTR4_HOMOGENEOUS 26
#define FATTR4_MAXFILESIZE 27
#define FATTR4_MAXLINK 28
#define FATTR4_MAXNAME 29
#define FATTR4_MAXREAD 30
#define FATTR4_MAXWRITE 31
#define FATTR4_MIMETYPE 32
#define FATTR4_MODE 33
#define FATTR4_NO_TRUNC 34
#define FATTR4_NUMLINKS 35
#define FATTR4_OWNER 36
#define FATTR4_OWNER_GROUP 37
#define FATTR4_QUOTA_AVAIL_HARD 38
#define FATTR4_QUOTA_AVAIL_SOFT 39
#define FATTR4_QUOTA_USED 40
#define FATTR4_RAWDEV 41
#define FATTR4_SPACE_AVAIL 42
#define FATTR4_SPACE_FREE 43
#define FATTR4_SPACE_TOTAL 44
#define FATTR4_SPACE_USED 45
#define FATTR4_SYSTEM 46
#define FATTR4_TIME_ACCESS 47
#define FATTR4_TIME_ACCESS_SET 48
#define FATTR4_TIME_BACKUP 49
#define FATTR4_TIME_CREATE 50
#define FATTR4_TIME_DELTA 51
#define FATTR4_TIME_METADATA 52
#define FATTR4_TIME_MODIFY 53
#define FATTR4_TIME_MODIFY_SET 54
#define FATTR4_MOUNTED_ON_FILEID 55

typedef struct {
	u_int attrlist4_len;
	char *attrlist4_val;
} attrlist4;

struct fattr4 {
	bitmap4 attrmask;
	attrlist4 attr_vals;
};
typedef struct fattr4 fattr4;

struct change_info4 {
	uint32_t atomic;
	changeid4 before;
	changeid4 after;
};
typedef struct change_info4 change_info4;

struct clientaddr4 {
	char *r_netid;
	char *r_addr;
};
typedef struct clientaddr4 clientaddr4;

struct cb_client4 {
	uint32_t cb_program;
	clientaddr4 cb_location;
};
typedef struct cb_client4 cb_client4;

struct stateid4 {
	uint32_t seqid;
	char other[12];
};
typedef struct stateid4 stateid4;

struct nfs_client_id4 {
	verifier4 verifier;
	struct {
		u_int id_len;
		char *id_val;
	} id;
};
typedef struct nfs_client_id4 nfs_client_id4;

struct open_owner4 {
	clientid4 clientid;
	struct {
		u_int owner_len;
		char *owner_val;
	} owner;
};
typedef struct open_owner4 open_owner4;

struct lock_owner4 {
	clientid4 clientid;
	struct {
		u_int owner_len;
		char *owner_val;
	} owner;
};
typedef struct lock_owner4 lock_owner4;

enum nfs_lock_type4 {
	READ_LT = 1,
	WRITE_LT = 2,
	READW_LT = 3,
	WRITEW_LT = 4,
};
typedef enum nfs_lock_type4 nfs_lock_type4;
#define ACCESS4_READ 0x00000001
#define ACCESS4_LOOKUP 0x00000002
#define ACCESS4_MODIFY 0x00000004
#define ACCESS4_EXTEND 0x00000008
#define ACCESS4_DELETE 0x00000010
#define ACCESS4_EXECUTE 0x00000020

struct ACCESS4args {
	uint32_t access;
};
typedef struct ACCESS4args ACCESS4args;

struct ACCESS4resok {
	uint32_t supported;
	uint32_t access;
};
typedef struct ACCESS4resok ACCESS4resok;

struct ACCESS4res {
	nfsstat4 status;
	union {
		ACCESS4resok resok4;
	} ACCESS4res_u;
};
typedef struct ACCESS4res ACCESS4res;

struct CLOSE4args {
	seqid4 seqid;
	stateid4 open_stateid;
};
typedef struct CLOSE4args CLOSE4args;

struct CLOSE4res {
	nfsstat4 status;
	union {
		stateid4 open_stateid;
	} CLOSE4res_u;
};
typedef struct CLOSE4res CLOSE4res;

struct COMMIT4args {
	offset4 offset;
	count4 count;
};
typedef struct COMMIT4args COMMIT4args;

struct COMMIT4resok {
	verifier4 writeverf;
};
typedef struct COMMIT4resok COMMIT4resok;

struct COMMIT4res {
	nfsstat4 status;
	union {
		COMMIT4resok resok4;
	} COMMIT4res_u;
};
typedef struct COMMIT4res COMMIT4res;

struct createtype4 {
	nfs_ftype4 type;
	union {
		linktext4 linkdata;
		specdata4 devdata;
	} createtype4_u;
};
typedef struct createtype4 createtype4;

struct CREATE4args {
	createtype4 objtype;
	component4 objname;
	fattr4 createattrs;
};
typedef struct CREATE4args CREATE4args;

struct CREATE4resok {
	change_info4 cinfo;
	bitmap4 attrset;
};
typedef struct CREATE4resok CREATE4resok;

struct CREATE4res {
	nfsstat4 status;
	union {
		CREATE4resok resok4;
	} CREATE4res_u;
};
typedef struct CREATE4res CREATE4res;

struct DELEGPURGE4args {
	clientid4 clientid;
};
typedef struct DELEGPURGE4args DELEGPURGE4args;

struct DELEGPURGE4res {
	nfsstat4 status;
};
typedef struct DELEGPURGE4res DELEGPURGE4res;

struct DELEGRETURN4args {
	stateid4 deleg_stateid;
};
typedef struct DELEGRETURN4args DELEGRETURN4args;

struct DELEGRETURN4res {
	nfsstat4 status;
};
typedef struct DELEGRETURN4res DELEGRETURN4res;

struct GETATTR4args {
	bitmap4 attr_request;
};
typedef struct GETATTR4args GETATTR4args;

struct GETATTR4resok {
	fattr4 obj_attributes;
};
typedef struct GETATTR4resok GETATTR4resok;

struct GETATTR4res {
	nfsstat4 status;
	union {
		GETATTR4resok resok4;
	} GETATTR4res_u;
};
typedef struct GETATTR4res GETATTR4res;

struct GETFH4resok {
	nfs_fh4 object;
};
typedef struct GETFH4resok GETFH4resok;

struct GETFH4res {
	nfsstat4 status;
	union {
		GETFH4resok resok4;
	} GETFH4res_u;
};
typedef struct GETFH4res GETFH4res;

struct LINK4args {
	component4 newname;
};
typedef struct LINK4args LINK4args;

struct LINK4resok {
	change_info4 cinfo;
};
typedef struct LINK4resok LINK4resok;

struct LINK4res {
	nfsstat4 status;
	union {
		LINK4resok resok4;
	} LINK4res_u;
};
typedef struct LINK4res LINK4res;

struct open_to_lock_owner4 {
	seqid4 open_seqid;
	stateid4 open_stateid;
	seqid4 lock_seqid;
	lock_owner4 lock_owner;
};
typedef struct open_to_lock_owner4 open_to_lock_owner4;

struct exist_lock_owner4 {
	stateid4 lock_stateid;
	seqid4 lock_seqid;
};
typedef struct exist_lock_owner4 exist_lock_owner4;

struct locker4 {
	uint32_t new_lock_owner;
	union {
		open_to_lock_owner4 open_owner;
		exist_lock_owner4 lock_owner;
	} locker4_u;
};
typedef struct locker4 locker4;

struct LOCK4args {
	nfs_lock_type4 locktype;
	uint32_t reclaim;
	offset4 offset;
	length4 length;
	locker4 locker;
};
typedef struct LOCK4args LOCK4args;

struct LOCK4denied {
	offset4 offset;
	length4 length;
	nfs_lock_type4 locktype;
	lock_owner4 owner;
};
typedef struct LOCK4denied LOCK4denied;

struct LOCK4resok {
	stateid4 lock_stateid;
};
typedef struct LOCK4resok LOCK4resok;

struct LOCK4res {
	nfsstat4 status;
	union {
		LOCK4resok resok4;
		LOCK4denied denied;
	} LOCK4res_u;
};
typedef struct LOCK4res LOCK4res;

struct LOCKT4args {
	nfs_lock_type4 locktype;
	offset4 offset;
	length4 length;
	lock_owner4 owner;
};
typedef struct LOCKT4args LOCKT4args;

struct LOCKT4res {
	nfsstat4 status;
	union {
		LOCK4denied denied;
	} LOCKT4res_u;
};
typedef struct LOCKT4res LOCKT4res;

struct LOCKU4args {
	nfs_lock_type4 locktype;
	seqid4 seqid;
	stateid4 lock_stateid;
	offset4 offset;
	length4 length;
};
typedef struct LOCKU4args LOCKU4args;

struct LOCKU4res {
	nfsstat4 status;
	union {
		stateid4 lock_stateid;
	} LOCKU4res_u;
};
typedef struct LOCKU4res LOCKU4res;

struct LOOKUP4args {
	component4 objname;
};
typedef struct LOOKUP4args LOOKUP4args;

struct LOOKUP4res {
	nfsstat4 status;
};
typedef struct LOOKUP4res LOOKUP4res;

struct LOOKUPP4res {
	nfsstat4 status;
};
typedef struct LOOKUPP4res LOOKUPP4res;

struct NVERIFY4args {
	fattr4 obj_attributes;
};
typedef struct NVERIFY4args NVERIFY4args;

struct NVERIFY4res {
	nfsstat4 status;
};
typedef struct NVERIFY4res NVERIFY4res;

enum createmode4 {
	UNCHECKED4 = 0,
	GUARDED4 = 1,
	EXCLUSIVE4 = 2,
};
typedef enum createmode4 createmode4;

struct createhow4 {
	createmode4 mode;
	union {
		fattr4 createattrs;
		verifier4 createverf;
	} createhow4_u;
};
typedef struct createhow4 createhow4;

enum opentype4 {
	OPEN4_NOCREATE = 0,
	OPEN4_CREATE = 1,
};
typedef enum opentype4 opentype4;

struct openflag4 {
	opentype4 opentype;
	union {
		createhow4 how;
	} openflag4_u;
};
typedef struct openflag4 openflag4;

enum limit_by4 {
	NFS_LIMIT_SIZE = 1,
	NFS_LIMIT_BLOCKS = 2,
};
typedef enum limit_by4 limit_by4;

struct nfs_modified_limit4 {
	uint32_t num_blocks;
	uint32_t bytes_per_block;
};
typedef struct nfs_modified_limit4 nfs_modified_limit4;

struct nfs_space_limit4 {
	limit_by4 limitby;
	union {
		uint64_t filesize;
		nfs_modified_limit4 mod_blocks;
	} nfs_space_limit4_u;
};
typedef struct nfs_space_limit4 nfs_space_limit4;
#define OPEN4_SHARE_ACCESS_READ 0x00000001
#define OPEN4_SHARE_ACCESS_WRITE 0x00000002
#define OPEN4_SHARE_ACCESS_BOTH 0x00000003
#define OPEN4_SHARE_DENY_NONE 0x00000000
#define OPEN4_SHARE_DENY_READ 0x00000001
#define OPEN4_SHARE_DENY_WRITE 0x00000002
#define OPEN4_SHARE_DENY_BOTH 0x00000003

enum open_delegation_type4 {
	OPEN_DELEGATE_NONE = 0,
	OPEN_DELEGATE_READ = 1,
	OPEN_DELEGATE_WRITE = 2,
};
typedef enum open_delegation_type4 open_delegation_type4;

enum open_claim_type4 {
	CLAIM_NULL = 0,
	CLAIM_PREVIOUS = 1,
	CLAIM_DELEGATE_CUR = 2,
	CLAIM_DELEGATE_PREV = 3,
};
typedef enum open_claim_type4 open_claim_type4;

struct open_claim_delegate_cur4 {
	stateid4 delegate_stateid;
	component4 file;
};
typedef struct open_claim_delegate_cur4 open_claim_delegate_cur4;

struct open_claim4 {
	open_claim_type4 claim;
	union {
		component4 file;
		open_delegation_type4 delegate_type;
		open_claim_delegate_cur4 delegate_cur_info;
		component4 file_delegate_prev;
	} open_claim4_u;
};
typedef struct open_claim4 open_claim4;

struct OPEN4args {
	seqid4 seqid;
	uint32_t share_access;
	uint32_t share_deny;
	open_owner4 owner;
	openflag4 openhow;
	open_claim4 claim;
};
typedef struct OPEN4args OPEN4args;

struct open_read_delegation4 {
	stateid4 stateid;
	uint32_t recall;
	nfsace4 permissions;
};
typedef struct open_read_delegation4 open_read_delegation4;

struct open_write_delegation4 {
	stateid4 stateid;
	uint32_t recall;
	nfs_space_limit4 space_limit;
	nfsace4 permissions;
};
typedef struct open_write_delegation4 open_write_delegation4;

struct open_delegation4 {
	open_delegation_type4 delegation_type;
	union {
		open_read_delegation4 read;
		open_write_delegation4 write;
	} open_delegation4_u;
};
typedef struct open_delegation4 open_delegation4;
#define OPEN4_RESULT_CONFIRM 0x00000002
#define OPEN4_RESULT_LOCKTYPE_POSIX 0x00000004

struct OPEN4resok {
	stateid4 stateid;
	change_info4 cinfo;
	uint32_t rflags;
	bitmap4 attrset;
	open_delegation4 delegation;
};
typedef struct OPEN4resok OPEN4resok;

struct OPEN4res {
	nfsstat4 status;
	union {
		OPEN4resok resok4;
	} OPEN4res_u;
};
typedef struct OPEN4res OPEN4res;

struct OPENATTR4args {
	uint32_t createdir;
};
typedef struct OPENATTR4args OPENATTR4args;

struct OPENATTR4res {
	nfsstat4 status;
};
typedef struct OPENATTR4res OPENATTR4res;

struct OPEN_CONFIRM4args {
	stateid4 open_stateid;
	seqid4 seqid;
};
typedef struct OPEN_CONFIRM4args OPEN_CONFIRM4args;

struct OPEN_CONFIRM4resok {
	stateid4 open_stateid;
};
typedef struct OPEN_CONFIRM4resok OPEN_CONFIRM4resok;

struct OPEN_CONFIRM4res {
	nfsstat4 status;
	union {
		OPEN_CONFIRM4resok resok4;
	} OPEN_CONFIRM4res_u;
};
typedef struct OPEN_CONFIRM4res OPEN_CONFIRM4res;

struct OPEN_DOWNGRADE4args {
	stateid4 open_stateid;
	seqid4 seqid;
	uint32_t share_access;
	uint32_t share_deny;
};
typedef struct OPEN_DOWNGRADE4args OPEN_DOWNGRADE4args;

struct OPEN_DOWNGRADE4resok {
	stateid4 open_stateid;
};
typedef struct OPEN_DOWNGRADE4resok OPEN_DOWNGRADE4resok;

struct OPEN_DOWNGRADE4res {
	nfsstat4 status;
	union {
		OPEN_DOWNGRADE4resok resok4;
	} OPEN_DOWNGRADE4res_u;
};
typedef struct OPEN_DOWNGRADE4res OPEN_DOWNGRADE4res;

struct PUTFH4args {
	nfs_fh4 object;
};
typedef struct PUTFH4args PUTFH4args;

struct PUTFH4res {
	nfsstat4 status;
};
typedef struct PUTFH4res PUTFH4res;

struct PUTPUBFH4res {
	nfsstat4 status;
};
typedef struct PUTPUBFH4res PUTPUBFH4res;

struct PUTROOTFH4res {
	nfsstat4 status;
};
typedef struct PUTROOTFH4res PUTROOTFH4res;

struct READ4args {
	stateid4 stateid;
	offset4 offset;
	count4 count;
};
typedef struct READ4args READ4args;

struct READ4resok {
	uint32_t eof;
	struct {
		u_int data_len;
		char *data_val;
	} data;
};
typedef struct READ4resok READ4resok;

struct READ4res {
	nfsstat4 status;
	union {
		READ4resok resok4;
	} READ4res_u;
};
typedef struct READ4res READ4res;

struct READDIR4args {
	nfs_cookie4 cookie;
	verifier4 cookieverf;
	count4 dircount;
	count4 maxcount;
	bitmap4 attr_request;
};
typedef struct READDIR4args READDIR4args;

struct entry4 {
	nfs_cookie4 cookie;
	component4 name;
	fattr4 attrs;
	struct entry4 *nextentry;
};
typedef struct entry4 entry4;

struct dirlist4 {
	entry4 *entries;
	uint32_t eof;
};
typedef struct dirlist4 dirlist4;

struct READDIR4resok {
	verifier4 cookieverf;
	dirlist4 reply;
};
typedef struct READDIR4resok READDIR4resok;

struct READDIR4res {
	nfsstat4 status;
	union {
		READDIR4resok resok4;
	} READDIR4res_u;
};
typedef struct READDIR4res READDIR4res;

struct READLINK4resok {
	linktext4 link;
};
typedef struct READLINK4resok READLINK4resok;

struct READLINK4res {
	nfsstat4 status;
	union {
		READLINK4resok resok4;
	} READLINK4res_u;
};
typedef struct READLINK4res READLINK4res;

struct REMOVE4args {
	component4 target;
};
typedef struct REMOVE4args REMOVE4args;

struct REMOVE4resok {
	change_info4 cinfo;
};
typedef struct REMOVE4resok REMOVE4resok;

struct REMOVE4res {
	nfsstat4 status;
	union {
		REMOVE4resok resok4;
	} REMOVE4res_u;
};
typedef struct REMOVE4res REMOVE4res;

struct RENAME4args {
	component4 oldname;
	component4 newname;
};
typedef struct RENAME4args RENAME4args;

struct RENAME4resok {
	change_info4 source_cinfo;
	change_info4 target_cinfo;
};
typedef struct RENAME4resok RENAME4resok;

struct RENAME4res {
	nfsstat4 status;
	union {
		RENAME4resok resok4;
	} RENAME4res_u;
};
typedef struct RENAME4res RENAME4res;

struct RENEW4args {
	clientid4 clientid;
};
typedef struct RENEW4args RENEW4args;

struct RENEW4res {
	nfsstat4 status;
};
typedef struct RENEW4res RENEW4res;

struct RESTOREFH4res {
	nfsstat4 status;
};
typedef struct RESTOREFH4res RESTOREFH4res;

struct SAVEFH4res {
	nfsstat4 status;
};
typedef struct SAVEFH4res SAVEFH4res;

struct SETATTR4args {
	stateid4 stateid;
	fattr4 obj_attributes;
};
typedef struct SETATTR4args SETATTR4args;

struct SETATTR4res {
	nfsstat4 status;
	bitmap4 attrsset;
};
typedef struct SETATTR4res SETATTR4res;

struct SETCLIENTID4args {
	nfs_client_id4 client;
	cb_client4 callback;
	uint32_t callback_ident;
};
typedef struct SETCLIENTID4args SETCLIENTID4args;

struct SETCLIENTID4resok {
	clientid4 clientid;
	verifier4 setclientid_confirm;
};
typedef struct SETCLIENTID4resok SETCLIENTID4resok;

struct SETCLIENTID4res {
	nfsstat4 status;
	union {
		SETCLIENTID4resok resok4;
		clientaddr4 client_using;
	} SETCLIENTID4res_u;
};
typedef struct SETCLIENTID4res SETCLIENTID4res;

struct SETCLIENTID_CONFIRM4args {
	clientid4 clientid;
	verifier4 setclientid_confirm;
};
typedef struct SETCLIENTID_CONFIRM4args SETCLIENTID_CONFIRM4args;

struct SETCLIENTID_CONFIRM4res {
	nfsstat4 status;
};
typedef struct SETCLIENTID_CONFIRM4res SETCLIENTID_CONFIRM4res;

struct VERIFY4args {
	fattr4 obj_attributes;
};
typedef struct VERIFY4args VERIFY4args;

struct VERIFY4res {
	nfsstat4 status;
};
typedef struct VERIFY4res VERIFY4res;

enum stable_how4 {
	UNSTABLE4 = 0,
	DATA_SYNC4 = 1,
	FILE_SYNC4 = 2,
};
typedef enum stable_how4 stable_how4;

struct WRITE4args {
	stateid4 stateid;
	offset4 offset;
	stable_how4 stable;
	struct {
		u_int data_len;
		char *data_val;
	} data;
};
typedef struct WRITE4args WRITE4args;

struct WRITE4resok {
	count4 count;
	stable_how4 committed;
	verifier4 writeverf;
};
typedef struct WRITE4resok WRITE4resok;

struct WRITE4res {
	nfsstat4 status;
	union {
		WRITE4resok resok4;
	} WRITE4res_u;
};
typedef struct WRITE4res WRITE4res;

struct RELEASE_LOCKOWNER4args {
	lock_owner4 lock_owner;
};
typedef struct RELEASE_LOCKOWNER4args RELEASE_LOCKOWNER4args;

struct RELEASE_LOCKOWNER4res {
	nfsstat4 status;
};
typedef struct RELEASE_LOCKOWNER4res RELEASE_LOCKOWNER4res;

struct ILLEGAL4res {
	nfsstat4 status;
};
typedef struct ILLEGAL4res ILLEGAL4res;

enum nfs_opnum4 {
	OP_ACCESS = 3,
	OP_CLOSE = 4,
	OP_COMMIT = 5,
	OP_CREATE = 6,
	OP_DELEGPURGE = 7,
	OP_DELEGRETURN = 8,
	OP_GETATTR = 9,
	OP_GETFH = 10,
	OP_LINK = 11,
	OP_LOCK = 12,
	OP_LOCKT = 13,
	OP_LOCKU = 14,
	OP_LOOKUP = 15,
	OP_LOOKUPP = 16,
	OP_NVERIFY = 17,
	OP_OPEN = 18,
	OP_OPENATTR = 19,
	OP_OPEN_CONFIRM = 20,
	OP_OPEN_DOWNGRADE = 21,
	OP_PUTFH = 22,
	OP_PUTPUBFH = 23,
	OP_PUTROOTFH = 24,
	OP_READ = 25,
	OP_READDIR = 26,
	OP_READLINK = 27,
	OP_REMOVE = 28,
	OP_RENAME = 29,
	OP_RENEW = 30,
	OP_RESTOREFH = 31,
	OP_SAVEFH = 32,
	OP_SECINFO = 33,
	OP_SETATTR = 34,
	OP_SETCLIENTID = 35,
	OP_SETCLIENTID_CONFIRM = 36,
	OP_VERIFY = 37,
	OP_WRITE = 38,
	OP_RELEASE_LOCKOWNER = 39,
	OP_ILLEGAL = 10044,
};
typedef enum nfs_opnum4 nfs_opnum4;

struct nfs_argop4 {
	nfs_opnum4 argop;
	union {
		ACCESS4args opaccess;
		CLOSE4args opclose;
		COMMIT4args opcommit;
		CREATE4args opcreate;
		DELEGPURGE4args opdelegpurge;
		DELEGRETURN4args opdelegreturn;
		GETATTR4args opgetattr;
		LINK4args oplink;
		LOCK4args oplock;
		LOCKT4args oplockt;
		LOCKU4args oplocku;
		LOOKUP4args oplookup;
		NVERIFY4args opnverify;
		OPEN4args opopen;
		OPENATTR4args opopenattr;
		OPEN_CONFIRM4args opopen_confirm;
		OPEN_DOWNGRADE4args opopen_downgrade;
		PUTFH4args opputfh;
		READ4args opread;
		READDIR4args opreaddir;
		REMOVE4args opremove;
		RENAME4args oprename;
		RENEW4args oprenew;
		SETATTR4args opsetattr;
		SETCLIENTID4args opsetclientid;
		SETCLIENTID_CONFIRM4args opsetclientid_confirm;
		VERIFY4args opverify;
		WRITE4args opwrite;
		RELEASE_LOCKOWNER4args oprelease_lockowner;
	} nfs_argop4_u;
};
typedef struct nfs_argop4 nfs_argop4;

struct nfs_resop4 {
	nfs_opnum4 resop;
	union {
		ACCESS4res opaccess;
		CLOSE4res opclose;
		COMMIT4res opcommit;
		CREATE4res opcreate;
		DELEGPURGE4res opdelegpurge;
		DELEGRETURN4res opdelegreturn;
		GETATTR4res opgetattr;
		GETFH4res opgetfh;
		LINK4res oplink;
		LOCK4res oplock;
		LOCKT4res oplockt;
		LOCKU4res oplocku;
		LOOKUP4res oplookup;
		LOOKUPP4res oplookupp;
		NVERIFY4res opnverify;
		OPEN4res opopen;
		OPENATTR4res opopenattr;
		OPEN_CONFIRM4res opopen_confirm;
		OPEN_DOWNGRADE4res opopen_downgrade;
		PUTFH4res opputfh;
		PUTPUBFH4res opputpubfh;
		PUTROOTFH4res opputrootfh;
		READ4res opread;
		READDIR4res opreaddir;
		READLINK4res opreadlink;
		REMOVE4res opremove;
		RENAME4res oprename;
		RENEW4res oprenew;
		RESTOREFH4res oprestorefh;
		SAVEFH4res opsavefh;
		SETATTR4res opsetattr;
		SETCLIENTID4res opsetclientid;
		SETCLIENTID_CONFIRM4res opsetclientid_confirm;
		VERIFY4res opverify;
		WRITE4res opwrite;
		RELEASE_LOCKOWNER4res oprelease_lockowner;
		ILLEGAL4res opillegal;
	} nfs_resop4_u;
};
typedef struct nfs_resop4 nfs_resop4;

struct COMPOUND4args {
	utf8str_cs tag;
	uint32_t minorversion;
	struct {
		u_int argarray_len;
		nfs_argop4 *argarray_val;
	} argarray;
};
typedef struct COMPOUND4args COMPOUND4args;

struct COMPOUND4res {
	nfsstat4 status;
	utf8str_cs tag;
	struct {
		u_int resarray_len;
		nfs_resop4 *resarray_val;
	} resarray;
};
typedef struct COMPOUND4res COMPOUND4res;

struct CB_GETATTR4args {
	nfs_fh4 fh;
	bitmap4 attr_request;
};
typedef struct CB_GETATTR4args CB_GETATTR4args;

struct CB_GETATTR4resok {
	fattr4 obj_attributes;
};
typedef struct CB_GETATTR4resok CB_GETATTR4resok;

struct CB_GETATTR4res {
	nfsstat4 status;
	union {
		CB_GETATTR4resok resok4;
	} CB_GETATTR4res_u;
};
typedef struct CB_GETATTR4res CB_GETATTR4res;

struct CB_RECALL4args {
	stateid4 stateid;
	uint32_t truncate;
	nfs_fh4 fh;
};
typedef struct CB_RECALL4args CB_RECALL4args;

struct CB_RECALL4res {
	nfsstat4 status;
};
typedef struct CB_RECALL4res CB_RECALL4res;

struct CB_ILLEGAL4res {
	nfsstat4 status;
};
typedef struct CB_ILLEGAL4res CB_ILLEGAL4res;

enum nfs_cb_opnum4 {
	OP_CB_GETATTR = 3,
	OP_CB_RECALL = 4,
	OP_CB_ILLEGAL = 10044,
};
typedef enum nfs_cb_opnum4 nfs_cb_opnum4;

struct nfs_cb_argop4 {
	u_int argop;
	union {
		CB_GETATTR4args opcbgetattr;
		CB_RECALL4args opcbrecall;
	} nfs_cb_argop4_u;
};
typedef struct nfs_cb_argop4 nfs_cb_argop4;

struct nfs_cb_resop4 {
	u_int resop;
	union {
		CB_GETATTR4res opcbgetattr;
		CB_RECALL4res opcbrecall;
		CB_ILLEGAL4res opcbillegal;
	} nfs_cb_resop4_u;
};
typedef struct nfs_cb_resop4 nfs_cb_resop4;

struct CB_COMPOUND4args {
	utf8str_cs tag;
	uint32_t minorversion;
	uint32_t callback_ident;
	struct {
		u_int argarray_len;
		nfs_cb_argop4 *argarray_val;
	} argarray;
};
typedef struct CB_COMPOUND4args CB_COMPOUND4args;

struct CB_COMPOUND4res {
	nfsstat4 status;
	utf8str_cs tag;
	struct {
		u_int resarray_len;
		nfs_cb_resop4 *resarray_val;
	} resarray;
};
typedef struct CB_COMPOUND4res CB_COMPOUND4res;

#define NFS4_PROGRAM 100003
#define NFS_V4 4

#if defined(__STDC__) || defined(__cplusplus)
#define NFSPROC4_NULL 0
extern  void * nfsproc4_null_4(void *, void *);
extern  void * nfsproc4_null_4_svc(void *, struct svc_req *);
#define NFSPROC4_COMPOUND 1
extern  COMPOUND4res * nfsproc4_compound_4(COMPOUND4args *, void *);
extern  COMPOUND4res * nfsproc4_compound_4_svc(COMPOUND4args *, struct svc_req *);
extern int nfs4_program_4_freeresult (void *, zdrproc_t, caddr_t);

#else /* K&R C */
#define NFSPROC4_NULL 0
extern  void * nfsproc4_null_4();
extern  void * nfsproc4_null_4_svc();
#define NFSPROC4_COMPOUND 1
extern  COMPOUND4res * nfsproc4_compound_4();
extern  COMPOUND4res * nfsproc4_compound_4_svc();
extern int nfs4_program_4_freeresult ();
#endif /* K&R C */

#define NFS4_CALLBACK 0x40000000
#define NFS_CB 1

#if defined(__STDC__) || defined(__cplusplus)
#define CB_NULL 0
extern  void * cb_null_1(void *, void *);
extern  void * cb_null_1_svc(void *, struct svc_req *);
#define CB_COMPOUND 1
extern  CB_COMPOUND4res * cb_compound_1(CB_COMPOUND4args *, void *);
extern  CB_COMPOUND4res * cb_compound_1_svc(CB_COMPOUND4args *, struct svc_req *);
extern int nfs4_callback_1_freeresult (void *, zdrproc_t, caddr_t);

#else /* K&R C */
#define CB_NULL 0
extern  void * cb_null_1();
extern  void * cb_null_1_svc();
#define CB_COMPOUND 1
extern  CB_COMPOUND4res * cb_compound_1();
extern  CB_COMPOUND4res * cb_compound_1_svc();
extern int nfs4_callback_1_freeresult ();
#endif /* K&R C */

/* the zdr functions */

#if defined(__STDC__) || defined(__cplusplus)
extern  uint32_t zdr_nfs_ftype4 (ZDR *, nfs_ftype4*);
extern  uint32_t zdr_nfsstat4 (ZDR *, nfsstat4*);
extern  uint32_t zdr_bitmap4 (ZDR *, bitmap4*);
extern  uint32_t zdr_offset4 (ZDR *, offset4*);
extern  uint32_t zdr_count4 (ZDR *, count4*);
extern  uint32_t zdr_length4 (ZDR *, length4*);
extern  uint32_t zdr_clientid4 (ZDR *, clientid4*);
extern  uint32_t zdr_seqid4 (ZDR *, seqid4*);
extern  uint32_t zdr_utf8string (ZDR *, utf8string*);
extern  uint32_t zdr_utf8str_cis (ZDR *, utf8str_cis*);
extern  uint32_t zdr_utf8str_cs (ZDR *, utf8str_cs*);
extern  uint32_t zdr_utf8str_mixed (ZDR *, utf8str_mixed*);
extern  uint32_t zdr_component4 (ZDR *, component4*);
extern  uint32_t zdr_pathname4 (ZDR *, pathname4*);
extern  uint32_t zdr_nfs_lockid4 (ZDR *, nfs_lockid4*);
extern  uint32_t zdr_nfs_cookie4 (ZDR *, nfs_cookie4*);
extern  uint32_t zdr_linktext4 (ZDR *, linktext4*);
extern  uint32_t zdr_sec_oid4 (ZDR *, sec_oid4*);
extern  uint32_t zdr_qop4 (ZDR *, qop4*);
extern  uint32_t zdr_mode4 (ZDR *, mode4*);
extern  uint32_t zdr_changeid4 (ZDR *, changeid4*);
extern  uint32_t zdr_verifier4 (ZDR *, verifier4);
extern  uint32_t zdr_nfstime4 (ZDR *, nfstime4*);
extern  uint32_t zdr_time_how4 (ZDR *, time_how4*);
extern  uint32_t zdr_settime4 (ZDR *, settime4*);
extern  uint32_t zdr_nfs_fh4 (ZDR *, nfs_fh4*);
extern  uint32_t zdr_fsid4 (ZDR *, fsid4*);
extern  uint32_t zdr_fs_location4 (ZDR *, fs_location4*);
extern  uint32_t zdr_fs_locations4 (ZDR *, fs_locations4*);
extern  uint32_t zdr_acetype4 (ZDR *, acetype4*);
extern  uint32_t zdr_aceflag4 (ZDR *, aceflag4*);
extern  uint32_t zdr_acemask4 (ZDR *, acemask4*);
extern  uint32_t zdr_nfsace4 (ZDR *, nfsace4*);
extern  uint32_t zdr_specdata4 (ZDR *, specdata4*);
extern  uint32_t zdr_fattr4_supported_attrs (ZDR *, fattr4_supported_attrs*);
extern  uint32_t zdr_fattr4_type (ZDR *, fattr4_type*);
extern  uint32_t zdr_fattr4_fh_expire_type (ZDR *, fattr4_fh_expire_type*);
extern  uint32_t zdr_fattr4_change (ZDR *, fattr4_change*);
extern  uint32_t zdr_fattr4_size (ZDR *, fattr4_size*);
extern  uint32_t zdr_fattr4_link_support (ZDR *, fattr4_link_support*);
extern  uint32_t zdr_fattr4_symlink_support (ZDR *, fattr4_symlink_support*);
extern  uint32_t zdr_fattr4_named_attr (ZDR *, fattr4_named_attr*);
extern  uint32_t zdr_fattr4_fsid (ZDR *, fattr4_fsid*);
extern  uint32_t zdr_fattr4_unique_handles (ZDR *, fattr4_unique_handles*);
extern  uint32_t zdr_fattr4_lease_time (ZDR *, fattr4_lease_time*);
extern  uint32_t zdr_fattr4_rdattr_error (ZDR *, fattr4_rdattr_error*);
extern  uint32_t zdr_fattr4_acl (ZDR *, fattr4_acl*);
extern  uint32_t zdr_fattr4_aclsupport (ZDR *, fattr4_aclsupport*);
extern  uint32_t zdr_fattr4_archive (ZDR *, fattr4_archive*);
extern  uint32_t zdr_fattr4_cansettime (ZDR *, fattr4_cansettime*);
extern  uint32_t zdr_fattr4_case_insensitive (ZDR *, fattr4_case_insensitive*);
extern  uint32_t zdr_fattr4_case_preserving (ZDR *, fattr4_case_preserving*);
extern  uint32_t zdr_fattr4_chown_restricted (ZDR *, fattr4_chown_restricted*);
extern  uint32_t zdr_fattr4_fileid (ZDR *, fattr4_fileid*);
extern  uint32_t zdr_fattr4_files_avail (ZDR *, fattr4_files_avail*);
extern  uint32_t zdr_fattr4_filehandle (ZDR *, fattr4_filehandle*);
extern  uint32_t zdr_fattr4_files_free (ZDR *, fattr4_files_free*);
extern  uint32_t zdr_fattr4_files_total (ZDR *, fattr4_files_total*);
extern  uint32_t zdr_fattr4_fs_locations (ZDR *, fattr4_fs_locations*);
extern  uint32_t zdr_fattr4_hidden (ZDR *, fattr4_hidden*);
extern  uint32_t zdr_fattr4_homogeneous (ZDR *, fattr4_homogeneous*);
extern  uint32_t zdr_fattr4_maxfilesize (ZDR *, fattr4_maxfilesize*);
extern  uint32_t zdr_fattr4_maxlink (ZDR *, fattr4_maxlink*);
extern  uint32_t zdr_fattr4_maxname (ZDR *, fattr4_maxname*);
extern  uint32_t zdr_fattr4_maxread (ZDR *, fattr4_maxread*);
extern  uint32_t zdr_fattr4_maxwrite (ZDR *, fattr4_maxwrite*);
extern  uint32_t zdr_fattr4_mimetype (ZDR *, fattr4_mimetype*);
extern  uint32_t zdr_fattr4_mode (ZDR *, fattr4_mode*);
extern  uint32_t zdr_fattr4_mounted_on_fileid (ZDR *, fattr4_mounted_on_fileid*);
extern  uint32_t zdr_fattr4_no_trunc (ZDR *, fattr4_no_trunc*);
extern  uint32_t zdr_fattr4_numlinks (ZDR *, fattr4_numlinks*);
extern  uint32_t zdr_fattr4_owner (ZDR *, fattr4_owner*);
extern  uint32_t zdr_fattr4_owner_group (ZDR *, fattr4_owner_group*);
extern  uint32_t zdr_fattr4_quota_avail_hard (ZDR *, fattr4_quota_avail_hard*);
extern  uint32_t zdr_fattr4_quota_avail_soft (ZDR *, fattr4_quota_avail_soft*);
extern  uint32_t zdr_fattr4_quota_used (ZDR *, fattr4_quota_used*);
extern  uint32_t zdr_fattr4_rawdev (ZDR *, fattr4_rawdev*);
extern  uint32_t zdr_fattr4_space_avail (ZDR *, fattr4_space_avail*);
extern  uint32_t zdr_fattr4_space_free (ZDR *, fattr4_space_free*);
extern  uint32_t zdr_fattr4_space_total (ZDR *, fattr4_space_total*);
extern  uint32_t zdr_fattr4_space_used (ZDR *, fattr4_space_used*);
extern  uint32_t zdr_fattr4_system (ZDR *, fattr4_system*);
extern  uint32_t zdr_fattr4_time_access (ZDR *, fattr4_time_access*);
extern  uint32_t zdr_fattr4_time_access_set (ZDR *, fattr4_time_access_set*);
extern  uint32_t zdr_fattr4_time_backup (ZDR *, fattr4_time_backup*);
extern  uint32_t zdr_fattr4_time_create (ZDR *, fattr4_time_create*);
extern  uint32_t zdr_fattr4_time_delta (ZDR *, fattr4_time_delta*);
extern  uint32_t zdr_fattr4_time_metadata (ZDR *, fattr4_time_metadata*);
extern  uint32_t zdr_fattr4_time_modify (ZDR *, fattr4_time_modify*);
extern  uint32_t zdr_fattr4_time_modify_set (ZDR *, fattr4_time_modify_set*);
extern  uint32_t zdr_attrlist4 (ZDR *, attrlist4*);
extern  uint32_t zdr_fattr4 (ZDR *, fattr4*);
extern  uint32_t zdr_change_info4 (ZDR *, change_info4*);
extern  uint32_t zdr_clientaddr4 (ZDR *, clientaddr4*);
extern  uint32_t zdr_cb_client4 (ZDR *, cb_client4*);
extern  uint32_t zdr_stateid4 (ZDR *, stateid4*);
extern  uint32_t zdr_nfs_client_id4 (ZDR *, nfs_client_id4*);
extern  uint32_t zdr_open_owner4 (ZDR *, open_owner4*);
extern  uint32_t zdr_lock_owner4 (ZDR *, lock_owner4*);
extern  uint32_t zdr_nfs_lock_type4 (ZDR *, nfs_lock_type4*);
extern  uint32_t zdr_ACCESS4args (ZDR *, ACCESS4args*);
extern  uint32_t zdr_ACCESS4resok (ZDR *, ACCESS4resok*);
extern  uint32_t zdr_ACCESS4res (ZDR *, ACCESS4res*);
extern  uint32_t zdr_CLOSE4args (ZDR *, CLOSE4args*);
extern  uint32_t zdr_CLOSE4res (ZDR *, CLOSE4res*);
extern  uint32_t zdr_COMMIT4args (ZDR *, COMMIT4args*);
extern  uint32_t zdr_COMMIT4resok (ZDR *, COMMIT4resok*);
extern  uint32_t zdr_COMMIT4res (ZDR *, COMMIT4res*);
extern  uint32_t zdr_createtype4 (ZDR *, createtype4*);
extern  uint32_t zdr_CREATE4args (ZDR *, CREATE4args*);
extern  uint32_t zdr_CREATE4resok (ZDR *, CREATE4resok*);
extern  uint32_t zdr_CREATE4res (ZDR *, CREATE4res*);
extern  uint32_t zdr_DELEGPURGE4args (ZDR *, DELEGPURGE4args*);
extern  uint32_t zdr_DELEGPURGE4res (ZDR *, DELEGPURGE4res*);
extern  uint32_t zdr_DELEGRETURN4args (ZDR *, DELEGRETURN4args*);
extern  uint32_t zdr_DELEGRETURN4res (ZDR *, DELEGRETURN4res*);
extern  uint32_t zdr_GETATTR4args (ZDR *, GETATTR4args*);
extern  uint32_t zdr_GETATTR4resok (ZDR *, GETATTR4resok*);
extern  uint32_t zdr_GETATTR4res (ZDR *, GETATTR4res*);
extern  uint32_t zdr_GETFH4resok (ZDR *, GETFH4resok*);
extern  uint32_t zdr_GETFH4res (ZDR *, GETFH4res*);
extern  uint32_t zdr_LINK4args (ZDR *, LINK4args*);
extern  uint32_t zdr_LINK4resok (ZDR *, LINK4resok*);
extern  uint32_t zdr_LINK4res (ZDR *, LINK4res*);
extern  uint32_t zdr_open_to_lock_owner4 (ZDR *, open_to_lock_owner4*);
extern  uint32_t zdr_exist_lock_owner4 (ZDR *, exist_lock_owner4*);
extern  uint32_t zdr_locker4 (ZDR *, locker4*);
extern  uint32_t zdr_LOCK4args (ZDR *, LOCK4args*);
extern  uint32_t zdr_LOCK4denied (ZDR *, LOCK4denied*);
extern  uint32_t zdr_LOCK4resok (ZDR *, LOCK4resok*);
extern  uint32_t zdr_LOCK4res (ZDR *, LOCK4res*);
extern  uint32_t zdr_LOCKT4args (ZDR *, LOCKT4args*);
extern  uint32_t zdr_LOCKT4res (ZDR *, LOCKT4res*);
extern  uint32_t zdr_LOCKU4args (ZDR *, LOCKU4args*);
extern  uint32_t zdr_LOCKU4res (ZDR *, LOCKU4res*);
extern  uint32_t zdr_LOOKUP4args (ZDR *, LOOKUP4args*);
extern  uint32_t zdr_LOOKUP4res (ZDR *, LOOKUP4res*);
extern  uint32_t zdr_LOOKUPP4res (ZDR *, LOOKUPP4res*);
extern  uint32_t zdr_NVERIFY4args (ZDR *, NVERIFY4args*);
extern  uint32_t zdr_NVERIFY4res (ZDR *, NVERIFY4res*);
extern  uint32_t zdr_createmode4 (ZDR *, createmode4*);
extern  uint32_t zdr_createhow4 (ZDR *, createhow4*);
extern  uint32_t zdr_opentype4 (ZDR *, opentype4*);
extern  uint32_t zdr_openflag4 (ZDR *, openflag4*);
extern  uint32_t zdr_limit_by4 (ZDR *, limit_by4*);
extern  uint32_t zdr_nfs_modified_limit4 (ZDR *, nfs_modified_limit4*);
extern  uint32_t zdr_nfs_space_limit4 (ZDR *, nfs_space_limit4*);
extern  uint32_t zdr_open_delegation_type4 (ZDR *, open_delegation_type4*);
extern  uint32_t zdr_open_claim_type4 (ZDR *, open_claim_type4*);
extern  uint32_t zdr_open_claim_delegate_cur4 (ZDR *, open_claim_delegate_cur4*);
extern  uint32_t zdr_open_claim4 (ZDR *, open_claim4*);
extern  uint32_t zdr_OPEN4args (ZDR *, OPEN4args*);
extern  uint32_t zdr_open_read_delegation4 (ZDR *, open_read_delegation4*);
extern  uint32_t zdr_open_write_delegation4 (ZDR *, open_write_delegation4*);
extern  uint32_t zdr_open_delegation4 (ZDR *, open_delegation4*);
extern  uint32_t zdr_OPEN4resok (ZDR *, OPEN4resok*);
extern  uint32_t zdr_OPEN4res (ZDR *, OPEN4res*);
extern  uint32_t zdr_OPENATTR4args (ZDR *, OPENATTR4args*);
extern  uint32_t zdr_OPENATTR4res (ZDR *, OPENATTR4res*);
extern  uint32_t zdr_OPEN_CONFIRM4args (ZDR *, OPEN_CONFIRM4args*);
extern  uint32_t zdr_OPEN_CONFIRM4resok (ZDR *, OPEN_CONFIRM4resok*);
extern  uint32_t zdr_OPEN_CONFIRM4res (ZDR *, OPEN_CONFIRM4res*);
extern  uint32_t zdr_OPEN_DOWNGRADE4args (ZDR *, OPEN_DOWNGRADE4args*);
extern  uint32_t zdr_OPEN_DOWNGRADE4resok (ZDR *, OPEN_DOWNGRADE4resok*);
extern  uint32_t zdr_OPEN_DOWNGRADE4res (ZDR *, OPEN_DOWNGRADE4res*);
extern  uint32_t zdr_PUTFH4args (ZDR *, PUTFH4args*);
extern  uint32_t zdr_PUTFH4res (ZDR *, PUTFH4res*);
extern  uint32_t zdr_PUTPUBFH4res (ZDR *, PUTPUBFH4res*);
extern  uint32_t zdr_PUTROOTFH4res (ZDR *, PUTROOTFH4res*);
extern  uint32_t zdr_READ4args (ZDR *, READ4args*);
extern  uint32_t zdr_READ4resok (ZDR *, READ4resok*);
extern  uint32_t zdr_READ4res (ZDR *, READ4res*);
extern  uint32_t zdr_READDIR4args (ZDR *, READDIR4args*);
extern  uint32_t zdr_entry4 (ZDR *, entry4*);
extern  uint32_t zdr_dirlist4 (ZDR *, dirlist4*);
extern  uint32_t zdr_READDIR4resok (ZDR *, READDIR4resok*);
extern  uint32_t zdr_READDIR4res (ZDR *, READDIR4res*);
extern  uint32_t zdr_READLINK4resok (ZDR *, READLINK4resok*);
extern  uint32_t zdr_READLINK4res (ZDR *, READLINK4res*);
extern  uint32_t zdr_REMOVE4args (ZDR *, REMOVE4args*);
extern  uint32_t zdr_REMOVE4resok (ZDR *, REMOVE4resok*);
extern  uint32_t zdr_REMOVE4res (ZDR *, REMOVE4res*);
extern  uint32_t zdr_RENAME4args (ZDR *, RENAME4args*);
extern  uint32_t zdr_RENAME4resok (ZDR *, RENAME4resok*);
extern  uint32_t zdr_RENAME4res (ZDR *, RENAME4res*);
extern  uint32_t zdr_RENEW4args (ZDR *, RENEW4args*);
extern  uint32_t zdr_RENEW4res (ZDR *, RENEW4res*);
extern  uint32_t zdr_RESTOREFH4res (ZDR *, RESTOREFH4res*);
extern  uint32_t zdr_SAVEFH4res (ZDR *, SAVEFH4res*);
extern  uint32_t zdr_SETATTR4args (ZDR *, SETATTR4args*);
extern  uint32_t zdr_SETATTR4res (ZDR *, SETATTR4res*);
extern  uint32_t zdr_SETCLIENTID4args (ZDR *, SETCLIENTID4args*);
extern  uint32_t zdr_SETCLIENTID4resok (ZDR *, SETCLIENTID4resok*);
extern  uint32_t zdr_SETCLIENTID4res (ZDR *, SETCLIENTID4res*);
extern  uint32_t zdr_SETCLIENTID_CONFIRM4args (ZDR *, SETCLIENTID_CONFIRM4args*);
extern  uint32_t zdr_SETCLIENTID_CONFIRM4res (ZDR *, SETCLIENTID_CONFIRM4res*);
extern  uint32_t zdr_VERIFY4args (ZDR *, VERIFY4args*);
extern  uint32_t zdr_VERIFY4res (ZDR *, VERIFY4res*);
extern  uint32_t zdr_stable_how4 (ZDR *, stable_how4*);
extern  uint32_t zdr_WRITE4args (ZDR *, WRITE4args*);
extern  uint32_t zdr_WRITE4resok (ZDR *, WRITE4resok*);
extern  uint32_t zdr_WRITE4res (ZDR *, WRITE4res*);
extern  uint32_t zdr_RELEASE_LOCKOWNER4args (ZDR *, RELEASE_LOCKOWNER4args*);
extern  uint32_t zdr_RELEASE_LOCKOWNER4res (ZDR *, RELEASE_LOCKOWNER4res*);
extern  uint32_t zdr_ILLEGAL4res (ZDR *, ILLEGAL4res*);
extern  uint32_t zdr_nfs_opnum4 (ZDR *, nfs_opnum4*);
extern  uint32_t zdr_nfs_argop4 (ZDR *, nfs_argop4*);
extern  uint32_t zdr_nfs_resop4 (ZDR *, nfs_resop4*);
extern  uint32_t zdr_COMPOUND4args (ZDR *, COMPOUND4args*);
extern  uint32_t zdr_COMPOUND4res (ZDR *, COMPOUND4res*);
extern  uint32_t zdr_CB_GETATTR4args (ZDR *, CB_GETATTR4args*);
extern  uint32_t zdr_CB_GETATTR4resok (ZDR *, CB_GETATTR4resok*);
extern  uint32_t zdr_CB_GETATTR4res (ZDR *, CB_GETATTR4res*);
extern  uint32_t zdr_CB_RECALL4args (ZDR *, CB_RECALL4args*);
extern  uint32_t zdr_CB_RECALL4res (ZDR *, CB_RECALL4res*);
extern  uint32_t zdr_CB_ILLEGAL4res (ZDR *, CB_ILLEGAL4res*);
extern  uint32_t zdr_nfs_cb_opnum4 (ZDR *, nfs_cb_opnum4*);
extern  uint32_t zdr_nfs_cb_argop4 (ZDR *, nfs_cb_argop4*);
extern  uint32_t zdr_nfs_cb_resop4 (ZDR *, nfs_cb_resop4*);
extern  uint32_t zdr_CB_COMPOUND4args (ZDR *, CB_COMPOUND4args*);
extern  uint32_t zdr_CB_COMPOUND4res (ZDR *, CB_COMPOUND4res*);

#else /* K&R C */
extern uint32_t zdr_nfs_ftype4 ();
extern uint32_t zdr_nfsstat4 ();
extern uint32_t zdr_bitmap4 ();
extern uint32_t zdr_offset4 ();
extern uint32_t zdr_count4 ();
extern uint32_t zdr_length4 ();
extern uint32_t zdr_clientid4 ();
extern uint32_t zdr_seqid4 ();
extern uint32_t zdr_utf8string ();
extern uint32_t zdr_utf8str_cis ();
extern uint32_t zdr_utf8str_cs ();
extern uint32_t zdr_utf8str_mixed ();
extern uint32_t zdr_component4 ();
extern uint32_t zdr_pathname4 ();
extern uint32_t zdr_nfs_lockid4 ();
extern uint32_t zdr_nfs_cookie4 ();
extern uint32_t zdr_linktext4 ();
extern uint32_t zdr_sec_oid4 ();
extern uint32_t zdr_qop4 ();
extern uint32_t zdr_mode4 ();
extern uint32_t zdr_changeid4 ();
extern uint32_t zdr_verifier4 ();
extern uint32_t zdr_nfstime4 ();
extern uint32_t zdr_time_how4 ();
extern uint32_t zdr_settime4 ();
extern uint32_t zdr_nfs_fh4 ();
extern uint32_t zdr_fsid4 ();
extern uint32_t zdr_fs_location4 ();
extern uint32_t zdr_fs_locations4 ();
extern uint32_t zdr_acetype4 ();
extern uint32_t zdr_aceflag4 ();
extern uint32_t zdr_acemask4 ();
extern uint32_t zdr_nfsace4 ();
extern uint32_t zdr_specdata4 ();
extern uint32_t zdr_fattr4_supported_attrs ();
extern uint32_t zdr_fattr4_type ();
extern uint32_t zdr_fattr4_fh_expire_type ();
extern uint32_t zdr_fattr4_change ();
extern uint32_t zdr_fattr4_size ();
extern uint32_t zdr_fattr4_link_support ();
extern uint32_t zdr_fattr4_symlink_support ();
extern uint32_t zdr_fattr4_named_attr ();
extern uint32_t zdr_fattr4_fsid ();
extern uint32_t zdr_fattr4_unique_handles ();
extern uint32_t zdr_fattr4_lease_time ();
extern uint32_t zdr_fattr4_rdattr_error ();
extern uint32_t zdr_fattr4_acl ();
extern uint32_t zdr_fattr4_aclsupport ();
extern uint32_t zdr_fattr4_archive ();
extern uint32_t zdr_fattr4_cansettime ();
extern uint32_t zdr_fattr4_case_insensitive ();
extern uint32_t zdr_fattr4_case_preserving ();
extern uint32_t zdr_fattr4_chown_restricted ();
extern uint32_t zdr_fattr4_fileid ();
extern uint32_t zdr_fattr4_files_avail ();
extern uint32_t zdr_fattr4_filehandle ();
extern uint32_t zdr_fattr4_files_free ();
extern uint32_t zdr_fattr4_files_total ();
extern uint32_t zdr_fattr4_fs_locations ();
extern uint32_t zdr_fattr4_hidden ();
extern uint32_t zdr_fattr4_homogeneous ();
extern uint32_t zdr_fattr4_maxfilesize ();
extern uint32_t zdr_fattr4_maxlink ();
extern uint32_t zdr_fattr4_maxname ();
extern uint32_t zdr_fattr4_maxread ();
extern uint32_t zdr_fattr4_maxwrite ();
extern uint32_t zdr_fattr4_mimetype ();
extern uint32_t zdr_fattr4_mode ();
extern uint32_t zdr_fattr4_mounted_on_fileid ();
extern uint32_t zdr_fattr4_no_trunc ();
extern uint32_t zdr_fattr4_numlinks ();
extern uint32_t zdr_fattr4_owner ();
extern uint32_t zdr_fattr4_owner_group ();
extern uint32_t zdr_fattr4_quota_avail_hard ();
extern uint32_t zdr_fattr4_quota_avail_soft ();
extern uint32_t zdr_fattr4_quota_used ();
extern uint32_t zdr_fattr4_rawdev ();
extern uint32_t zdr_fattr4_space_avail ();
extern uint32_t zdr_fattr4_space_free ();
extern uint32_t zdr_fattr4_space_total ();
extern uint32_t zdr_fattr4_space_used ();
extern uint32_t zdr_fattr4_system ();
extern uint32_t zdr_fattr4_time_access ();
extern uint32_t zdr_fattr4_time_access_set ();
extern uint32_t zdr_fattr4_time_backup ();
extern uint32_t zdr_fattr4_time_create ();
extern uint32_t zdr_fattr4_time_delta ();
extern uint32_t zdr_fattr4_time_metadata ();
extern uint32_t zdr_fattr4_time_modify ();
extern uint32_t zdr_fattr4_time_modify_set ();
extern uint32_t zdr_attrlist4 ();
extern uint32_t zdr_fattr4 ();
extern uint32_t zdr_change_info4 ();
extern uint32_t zdr_clientaddr4 ();
extern uint32_t zdr_cb_client4 ();
extern uint32_t zdr_stateid4 ();
extern uint32_t zdr_nfs_client_id4 ();
extern uint32_t zdr_open_owner4 ();
extern uint32_t zdr_lock_owner4 ();
extern uint32_t zdr_nfs_lock_type4 ();
extern uint32_t zdr_ACCESS4args ();
extern uint32_t zdr_ACCESS4resok ();
extern uint32_t zdr_ACCESS4res ();
extern uint32_t zdr_CLOSE4args ();
extern uint32_t zdr_CLOSE4res ();
extern uint32_t zdr_COMMIT4args ();
extern uint32_t zdr_COMMIT4resok ();
extern uint32_t zdr_COMMIT4res ();
extern uint32_t zdr_createtype4 ();
extern uint32_t zdr_CREATE4args ();
extern uint32_t zdr_CREATE4resok ();
extern uint32_t zdr_CREATE4res ();
extern uint32_t zdr_DELEGPURGE4args ();
extern uint32_t zdr_DELEGPURGE4res ();
extern uint32_t zdr_DELEGRETURN4args ();
extern uint32_t zdr_DELEGRETURN4res ();
extern uint32_t zdr_GETATTR4args ();
extern uint32_t zdr_GETATTR4resok ();
extern uint32_t zdr_GETATTR4res ();
extern uint32_t zdr_GETFH4resok ();
extern uint32_t zdr_GETFH4res ();
extern uint32_t zdr_LINK4args ();
extern uint32_t zdr_LINK4resok ();
extern uint32_t zdr_LINK4res ();
extern uint32_t zdr_open_to_lock_owner4 ();
extern uint32_t zdr_exist_lock_owner4 ();
extern uint32_t zdr_locker4 ();
extern uint32_t zdr_LOCK4args ();
extern uint32_t zdr_LOCK4denied ();
extern uint32_t zdr_LOCK4resok ();
extern uint32_t zdr_LOCK4res ();
extern uint32_t zdr_LOCKT4args ();
extern uint32_t zdr_LOCKT4res ();
extern uint32_t zdr_LOCKU4args ();
extern uint32_t zdr_LOCKU4res ();
extern uint32_t zdr_LOOKUP4args ();
extern uint32_t zdr_LOOKUP4res ();
extern uint32_t zdr_LOOKUPP4res ();
extern uint32_t zdr_NVERIFY4args ();
extern uint32_t zdr_NVERIFY4res ();
extern uint32_t zdr_createmode4 ();
extern uint32_t zdr_createhow4 ();
extern uint32_t zdr_opentype4 ();
extern uint32_t zdr_openflag4 ();
extern uint32_t zdr_limit_by4 ();
extern uint32_t zdr_nfs_modified_limit4 ();
extern uint32_t zdr_nfs_space_limit4 ();
extern uint32_t zdr_open_delegation_type4 ();
extern uint32_t zdr_open_claim_type4 ();
extern uint32_t zdr_open_claim_delegate_cur4 ();
extern uint32_t zdr_open_claim4 ();
extern uint32_t zdr_OPEN4args ();
extern uint32_t zdr_open_read_delegation4 ();
extern uint32_t zdr_open_write_delegation4 ();
extern uint32_t zdr_open_delegation4 ();
extern uint32_t zdr_OPEN4resok ();
extern uint32_t zdr_OPEN4res ();
extern uint32_t zdr_OPENATTR4args ();
extern uint32_t zdr_OPENATTR4res ();
extern uint32_t zdr_OPEN_CONFIRM4args ();
extern uint32_t zdr_OPEN_CONFIRM4resok ();
extern uint32_t zdr_OPEN_CONFIRM4res ();
extern uint32_t zdr_OPEN_DOWNGRADE4args ();
extern uint32_t zdr_OPEN_DOWNGRADE4resok ();
extern uint32_t zdr_OPEN_DOWNGRADE4res ();
extern uint32_t zdr_PUTFH4args ();
extern uint32_t zdr_PUTFH4res ();
extern uint32_t zdr_PUTPUBFH4res ();
extern uint32_t zdr_PUTROOTFH4res ();
extern uint32_t zdr_READ4args ();
extern uint32_t zdr_READ4resok ();
extern uint32_t zdr_READ4res ();
extern uint32_t zdr_READDIR4args ();
extern uint32_t zdr_entry4 ();
extern uint32_t zdr_dirlist4 ();
extern uint32_t zdr_READDIR4resok ();
extern uint32_t zdr_READDIR4res ();
extern uint32_t zdr_READLINK4resok ();
extern uint32_t zdr_READLINK4res ();
extern uint32_t zdr_REMOVE4args ();
extern uint32_t zdr_REMOVE4resok ();
extern uint32_t zdr_REMOVE4res ();
extern uint32_t zdr_RENAME4args ();
extern uint32_t zdr_RENAME4resok ();
extern uint32_t zdr_RENAME4res ();
extern uint32_t zdr_RENEW4args ();
extern uint32_t zdr_RENEW4res ();
extern uint32_t zdr_RESTOREFH4res ();
extern uint32_t zdr_SAVEFH4res ();
extern uint32_t zdr_SETATTR4args ();
extern uint32_t zdr_SETATTR4res ();
extern uint32_t zdr_SETCLIENTID4args ();
extern uint32_t zdr_SETCLIENTID4resok ();
extern uint32_t zdr_SETCLIENTID4res ();
extern uint32_t zdr_SETCLIENTID_CONFIRM4args ();
extern uint32_t zdr_SETCLIENTID_CONFIRM4res ();
extern uint32_t zdr_VERIFY4args ();
extern uint32_t zdr_VERIFY4res ();
extern uint32_t zdr_stable_how4 ();
extern uint32_t zdr_WRITE4args ();
extern uint32_t zdr_WRITE4resok ();
extern uint32_t zdr_WRITE4res ();
extern uint32_t zdr_RELEASE_LOCKOWNER4args ();
extern uint32_t zdr_RELEASE_LOCKOWNER4res ();
extern uint32_t zdr_ILLEGAL4res ();
extern uint32_t zdr_nfs_opnum4 ();
extern uint32_t zdr_nfs_argop4 ();
extern uint32_t zdr_nfs_resop4 ();
extern uint32_t zdr_COMPOUND4args ();
extern uint32_t zdr_COMPOUND4res ();
extern uint32_t zdr_CB_GETATTR4args ();
extern uint32_t zdr_CB_GETATTR4resok ();
extern uint32_t zdr_CB_GETATTR4res ();
extern uint32_t zdr_CB_RECALL4args ();
extern uint32_t zdr_CB_RECALL4res ();
extern uint32_t zdr_CB_ILLEGAL4res ();
extern uint32_t zdr_nfs_cb_opnum4 ();
extern uint32_t zdr_nfs_cb_argop4 ();
extern uint32_t zdr_nfs_cb_resop4 ();
extern uint32_t zdr_CB_COMPOUND4args ();
extern uint32_t zdr_CB_COMPOUND4res ();

#endif /* K&R C */

#ifdef __cplusplus
}
#endif

#endif /* !_NFS4_H_RPCGEN */
