/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.basics.logging;

import ch.ehi.basics.logging.LogEvent;
import ch.ehi.basics.logging.LogListener;
import ch.ehi.basics.logging.StdListener;
import ch.ehi.basics.logging.StdLogEvent;
import java.util.HashSet;
import java.util.Set;

public class EhiLogger {
    private static EhiLogger instance = null;
    private Set logListenerv = new HashSet();
    private boolean filterTrace = true;

    public void addListener(LogListener logListener) {
        if (logListener == null) {
            return;
        }
        EhiLogger.getInstance().logListenerv.add(logListener);
    }

    public void removeListener(LogListener logListener) {
        if (logListener == null || !EhiLogger.getInstance().logListenerv.contains(logListener)) {
            return;
        }
        EhiLogger.getInstance().logListenerv.remove(logListener);
        if (EhiLogger.getInstance().logListenerv.size() == 0) {
            StdListener.getInstance().logEvent(new StdLogEvent(7, "no logging listeners left", null, EhiLogger.getOrigin()));
        }
    }

    public static EhiLogger getInstance() {
        if (instance == null) {
            instance = new EhiLogger();
            instance.addListener(StdListener.getInstance());
        }
        return instance;
    }

    private EhiLogger() {
    }

    public void setTraceFilter(boolean bl) {
        this.filterTrace = bl;
    }

    public boolean getTraceFilter() {
        return this.filterTrace;
    }

    public void logEvent(LogEvent logEvent) {
        int n = logEvent.getEventKind();
        if (EhiLogger.getInstance().filterTrace && (n == 1 || n == 2 || n == 3 || n == 4)) {
            return;
        }
        if (n < 1 || n > 7) {
            StdListener.getInstance().logEvent(new StdLogEvent(7, "illegal kind", null, EhiLogger.getOrigin()));
            return;
        }
        String string = logEvent.getEventMsg();
        if ((string == null || string.trim().length() == 0) && logEvent.getException() == null) {
            StdListener.getInstance().logEvent(new StdLogEvent(7, "null or empty log-message", null, EhiLogger.getOrigin()));
            return;
        }
        for (LogListener logListener : EhiLogger.getInstance().logListenerv) {
            try {
                logListener.logEvent(logEvent);
            }
            catch (Throwable throwable) {
                StdListener.getInstance().logEvent(new StdLogEvent(7, null, throwable, EhiLogger.getOrigin()));
            }
        }
    }

    public static void debug(String string) {
        EhiLogger.getInstance().logEvent(new StdLogEvent(1, string, null, EhiLogger.getOrigin()));
    }

    public static void debug(String string, int n) {
        EhiLogger.getInstance().logEvent(new StdLogEvent(1, string, null, EhiLogger.getOrigin(), n));
    }

    public static void debugStackTrace() {
        Throwable throwable = new Throwable();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (int i = 1; i < stackTraceElementArray.length; ++i) {
            EhiLogger.debug(stackTraceElementArray[i].toString());
        }
    }

    public static void debugStackTrace(int n) {
        Throwable throwable = new Throwable();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (int i = 1; i < stackTraceElementArray.length; ++i) {
            EhiLogger.debug(stackTraceElementArray[i].toString(), n);
        }
    }

    public static void traceState(String string) {
        EhiLogger.getInstance().logEvent(new StdLogEvent(2, string, null, EhiLogger.getOrigin()));
    }

    public static void traceState(String string, int n) {
        EhiLogger.getInstance().logEvent(new StdLogEvent(2, string, null, EhiLogger.getOrigin(), n));
    }

    public static void traceUnusualState(String string) {
        EhiLogger.getInstance().logEvent(new StdLogEvent(3, string, null, EhiLogger.getOrigin()));
    }

    public static void traceUnusualState(String string, int n) {
        EhiLogger.getInstance().logEvent(new StdLogEvent(3, string, null, EhiLogger.getOrigin(), n));
    }

    public static void traceBackendCmd(String string) {
        EhiLogger.getInstance().logEvent(new StdLogEvent(4, string, null, EhiLogger.getOrigin()));
    }

    public static void traceBackendCmd(String string, int n) {
        EhiLogger.getInstance().logEvent(new StdLogEvent(4, string, null, EhiLogger.getOrigin(), n));
    }

    public static void logState(String string) {
        EhiLogger.getInstance().logEvent(new StdLogEvent(5, string, null, EhiLogger.getOrigin()));
    }

    public static void logState(String string, int n) {
        EhiLogger.getInstance().logEvent(new StdLogEvent(5, string, null, EhiLogger.getOrigin(), n));
    }

    public static void logAdaption(String string) {
        EhiLogger.getInstance().logEvent(new StdLogEvent(6, string, null, EhiLogger.getOrigin()));
    }

    public static void logAdaption(String string, int n) {
        EhiLogger.getInstance().logEvent(new StdLogEvent(6, string, null, EhiLogger.getOrigin(), n));
    }

    public static void logError(String string) {
        EhiLogger.getInstance().logEvent(new StdLogEvent(7, string, null, EhiLogger.getOrigin()));
    }

    public static void logError(String string, int n) {
        EhiLogger.getInstance().logEvent(new StdLogEvent(7, string, null, EhiLogger.getOrigin(), n));
    }

    public static void logError(String string, Throwable throwable) {
        EhiLogger.getInstance().logEvent(new StdLogEvent(7, string, throwable, EhiLogger.getOrigin()));
    }

    public static void logError(String string, Throwable throwable, int n) {
        EhiLogger.getInstance().logEvent(new StdLogEvent(7, string, throwable, EhiLogger.getOrigin(), n));
    }

    public static void logError(Throwable throwable) {
        EhiLogger.getInstance().logEvent(new StdLogEvent(7, null, throwable, EhiLogger.getOrigin()));
    }

    public static void logError(Throwable throwable, int n) {
        EhiLogger.getInstance().logEvent(new StdLogEvent(7, null, throwable, EhiLogger.getOrigin(), n));
    }

    private static StackTraceElement getOrigin() {
        Throwable throwable = new Throwable();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        if (2 < stackTraceElementArray.length) {
            StackTraceElement stackTraceElement = stackTraceElementArray[2];
            return stackTraceElement;
        }
        return null;
    }

    public static String kindToString(int n) {
        switch (n) {
            case 1: {
                return "DEBUG_TRACE";
            }
            case 2: {
                return "STATE_TRACE";
            }
            case 3: {
                return "UNUSUAL_STATE_TRACE";
            }
            case 4: {
                return "BACKEND_CMD";
            }
            case 5: {
                return "STATE";
            }
            case 6: {
                return "ADAPTION";
            }
            case 7: {
                return "ERROR";
            }
        }
        throw new IllegalArgumentException("illegal event kind");
    }
}

