/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio;

import java.awt.geom.Point2D;
import java.io.IOException;
import org.freehep.graphicsio.AbstractPathConstructor;

public abstract class CubicToQuadPathConstructor
extends AbstractPathConstructor {
    private double resolutionSq;

    protected CubicToQuadPathConstructor(double resolution) {
        this.resolutionSq = resolution * resolution;
    }

    public void move(double x, double y) throws IOException {
        this.currentX = x;
        this.currentY = y;
    }

    public void line(double x, double y) throws IOException {
        this.currentX = x;
        this.currentY = y;
    }

    public void cubic(double x1, double y1, double x2, double y2, double x3, double y3) throws IOException {
        this.quadratify(new Point2D.Double(this.currentX, this.currentY), new Point2D.Double(x1, y1), new Point2D.Double(x2, y2), new Point2D.Double(x3, y3));
        this.currentX = x3;
        this.currentY = y3;
    }

    public void closePath() throws IOException {
        this.currentX = 0.0;
        this.currentY = 0.0;
    }

    public static Point2D intersect(Point2D p1, Point2D p2, Point2D p3, Point2D p4) {
        double dx1 = p2.getX() - p1.getX();
        double dx2 = p3.getX() - p4.getX();
        if (dx1 == 0.0 && dx2 == 0.0) {
            return null;
        }
        double m1 = (p2.getY() - p1.getY()) / dx1;
        double m2 = (p3.getY() - p4.getY()) / dx2;
        if (dx1 == 0.0) {
            return new Point2D.Double(p1.getX(), m2 * (p1.getX() - p4.getX()) + p4.getY());
        }
        if (dx2 == 0.0) {
            return new Point2D.Double(p4.getX(), m1 * (p4.getX() - p1.getX()) + p1.getY());
        }
        double x = (-m2 * p4.getX() + p4.getY() + m1 * p1.getX() - p1.getY()) / (m1 - m2);
        double y = m1 * (x - p1.getX()) + p1.getY();
        return new Point2D.Double(x, y);
    }

    public static Point2D midPoint(Point2D a, Point2D b) {
        return new Point2D.Double((a.getX() + b.getX()) / 2.0, (a.getY() + b.getY()) / 2.0);
    }

    public void quadratify(Point2D a, Point2D b, Point2D c, Point2D d) throws IOException {
        double dy;
        Point2D s = CubicToQuadPathConstructor.intersect(a, b, c, d);
        double dx = (a.getX() + d.getX() + s.getX() * 4.0 - (b.getX() + c.getX()) * 3.0) * 0.125;
        if (dx * dx + (dy = (a.getY() + d.getY() + s.getY() * 4.0 - (b.getY() + c.getY()) * 3.0) * 0.125) * dy > this.resolutionSq) {
            Point2D p01 = CubicToQuadPathConstructor.midPoint(a, b);
            Point2D p12 = CubicToQuadPathConstructor.midPoint(b, c);
            Point2D p23 = CubicToQuadPathConstructor.midPoint(c, d);
            Point2D p02 = CubicToQuadPathConstructor.midPoint(p01, p12);
            Point2D p13 = CubicToQuadPathConstructor.midPoint(p12, p23);
            Point2D p03 = CubicToQuadPathConstructor.midPoint(p02, p13);
            this.quadratify(a, p01, p02, p03);
            this.quadratify(p03, p13, p23, d);
        } else {
            this.quad(s.getX(), s.getY(), d.getX(), d.getY());
        }
    }

    public static void main(String[] args) throws Exception {
        Test pc = new Test(0.5);
        pc.move(20.0, 20.0);
        pc.cubic(20.0, 40.0, 40.0, 60.0, 60.0, 60.0);
        pc.move(20.0, 20.0);
        pc.cubic(20.0, 40.0, 60.0, 60.0, 40.0, 60.0);
        pc.move(183.0, 149.0);
        pc.cubic(189.0, 291.0, 256.0, 347.0, 295.0, 244.0);
        pc.cubic(334.0, 141.0, 286.0, 216.0, 214.0, 228.0);
        pc.cubic(142.0, 240.0, 142.0, 256.0, 176.0, 284.0);
    }

    static class Test
    extends CubicToQuadPathConstructor {
        public Test(double resolution) {
            super(resolution);
        }

        public void quad(double x1, double y1, double x2, double y2) {
            System.out.println("Quad: (" + this.currentX + ", " + this.currentY + ") (" + x1 + ", " + y1 + ") (" + x2 + ", " + y2 + ")");
            this.currentX = x2;
            this.currentY = y2;
        }
    }
}

