/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.env;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileStore;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.ESFileStore;

@SuppressForbidden(reason="configures paths for the system")
public class Environment {
    public static final Setting<String> PATH_HOME_SETTING = Setting.simpleString("path.home", Setting.Property.NodeScope);
    public static final Setting<String> DEFAULT_PATH_CONF_SETTING = Setting.simpleString("default.path.conf", Setting.Property.NodeScope);
    public static final Setting<String> PATH_CONF_SETTING = new Setting<String>("path.conf", DEFAULT_PATH_CONF_SETTING, Function.identity(), Setting.Property.NodeScope);
    public static final Setting<String> PATH_SCRIPTS_SETTING = Setting.simpleString("path.scripts", Setting.Property.NodeScope, Setting.Property.Deprecated);
    public static final Setting<List<String>> DEFAULT_PATH_DATA_SETTING = Setting.listSetting("default.path.data", Collections.emptyList(), Function.identity(), Setting.Property.NodeScope);
    public static final Setting<List<String>> PATH_DATA_SETTING = Setting.listSetting("path.data", DEFAULT_PATH_DATA_SETTING, Function.identity(), Setting.Property.NodeScope);
    public static final Setting<String> DEFAULT_PATH_LOGS_SETTING = Setting.simpleString("default.path.logs", Setting.Property.NodeScope);
    public static final Setting<String> PATH_LOGS_SETTING = new Setting<String>("path.logs", DEFAULT_PATH_LOGS_SETTING, Function.identity(), Setting.Property.NodeScope);
    public static final Setting<List<String>> PATH_REPO_SETTING = Setting.listSetting("path.repo", Collections.emptyList(), Function.identity(), Setting.Property.NodeScope);
    public static final Setting<String> PATH_SHARED_DATA_SETTING = Setting.simpleString("path.shared_data", Setting.Property.NodeScope);
    public static final Setting<String> PIDFILE_SETTING = Setting.simpleString("pidfile", Setting.Property.NodeScope);
    private final Settings settings;
    private final String configExtension;
    private final Path[] dataFiles;
    private final Path[] dataWithClusterFiles;
    private final Path[] repoFiles;
    private final Path configFile;
    private final Path scriptsFile;
    private final Path pluginsFile;
    private final Path modulesFile;
    private final Path sharedDataFile;
    private final Path binFile;
    private final Path libFile;
    private final Path logsFile;
    private final Path pidFile;
    private final Path tmpFile = PathUtils.get(System.getProperty("java.io.tmpdir"), new String[0]);
    private static final FileStore[] fileStores;

    public Environment(Settings settings) {
        this(settings, null);
    }

    public Environment(Settings settings, String configExtension) {
        this.configExtension = configExtension;
        if (!PATH_HOME_SETTING.exists(settings)) {
            throw new IllegalStateException(PATH_HOME_SETTING.getKey() + " is not configured");
        }
        Path homeFile = PathUtils.get(Strings.cleanPath(PATH_HOME_SETTING.get(settings)), new String[0]);
        this.configFile = PATH_CONF_SETTING.exists(settings) || DEFAULT_PATH_CONF_SETTING.exists(settings) ? PathUtils.get(Strings.cleanPath(PATH_CONF_SETTING.get(settings)), new String[0]) : homeFile.resolve("config");
        this.scriptsFile = PATH_SCRIPTS_SETTING.exists(settings) ? PathUtils.get(Strings.cleanPath(PATH_SCRIPTS_SETTING.get(settings)), new String[0]) : this.configFile.resolve("scripts");
        this.pluginsFile = homeFile.resolve("plugins");
        List<String> dataPaths = PATH_DATA_SETTING.get(settings);
        ClusterName clusterName = ClusterName.CLUSTER_NAME_SETTING.get(settings);
        if (!dataPaths.isEmpty()) {
            this.dataFiles = new Path[dataPaths.size()];
            this.dataWithClusterFiles = new Path[dataPaths.size()];
            for (int i = 0; i < dataPaths.size(); ++i) {
                this.dataFiles[i] = PathUtils.get(dataPaths.get(i), new String[0]);
                this.dataWithClusterFiles[i] = this.dataFiles[i].resolve(clusterName.value());
            }
        } else {
            this.dataFiles = new Path[]{homeFile.resolve("data")};
            this.dataWithClusterFiles = new Path[]{homeFile.resolve("data").resolve(clusterName.value())};
        }
        this.sharedDataFile = PATH_SHARED_DATA_SETTING.exists(settings) ? PathUtils.get(Strings.cleanPath(PATH_SHARED_DATA_SETTING.get(settings)), new String[0]) : null;
        List<String> repoPaths = PATH_REPO_SETTING.get(settings);
        if (!repoPaths.isEmpty()) {
            this.repoFiles = new Path[repoPaths.size()];
            for (int i = 0; i < repoPaths.size(); ++i) {
                this.repoFiles[i] = PathUtils.get(repoPaths.get(i), new String[0]);
            }
        } else {
            this.repoFiles = new Path[0];
        }
        this.logsFile = PATH_LOGS_SETTING.exists(settings) || DEFAULT_PATH_LOGS_SETTING.exists(settings) ? PathUtils.get(Strings.cleanPath(PATH_LOGS_SETTING.get(settings)), new String[0]) : homeFile.resolve("logs");
        this.pidFile = PIDFILE_SETTING.exists(settings) ? PathUtils.get(Strings.cleanPath(PIDFILE_SETTING.get(settings)), new String[0]) : null;
        this.binFile = homeFile.resolve("bin");
        this.libFile = homeFile.resolve("lib");
        this.modulesFile = homeFile.resolve("modules");
        Settings.Builder finalSettings = Settings.builder().put(settings);
        finalSettings.put(PATH_HOME_SETTING.getKey(), homeFile);
        if (PATH_DATA_SETTING.exists(settings)) {
            finalSettings.putArray(PATH_DATA_SETTING.getKey(), dataPaths);
        }
        finalSettings.put(PATH_LOGS_SETTING.getKey(), this.logsFile);
        this.settings = finalSettings.build();
    }

    public Settings settings() {
        return this.settings;
    }

    public Path[] dataFiles() {
        return this.dataFiles;
    }

    public Path sharedDataFile() {
        return this.sharedDataFile;
    }

    @Deprecated
    public Path[] dataWithClusterFiles() {
        return this.dataWithClusterFiles;
    }

    public Path[] repoFiles() {
        return this.repoFiles;
    }

    public Path resolveRepoFile(String location) {
        return PathUtils.get(this.repoFiles, location);
    }

    public URL resolveRepoURL(URL url) {
        try {
            if ("file".equalsIgnoreCase(url.getProtocol())) {
                if (url.getHost() == null || "".equals(url.getHost())) {
                    Path path = PathUtils.get(this.repoFiles, url.toURI());
                    if (path == null) {
                        return null;
                    }
                    return path.toUri().toURL();
                }
                return null;
            }
            if ("jar".equals(url.getProtocol())) {
                String file = url.getFile();
                int pos = file.indexOf("!/");
                if (pos < 0) {
                    return null;
                }
                String jarTail = file.substring(pos);
                String filePath = file.substring(0, pos);
                URL internalUrl = new URL(filePath);
                URL normalizedUrl = this.resolveRepoURL(internalUrl);
                if (normalizedUrl == null) {
                    return null;
                }
                return new URL("jar", "", normalizedUrl.toExternalForm() + jarTail);
            }
            return null;
        }
        catch (MalformedURLException ex) {
            return null;
        }
        catch (URISyntaxException ex) {
            return null;
        }
    }

    public String configExtension() {
        return this.configExtension;
    }

    public Path configFile() {
        return this.configFile;
    }

    public Path scriptsFile() {
        return this.scriptsFile;
    }

    public Path pluginsFile() {
        return this.pluginsFile;
    }

    public Path binFile() {
        return this.binFile;
    }

    public Path libFile() {
        return this.libFile;
    }

    public Path modulesFile() {
        return this.modulesFile;
    }

    public Path logsFile() {
        return this.logsFile;
    }

    public Path pidFile() {
        return this.pidFile;
    }

    public Path tmpFile() {
        return this.tmpFile;
    }

    public static FileStore getFileStore(Path path) throws IOException {
        return ESFileStore.getMatchingFileStore(path, fileStores);
    }

    public static void assertEquivalent(Environment actual, Environment expected) {
        Environment.assertEquals(actual.dataWithClusterFiles(), expected.dataWithClusterFiles(), "dataWithClusterFiles");
        Environment.assertEquals(actual.repoFiles(), expected.repoFiles(), "repoFiles");
        Environment.assertEquals(actual.configFile(), expected.configFile(), "configFile");
        Environment.assertEquals(actual.scriptsFile(), expected.scriptsFile(), "scriptsFile");
        Environment.assertEquals(actual.pluginsFile(), expected.pluginsFile(), "pluginsFile");
        Environment.assertEquals(actual.binFile(), expected.binFile(), "binFile");
        Environment.assertEquals(actual.libFile(), expected.libFile(), "libFile");
        Environment.assertEquals(actual.modulesFile(), expected.modulesFile(), "modulesFile");
        Environment.assertEquals(actual.logsFile(), expected.logsFile(), "logsFile");
        Environment.assertEquals(actual.pidFile(), expected.pidFile(), "pidFile");
        Environment.assertEquals(actual.tmpFile(), expected.tmpFile(), "tmpFile");
    }

    private static void assertEquals(Object actual, Object expected, String name) {
        assert (Objects.deepEquals(actual, expected)) : "actual " + name + " [" + actual + "] is different than [ " + expected + "]";
    }

    static {
        ArrayList<ESFileStore> allStores = new ArrayList<ESFileStore>();
        for (FileStore store : PathUtils.getDefaultFileSystem().getFileStores()) {
            allStores.add(new ESFileStore(store));
        }
        fileStores = allStores.toArray(new ESFileStore[allStores.size()]);
    }
}

