-- EFL LuaJIT bindings: elm_app_server.eo (class Elm.App.Server)
-- For use with Elua; automatically generated, do not modify

local cutil = require("cutil")
local util  = require("util")
local ffi   = require("ffi")
local eo    = require("eo")

local M, __lib = ...

local __class
local __body

local init = function()
    __class = __lib.elm_app_server_class_get()
    eo.class_register("Elm_App_Server", {"Eo_Base"}, nil, __body, __class)
end

cutil.init_module(init, function() end)

ffi.cdef [[
    const Eo_Class *elm_app_server_class_get(void);
    void elm_app_server_icon_set(Eina_Stringshare * icon);
    Eina_Stringshare *elm_app_server_icon_get(void);
    Eina_Iterator *elm_app_server_views_get(void);
    const char *elm_app_server_path_get(void);
    Eina_Stringshare *elm_app_server_package_get(void);
    void elm_app_server_pixels_set(unsigned int w, unsigned int h, Eina_Bool has_alpha, const unsigned char * pixels);
    void elm_app_server_pixels_get(unsigned int *w, unsigned int *h, Eina_Bool *has_alpha, const unsigned char * *pixels);
    void elm_app_server_constructor(const char * packageid, Elm_App_Server_Create_View_Cb create_view_cb);
    void elm_app_server_close_all(void);
    Eina_Bool elm_app_server_view_check(const char * id);
    void elm_app_server_view_add(Elm_App_Server_View * view);
    void elm_app_server_title_set(const char * title);
    Eina_Stringshare *elm_app_server_title_get(void);
    void elm_app_server_save(void);
    extern const Eo_Event_Description _ELM_APP_SERVER_EVENT_TERMINATE;
]]

local __M = util.get_namespace(M, { "app" })
__body = {
    __eo_ctor = function(self, constructor_packageid, constructor_create_view_cb, __func)
        self:constructor(constructor_packageid, constructor_create_view_cb)
        if __func then __func() end
    end,

    icon_set = function(self, icon)
        eo.__do_start(self, __class)
        __lib.elm_app_server_icon_set(icon)
        eo.__do_end()
    end,

    icon_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_app_server_icon_get()
        eo.__do_end()
        return v
    end,

    views_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_app_server_views_get()
        eo.__do_end()
        return v
    end,

    path_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_app_server_path_get()
        eo.__do_end()
        return v
    end,

    package_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_app_server_package_get()
        eo.__do_end()
        return v
    end,

    pixels_set = function(self, w, h, has_alpha, pixels)
        eo.__do_start(self, __class)
        __lib.elm_app_server_pixels_set(w, h, has_alpha, pixels)
        eo.__do_end()
    end,

    pixels_get = function(self)
        eo.__do_start(self, __class)
        local w = ffi.new("unsigned int[1]")
        local h = ffi.new("unsigned int[1]")
        local has_alpha = ffi.new("Eina_Bool[1]")
        local pixels = ffi.new("const unsigned char *[1]")
        __lib.elm_app_server_pixels_get(w, h, has_alpha, pixels)
        eo.__do_end()
        return w[0], h[0], ((has_alpha[0]) ~= 0), pixels[0]
    end,

    constructor = function(self, packageid, create_view_cb)
        eo.__do_start(self, __class)
        __lib.elm_app_server_constructor(packageid, create_view_cb)
        eo.__do_end()
    end,

    close_all = function(self)
        eo.__do_start(self, __class)
        __lib.elm_app_server_close_all()
        eo.__do_end()
    end,

    view_check = function(self, id)
        eo.__do_start(self, __class)
        local v = __lib.elm_app_server_view_check(id)
        eo.__do_end()
        return ((v) ~= 0)
    end,

    view_add = function(self, view)
        eo.__do_start(self, __class)
        __lib.elm_app_server_view_add(view)
        eo.__do_end()
    end,

    title_set = function(self, title)
        eo.__do_start(self, __class)
        __lib.elm_app_server_title_set(title)
        eo.__do_end()
    end,

    title_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_app_server_title_get()
        eo.__do_end()
        return v
    end,

    save = function(self)
        eo.__do_start(self, __class)
        __lib.elm_app_server_save()
        eo.__do_end()
    end,

    __events = {
        ["terminate"] = __lib._ELM_APP_SERVER_EVENT_TERMINATE
    },

    __properties = {
        ["path"] = { 0, 0, 1, 0, true, false },
        ["icon"] = { 0, 0, 1, 1, true, true },
        ["pixels"] = { 0, 0, 4, 4, true, true },
        ["views"] = { 0, 0, 1, 0, true, false },
        ["package"] = { 0, 0, 1, 0, true, false }
    }
}

__M.Server = function(parent, ...)
    return eo.__ctor_common(__class, parent, eo.class_get("Elm_App_Server").__eo_ctor,
                            1, ...)
end

return M
