/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ssh;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.optional.ssh.Directory;
import org.apache.tools.ant.taskdefs.optional.ssh.SSHBase;
import org.apache.tools.ant.taskdefs.optional.ssh.ScpFromMessage;
import org.apache.tools.ant.taskdefs.optional.ssh.ScpFromMessageBySftp;
import org.apache.tools.ant.taskdefs.optional.ssh.ScpToMessage;
import org.apache.tools.ant.taskdefs.optional.ssh.ScpToMessageBySftp;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileProvider;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.util.ResourceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scp
extends SSHBase {
    private static final String[] FROM_ATTRS = new String[]{"file", "localfile", "remotefile"};
    private static final String[] TO_ATTRS = new String[]{"todir", "localtodir", "remotetodir", "localtofile", "remotetofile"};
    private String fromUri;
    private String toUri;
    private boolean preserveLastModified = false;
    private List<ResourceCollection> rcs = null;
    private boolean isFromRemote;
    private boolean isToRemote;
    private boolean isSftp = false;
    private Integer fileMode;
    private Integer dirMode;

    public void setFile(String aFromUri) {
        this.setFromUri(aFromUri);
        this.isFromRemote = Scp.isRemoteUri(this.fromUri);
    }

    public void setTodir(String aToUri) {
        this.setToUri(aToUri);
        this.isToRemote = Scp.isRemoteUri(this.toUri);
    }

    public void setLocalFile(String aFromUri) {
        this.setFromUri(aFromUri);
        this.isFromRemote = false;
    }

    public void setRemoteFile(String aFromUri) {
        Scp.validateRemoteUri("remoteFile", aFromUri);
        this.setFromUri(aFromUri);
        this.isFromRemote = true;
    }

    public void setLocalTodir(String aToUri) {
        this.setToUri(aToUri);
        this.isToRemote = false;
    }

    public void setPreservelastmodified(boolean yesOrNo) {
        this.preserveLastModified = yesOrNo;
    }

    public void setRemoteTodir(String aToUri) {
        Scp.validateRemoteUri("remoteToDir", aToUri);
        this.setToUri(aToUri);
        this.isToRemote = true;
    }

    private static void validateRemoteUri(String type, String aToUri) {
        if (!Scp.isRemoteUri(aToUri)) {
            throw new BuildException(type + " '" + aToUri + "' is invalid. " + "The 'remoteToDir' attribute must " + "have syntax like the " + "following: user:password@host:/path" + " - the :password part is optional");
        }
    }

    public void setLocalTofile(String aToUri) {
        this.setToUri(aToUri);
        this.isToRemote = false;
    }

    public void setRemoteTofile(String aToUri) {
        Scp.validateRemoteUri("remoteToFile", aToUri);
        this.setToUri(aToUri);
        this.isToRemote = true;
    }

    public void setSftp(boolean yesOrNo) {
        this.isSftp = yesOrNo;
    }

    public void setFileMode(String fileMode) {
        this.fileMode = Integer.parseInt(fileMode, 8);
    }

    public void setDirMode(String dirMode) {
        this.dirMode = Integer.parseInt(dirMode, 8);
    }

    public void addFileset(FileSet set) {
        this.add((ResourceCollection)set);
    }

    public void add(ResourceCollection res) {
        if (this.rcs == null) {
            this.rcs = new LinkedList<ResourceCollection>();
        }
        this.rcs.add(res);
    }

    @Override
    public void init() throws BuildException {
        super.init();
        this.toUri = null;
        this.fromUri = null;
        this.rcs = null;
    }

    public void execute() throws BuildException {
        block12: {
            if (this.toUri == null) {
                throw this.exactlyOne(TO_ATTRS);
            }
            if (this.fromUri == null && this.rcs == null) {
                throw this.exactlyOne(FROM_ATTRS, "one or more nested filesets");
            }
            try {
                if (this.isFromRemote && !this.isToRemote) {
                    this.download(this.fromUri, this.toUri);
                    break block12;
                }
                if (!this.isFromRemote && this.isToRemote) {
                    if (this.rcs != null) {
                        this.upload(this.rcs, this.toUri);
                    } else {
                        this.upload(this.fromUri, this.toUri);
                    }
                    break block12;
                }
                if (this.isFromRemote && this.isToRemote) {
                    throw new BuildException("Copying from a remote server to a remote server is not supported.");
                }
                throw new BuildException("'todir' and 'file' attributes must have syntax like the following: user:password@host:/path");
            }
            catch (Exception e) {
                if (this.getFailonerror()) {
                    if (e instanceof BuildException) {
                        BuildException be = (BuildException)((Object)e);
                        if (be.getLocation() == null) {
                            be.setLocation(this.getLocation());
                        }
                        throw be;
                    }
                    throw new BuildException((Throwable)e);
                }
                this.log("Caught exception: " + e.getMessage(), 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void download(String fromSshUri, String toPath) throws JSchException, IOException {
        String file = this.parseUri(fromSshUri);
        Session session = null;
        try {
            session = this.openSession();
            ScpFromMessage message = null;
            message = !this.isSftp ? new ScpFromMessage(this.getVerbose(), session, file, this.getProject().resolveFile(toPath), fromSshUri.endsWith("*"), this.preserveLastModified) : new ScpFromMessageBySftp(this.getVerbose(), session, file, this.getProject().resolveFile(toPath), fromSshUri.endsWith("*"), this.preserveLastModified);
            this.log("Receiving file: " + file);
            message.setLogListener(this);
            message.execute();
            Object var7_6 = null;
            if (session == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (session == null) throw throwable;
            session.disconnect();
            throw throwable;
        }
        session.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void upload(List<ResourceCollection> rcs, String toSshUri) throws IOException, JSchException {
        String file = this.parseUri(toSshUri);
        Session session = null;
        try {
            ArrayList<Directory> list = new ArrayList<Directory>(rcs.size());
            for (ResourceCollection rc : rcs) {
                if (rc instanceof FileSet && rc.isFilesystemOnly()) {
                    FileSet fs = (FileSet)rc;
                    Directory d = this.createDirectory(fs);
                    if (d == null) continue;
                    list.add(d);
                    continue;
                }
                List<Directory> ds = this.createDirectoryCollection(rc);
                if (ds == null) continue;
                list.addAll(ds);
            }
            if (!list.isEmpty()) {
                session = this.openSession();
                ScpToMessage message = null;
                message = !this.isSftp ? new ScpToMessage(this.getVerbose(), session, list, file, this.preserveLastModified) : new ScpToMessageBySftp(this.getVerbose(), session, list, file);
                message.setLogListener(this);
                if (this.fileMode != null) {
                    message.setFileMode(this.fileMode);
                }
                if (this.dirMode != null) {
                    message.setDirMode(this.dirMode);
                }
                message.execute();
            }
            Object var11_10 = null;
            if (session == null) return;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (session == null) throw throwable;
            session.disconnect();
            throw throwable;
        }
        session.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void upload(String fromPath, String toSshUri) throws IOException, JSchException {
        String file = this.parseUri(toSshUri);
        Session session = null;
        try {
            session = this.openSession();
            ScpToMessage message = null;
            message = !this.isSftp ? new ScpToMessage(this.getVerbose(), session, this.getProject().resolveFile(fromPath), file, this.preserveLastModified) : new ScpToMessageBySftp(this.getVerbose(), session, this.getProject().resolveFile(fromPath), file);
            message.setLogListener(this);
            if (this.fileMode != null) {
                message.setFileMode(this.fileMode);
            }
            if (this.dirMode != null) {
                message.setDirMode(this.dirMode);
            }
            message.execute();
            Object var7_6 = null;
            if (session == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (session == null) throw throwable;
            session.disconnect();
            throw throwable;
        }
        session.disconnect();
    }

    private String parseUri(String uri) {
        int indexOfAt = uri.indexOf(64);
        int indexOfColon = uri.indexOf(58);
        if (indexOfColon > -1 && indexOfColon < indexOfAt) {
            int indexOfCurrentAt = indexOfAt;
            int indexOfLastColon = uri.lastIndexOf(58);
            while (indexOfCurrentAt > -1 && indexOfCurrentAt < indexOfLastColon) {
                indexOfAt = indexOfCurrentAt;
                indexOfCurrentAt = uri.indexOf(64, indexOfCurrentAt + 1);
            }
            this.setUsername(uri.substring(0, indexOfColon));
            this.setPassword(uri.substring(indexOfColon + 1, indexOfAt));
        } else if (indexOfAt > -1) {
            this.setUsername(uri.substring(0, indexOfAt));
        } else {
            throw new BuildException("no username was given.  Can't authenticate.");
        }
        if (this.getUserInfo().getPassword() == null && this.getUserInfo().getKeyfile() == null) {
            throw new BuildException("neither password nor keyfile for user " + this.getUserInfo().getName() + " has been " + "given.  Can't authenticate.");
        }
        int indexOfPath = uri.indexOf(58, indexOfAt + 1);
        if (indexOfPath == -1) {
            throw new BuildException("no remote path in " + uri);
        }
        this.setHost(uri.substring(indexOfAt + 1, indexOfPath));
        String remotePath = uri.substring(indexOfPath + 1);
        if (remotePath.equals("")) {
            remotePath = ".";
        }
        return remotePath;
    }

    private static boolean isRemoteUri(String uri) {
        boolean isRemote = true;
        int indexOfAt = uri.indexOf(64);
        if (indexOfAt < 0) {
            isRemote = false;
        }
        return isRemote;
    }

    private Directory createDirectory(FileSet set) {
        DirectoryScanner scanner = set.getDirectoryScanner(this.getProject());
        Directory root = new Directory(scanner.getBasedir());
        String[] files = scanner.getIncludedFiles();
        if (files.length != 0) {
            for (int j = 0; j < files.length; ++j) {
                String[] path = Directory.getPath(files[j]);
                Directory current = root;
                File currentParent = scanner.getBasedir();
                for (int i = 0; i < path.length; ++i) {
                    File file = new File(currentParent, path[i]);
                    if (file.isDirectory()) {
                        current.addDirectory(new Directory(file));
                        current = current.getChild(file);
                        currentParent = current.getDirectory();
                        continue;
                    }
                    if (!file.isFile()) continue;
                    current.addFile(file);
                }
            }
        } else {
            root = null;
        }
        return root;
    }

    private List<Directory> createDirectoryCollection(ResourceCollection rc) {
        if (!rc.isFilesystemOnly()) {
            throw new BuildException("Only FileSystem resources are supported.");
        }
        ArrayList<Directory> ds = new ArrayList<Directory>();
        for (Resource r : rc) {
            Directory root;
            if (!r.isExists()) {
                throw new BuildException("Could not find resource " + r.toLongString() + " to scp.");
            }
            FileProvider fp = (FileProvider)r.as(FileProvider.class);
            if (fp == null) {
                throw new BuildException("Resource " + r.toLongString() + " is not a file.");
            }
            FileResource fr = ResourceUtils.asFileResource((FileProvider)fp);
            File baseDir = fr.getBaseDir();
            if (baseDir == null) {
                throw new BuildException("basedir for resource " + r.toLongString() + " is undefined.");
            }
            String name = r.getName();
            Directory current = root = new Directory(baseDir);
            File currentParent = baseDir;
            String[] path = Directory.getPath(name);
            for (int i = 0; i < path.length; ++i) {
                File file = new File(currentParent, path[i]);
                if (file.isDirectory()) {
                    current.addDirectory(new Directory(file));
                    current = current.getChild(file);
                    currentParent = current.getDirectory();
                    continue;
                }
                if (!file.isFile()) continue;
                current.addFile(file);
            }
            ds.add(root);
        }
        return ds;
    }

    private void setFromUri(String fromUri) {
        if (this.fromUri != null) {
            throw this.exactlyOne(FROM_ATTRS);
        }
        this.fromUri = fromUri;
    }

    private void setToUri(String toUri) {
        if (this.toUri != null) {
            throw this.exactlyOne(TO_ATTRS);
        }
        this.toUri = toUri;
    }

    private BuildException exactlyOne(String[] attrs) {
        return this.exactlyOne(attrs, null);
    }

    private BuildException exactlyOne(String[] attrs, String alt) {
        StringBuffer buf = new StringBuffer("Exactly one of ").append('[').append(attrs[0]);
        for (int i = 1; i < attrs.length; ++i) {
            buf.append('|').append(attrs[i]);
        }
        buf.append(']');
        if (alt != null) {
            buf.append(" or ").append(alt);
        }
        return new BuildException(buf.append(" is required.").toString());
    }
}

