/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import sun.security.util.Debug;
import sun.security.x509.AuthorityKeyIdentifierExtension;
import sun.security.x509.KeyIdentifier;
import sun.security.x509.SubjectKeyIdentifierExtension;
import sun.security.x509.X509CertImpl;

public class Vertex {
    private static final Debug debug = Debug.getInstance("certpath");
    private Certificate cert;
    private int index;
    private Throwable throwable;

    Vertex(Certificate cert) {
        this.cert = cert;
        this.index = -1;
    }

    public Certificate getCertificate() {
        return this.cert;
    }

    public int getIndex() {
        return this.index;
    }

    void setIndex(int ndx) {
        this.index = ndx;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public String toString() {
        return this.certToString() + this.throwableToString() + this.indexToString();
    }

    public String certToString() {
        String out;
        block15: {
            X509CertImpl x509Cert;
            block14: {
                boolean[] sUID;
                out = "";
                if (this.cert == null || !(this.cert instanceof X509Certificate)) {
                    return "Cert:       Not an X509Certificate\n";
                }
                x509Cert = null;
                try {
                    x509Cert = X509CertImpl.toImpl((X509Certificate)this.cert);
                }
                catch (CertificateException ce) {
                    if (debug != null) {
                        debug.println("Vertex.certToString() unexpected exception");
                        ce.printStackTrace();
                    }
                    return out;
                }
                out = "Issuer:     " + x509Cert.getIssuerX500Principal() + "\n";
                out = out + "Subject:    " + x509Cert.getSubjectX500Principal() + "\n";
                out = out + "SerialNum:  " + x509Cert.getSerialNumber().toString(16) + "\n";
                out = out + "Expires:    " + x509Cert.getNotAfter().toString() + "\n";
                boolean[] iUID = x509Cert.getIssuerUniqueID();
                if (iUID != null) {
                    out = out + "IssuerUID:  ";
                    for (int i = 0; i < iUID.length; ++i) {
                        out = out + (iUID[i] ? 1 : 0);
                    }
                    out = out + "\n";
                }
                if ((sUID = x509Cert.getSubjectUniqueID()) != null) {
                    out = out + "SubjectUID: ";
                    for (int i = 0; i < sUID.length; ++i) {
                        out = out + (sUID[i] ? 1 : 0);
                    }
                    out = out + "\n";
                }
                SubjectKeyIdentifierExtension sKeyID = null;
                try {
                    sKeyID = x509Cert.getSubjectKeyIdentifierExtension();
                    if (sKeyID != null) {
                        KeyIdentifier keyID = sKeyID.get("key_id");
                        out = out + "SubjKeyID:  " + keyID.toString();
                    }
                }
                catch (Exception e) {
                    if (debug == null) break block14;
                    debug.println("Vertex.certToString() unexpected exception");
                    e.printStackTrace();
                }
            }
            AuthorityKeyIdentifierExtension aKeyID = null;
            try {
                aKeyID = x509Cert.getAuthorityKeyIdentifierExtension();
                if (aKeyID != null) {
                    KeyIdentifier keyID = (KeyIdentifier)aKeyID.get("key_id");
                    out = out + "AuthKeyID:  " + keyID.toString();
                }
            }
            catch (Exception e) {
                if (debug == null) break block15;
                debug.println("Vertex.certToString() 2 unexpected exception");
                e.printStackTrace();
            }
        }
        return out;
    }

    public String throwableToString() {
        String out = "Exception:  ";
        out = this.throwable != null ? out + this.throwable.toString() : out + "null";
        out = out + "\n";
        return out;
    }

    public String moreToString() {
        String out = "Last cert?  ";
        out = out + (this.index == -1 ? "Yes" : "No");
        out = out + "\n";
        return out;
    }

    public String indexToString() {
        String out = "Index:      " + this.index + "\n";
        return out;
    }
}

