/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.Difference;
import org.jetbrains.kotlin.incremental.DifferenceCalculator;
import org.jetbrains.kotlin.incremental.DifferenceCalculatorForClass;
import org.jetbrains.kotlin.incremental.DifferenceCalculatorForClass$WhenMappings;
import org.jetbrains.kotlin.incremental.ProtoCompareGenerated;
import org.jetbrains.kotlin.incremental.ProtoDifferenceUtilsKt;
import org.jetbrains.kotlin.incremental.storage.ProtoMapValue;
import org.jetbrains.kotlin.protobuf.MessageLite;
import org.jetbrains.kotlin.serialization.ClassData;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.serialization.jvm.JvmProtoBufUtil;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000eR\u0014\u0010\u0019\u001a\u00020\u0010X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0012R\u0011\u0010\u001b\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0016\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/incremental/DifferenceCalculatorForClass;", "Lorg/jetbrains/kotlin/incremental/DifferenceCalculator;", "oldData", "Lorg/jetbrains/kotlin/incremental/storage/ProtoMapValue;", "newData", "(Lorg/jetbrains/kotlin/incremental/storage/ProtoMapValue;Lorg/jetbrains/kotlin/incremental/storage/ProtoMapValue;)V", "diff", "Ljava/util/EnumSet;", "Lorg/jetbrains/kotlin/incremental/ProtoCompareGenerated$ProtoBufClassKind;", "getDiff", "()Ljava/util/EnumSet;", "newClassData", "Lorg/jetbrains/kotlin/serialization/ClassData;", "getNewClassData", "()Lorg/jetbrains/kotlin/serialization/ClassData;", "newNameResolver", "Lorg/jetbrains/kotlin/serialization/deserialization/NameResolver;", "getNewNameResolver", "()Lorg/jetbrains/kotlin/serialization/deserialization/NameResolver;", "newProto", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Class;", "getNewProto", "()Lorg/jetbrains/kotlin/serialization/ProtoBuf$Class;", "oldClassData", "getOldClassData", "oldNameResolver", "getOldNameResolver", "oldProto", "getOldProto", "difference", "Lorg/jetbrains/kotlin/incremental/Difference;", "kotlin-compiler"})
final class DifferenceCalculatorForClass
extends DifferenceCalculator {
    @NotNull
    private final ClassData oldClassData;
    @NotNull
    private final ClassData newClassData;
    @NotNull
    private final ProtoBuf.Class oldProto;
    @NotNull
    private final ProtoBuf.Class newProto;
    @NotNull
    private final NameResolver oldNameResolver;
    @NotNull
    private final NameResolver newNameResolver;
    @NotNull
    private final EnumSet<ProtoCompareGenerated.ProtoBufClassKind> diff;

    @NotNull
    public final ClassData getOldClassData() {
        return this.oldClassData;
    }

    @NotNull
    public final ClassData getNewClassData() {
        return this.newClassData;
    }

    @NotNull
    public final ProtoBuf.Class getOldProto() {
        return this.oldProto;
    }

    @NotNull
    public final ProtoBuf.Class getNewProto() {
        return this.newProto;
    }

    @Override
    @NotNull
    protected NameResolver getOldNameResolver() {
        return this.oldNameResolver;
    }

    @Override
    @NotNull
    protected NameResolver getNewNameResolver() {
        return this.newNameResolver;
    }

    @NotNull
    public final EnumSet<ProtoCompareGenerated.ProtoBufClassKind> getDiff() {
        return this.diff;
    }

    @Override
    @NotNull
    public Difference difference() {
        boolean isClassAffected = false;
        boolean areSubclassesAffected = false;
        HashSet<String> names2 = new HashSet<String>();
        boolean classIsSealed = ProtoDifferenceUtilsKt.access$isSealed$p(this.newProto) && ProtoDifferenceUtilsKt.access$isSealed$p(this.oldProto);
        Function1<Integer, Boolean> oldToNames$ = new Function1<Integer, Boolean>(this, names2){
            final /* synthetic */ DifferenceCalculatorForClass this$0;
            final /* synthetic */ HashSet $names;

            public final boolean invoke(int $receiver) {
                return this.$names.add(this.this$0.getOldNameResolver().getString($receiver));
            }
            {
                this.this$0 = differenceCalculatorForClass;
                this.$names = hashSet;
                super(1);
            }
        };
        Function1<Integer, Boolean> newToNames$ = new Function1<Integer, Boolean>(this, names2){
            final /* synthetic */ DifferenceCalculatorForClass this$0;
            final /* synthetic */ HashSet $names;

            public final boolean invoke(int $receiver) {
                return this.$names.add(this.this$0.getNewNameResolver().getString($receiver));
            }
            {
                this.this$0 = differenceCalculatorForClass;
                this.$names = hashSet;
                super(1);
            }
        };
        Function1<Function1<? super ProtoBuf.Class, ? extends List<? extends MessageLite>>, Collection<? extends String>> calcDifferenceForNonPrivateMembers$ = new Function1<Function1<? super ProtoBuf.Class, ? extends List<? extends MessageLite>>, Collection<? extends String>>(this){
            final /* synthetic */ DifferenceCalculatorForClass this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Collection<String> invoke(@NotNull Function1<? super ProtoBuf.Class, ? extends List<? extends MessageLite>> members) {
                void $receiver$iv$iv;
                void $receiver$iv$iv2;
                Iterable $receiver$iv;
                Intrinsics.checkParameterIsNotNull(members, "members");
                Iterable iterable = $receiver$iv = (Iterable)members.invoke(this.this$0.getOldProto());
                Iterable<E> destination$iv$iv = new ArrayList<E>();
                for (T element$iv$iv : $receiver$iv$iv2) {
                    MessageLite it = (MessageLite)element$iv$iv;
                    if (ProtoDifferenceUtilsKt.isPrivate(it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List oldMembers = (List)destination$iv$iv;
                Iterable $receiver$iv2 = members.invoke(this.this$0.getNewProto());
                destination$iv$iv = $receiver$iv2;
                Collection destination$iv$iv2 = new ArrayList<E>();
                for (T element$iv$iv : $receiver$iv$iv) {
                    MessageLite it = (MessageLite)element$iv$iv;
                    if (ProtoDifferenceUtilsKt.isPrivate(it)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                List newMembers = (List)destination$iv$iv2;
                return this.this$0.calcDifferenceForMembers(oldMembers, newMembers);
            }
            {
                this.this$0 = differenceCalculatorForClass;
                super(1);
            }
        };
        Iterator iterator2 = this.diff.iterator();
        while (iterator2.hasNext()) {
            Object object;
            ProtoCompareGenerated.ProtoBufClassKind kind;
            ProtoCompareGenerated.ProtoBufClassKind protoBufClassKind = kind = (ProtoCompareGenerated.ProtoBufClassKind)((Object)iterator2.next());
            if (protoBufClassKind == null) {
                Intrinsics.throwNpe();
            }
            switch (DifferenceCalculatorForClass$WhenMappings.$EnumSwitchMapping$0[protoBufClassKind.ordinal()]) {
                case 1: {
                    if (this.oldProto.hasCompanionObjectName()) {
                        oldToNames$.invoke(this.oldProto.getCompanionObjectName());
                    }
                    if (this.newProto.hasCompanionObjectName()) {
                        newToNames$.invoke(this.newProto.getCompanionObjectName());
                    }
                    isClassAffected = true;
                    object = Unit.INSTANCE;
                    break;
                }
                case 2: {
                    if (classIsSealed) {
                        isClassAffected = true;
                    }
                    List<Integer> list2 = this.oldProto.getNestedClassNameList();
                    Intrinsics.checkExpressionValueIsNotNull(list2, "oldProto.nestedClassNameList");
                    List<Integer> list3 = this.newProto.getNestedClassNameList();
                    Intrinsics.checkExpressionValueIsNotNull(list3, "newProto.nestedClassNameList");
                    object = names2.addAll(this.calcDifferenceForNames(list2, list3));
                    break;
                }
                case 3: {
                    Collection<String> collection;
                    Collection<String> differentNonPrivateConstructors2 = calcDifferenceForNonPrivateMembers$.invoke((Function1<ProtoBuf.Class, List<MessageLite>>)((Function1<? super ProtoBuf.Class, ? extends List<? extends MessageLite>>)difference.unused.differentNonPrivateConstructors.1.INSTANCE));
                    isClassAffected = isClassAffected || !(collection = differentNonPrivateConstructors2).isEmpty();
                    object = Unit.INSTANCE;
                    break;
                }
                case 4: {
                    object = names2.addAll(calcDifferenceForNonPrivateMembers$.invoke((Function1<ProtoBuf.Class, List<MessageLite>>)((Function1<? super ProtoBuf.Class, ? extends List<? extends MessageLite>>)difference.unused.1.INSTANCE)));
                    break;
                }
                case 5: {
                    object = names2.addAll(calcDifferenceForNonPrivateMembers$.invoke((Function1<ProtoBuf.Class, List<MessageLite>>)((Function1<? super ProtoBuf.Class, ? extends List<? extends MessageLite>>)difference.unused.2.INSTANCE)));
                    break;
                }
                case 6: {
                    object = names2.addAll(calcDifferenceForNonPrivateMembers$.invoke((Function1<ProtoBuf.Class, List<MessageLite>>)((Function1<? super ProtoBuf.Class, ? extends List<? extends MessageLite>>)difference.unused.3.INSTANCE)));
                    break;
                }
                case 7: {
                    isClassAffected = true;
                    object = Unit.INSTANCE;
                    break;
                }
                case 8: {
                    object = Unit.INSTANCE;
                    break;
                }
                case 9: {
                    object = Unit.INSTANCE;
                    break;
                }
                case 10: 
                case 11: {
                    object = Unit.INSTANCE;
                    break;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    isClassAffected = true;
                    areSubclassesAffected = true;
                    object = Unit.INSTANCE;
                    break;
                }
                case 17: {
                    object = Unit.INSTANCE;
                    break;
                }
                case 18: {
                    object = Unit.INSTANCE;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Unit unit = object;
        }
        return new Difference(isClassAffected, areSubclassesAffected, (Set<String>)names2);
    }

    public DifferenceCalculatorForClass(@NotNull ProtoMapValue oldData, @NotNull ProtoMapValue newData) {
        Intrinsics.checkParameterIsNotNull(oldData, "oldData");
        Intrinsics.checkParameterIsNotNull(newData, "newData");
        this.oldClassData = JvmProtoBufUtil.readClassDataFrom(oldData.getBytes(), oldData.getStrings());
        this.newClassData = JvmProtoBufUtil.readClassDataFrom(newData.getBytes(), newData.getStrings());
        this.oldProto = this.oldClassData.getClassProto();
        this.newProto = this.newClassData.getClassProto();
        this.oldNameResolver = this.oldClassData.getNameResolver();
        this.newNameResolver = this.newClassData.getNameResolver();
        this.diff = this.getCompareObject().difference(this.oldProto, this.newProto);
    }
}

