/*
 * Decompiled with CFR 0.152.
 */
package com.metasploit.meterpreter;

import com.metasploit.meterpreter.Meterpreter;
import com.metasploit.meterpreter.TLVPacket;
import com.metasploit.stage.ConfigParser;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class Transport {
    public static final long MS = 1000L;
    private Transport prev;
    private Transport next;
    protected String url;
    protected long commTimeout;
    protected long retryTotal;
    protected long retryWait;

    protected abstract boolean tryConnect(Meterpreter var1) throws IOException;

    public abstract int parseConfig(byte[] var1, int var2);

    public abstract void bind(DataInputStream var1, OutputStream var2);

    public abstract void disconnect();

    public abstract boolean dispatch(Meterpreter var1);

    public abstract void writePacket(TLVPacket var1, int var2) throws IOException;

    public abstract TLVPacket readPacket() throws IOException;

    public abstract boolean switchUri(String var1);

    protected Transport(String string) {
        this.url = string;
    }

    protected int parseTimeouts(byte[] byArray, int n) {
        this.commTimeout = 1000L * (long)ConfigParser.unpack32(byArray, n);
        this.retryTotal = 1000L * (long)ConfigParser.unpack32(byArray, n += 4);
        this.retryWait = 1000L * (long)ConfigParser.unpack32(byArray, n += 4);
        return n += 4;
    }

    protected TLVPacket readAndDecodePacket(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        int n2 = (dataInputStream.readInt() ^ Integer.reverseBytes(n)) - 8;
        int n3 = dataInputStream.readInt();
        byte[] byArray = new byte[n2];
        dataInputStream.readFully(byArray);
        this.xorBytes(n, byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream2 = new DataInputStream(byteArrayInputStream);
        TLVPacket tLVPacket = new TLVPacket(dataInputStream2, n2);
        dataInputStream2.close();
        return tLVPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encodePacketAndWrite(TLVPacket tLVPacket, int n, DataOutputStream dataOutputStream) throws IOException {
        int n2 = this.randXorKey();
        byte[] byArray = tLVPacket.toByteArray();
        this.xorBytes(n2, byArray);
        DataOutputStream dataOutputStream2 = dataOutputStream;
        synchronized (dataOutputStream2) {
            dataOutputStream.writeInt(n2);
            dataOutputStream.writeInt(byArray.length + 8 ^ Integer.reverseBytes(n2));
            dataOutputStream.writeInt(n ^ Integer.reverseBytes(n2));
            dataOutputStream.write(byArray);
            dataOutputStream.flush();
        }
    }

    private int randXorKey() {
        return this.randByte() | this.randByte() << 8 | this.randByte() << 16 | this.randByte() << 24;
    }

    private int randByte() {
        return 0xFF & (int)(Math.random() * 255.0 + 1.0);
    }

    private void xorBytes(int n, byte[] byArray) {
        byte[] byArray2 = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 24 & 0xFF)};
        for (int i = 0; i < byArray.length; ++i) {
            int n2 = i;
            byArray[n2] = (byte)(byArray[n2] ^ byArray2[i % byArray2.length]);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public long getCommTimeout() {
        return this.commTimeout / 1000L;
    }

    public void setCommTimeout(long l) {
        this.commTimeout = l * 1000L;
    }

    public long getRetryTotal() {
        return this.retryTotal / 1000L;
    }

    public void setRetryTotal(long l) {
        this.retryTotal = l * 1000L;
    }

    public long getRetryWait() {
        return this.retryWait / 1000L;
    }

    public void setRetryWait(long l) {
        this.retryWait = l * 1000L;
    }

    public boolean connect(Meterpreter meterpreter) {
        long l = System.currentTimeMillis();
        while (System.currentTimeMillis() < l + this.retryTotal) {
            try {
                if (this.tryConnect(meterpreter)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            meterpreter.sleep(this.retryWait);
        }
        return false;
    }

    public void setPrev(Transport transport) {
        this.prev = transport;
    }

    public void setNext(Transport transport) {
        this.next = transport;
    }

    public Transport getPrev() {
        return this.prev;
    }

    public Transport getNext() {
        return this.next;
    }
}

