#ifndef _EFL_IO_MANAGER_EO_H_
#define _EFL_IO_MANAGER_EO_H_

#ifndef _EFL_IO_MANAGER_EO_CLASS_TYPE
#define _EFL_IO_MANAGER_EO_CLASS_TYPE

typedef Eo Efl_Io_Manager;

#endif

#ifndef _EFL_IO_MANAGER_EO_TYPES
#define _EFL_IO_MANAGER_EO_TYPES

/** A structure to handle arbitrary data to be sent over Promises.
 *
 * @ingroup Eio
 */
typedef struct _Eio_Data
{
  void *data;
  unsigned int size;
} Eio_Data;

typedef struct _Eio_Filter_Direct_Data
{
  const Eina_File_Direct_Info *info;
  Eina_Bool filter;
} Eio_Filter_Direct_Data;

typedef struct _Eio_Filter_Name_Data
{
  const char *file;
  Eina_Bool filter;
} Eio_Filter_Name_Data;

typedef struct _Eio_Xattr_Data
{
  const char *data;
  unsigned int size;
} Eio_Xattr_Data;


#endif
/** Class representing an asynchronous file operation.
 *
 * @ingroup Efl_Io_Manager
 */
#define EFL_IO_MANAGER_CLASS efl_io_manager_class_get()

EWAPI const Eo_Class *efl_io_manager_class_get(void);

/**
 * @brief Lists all extended attributes asynchronously.
 *
 * @param[in] path
 *
 * @ingroup Efl_Io_Manager
 */
EOAPI Eina_Promise *efl_io_manager_file_xattr_list_get(const Eo *obj, const char * path);

/**
 * @brief Retrieves or sets information of a given extended attribute.
 *
 * @param[in] path
 * @param[in] attribute
 * @param[in] xattr_data
 * @param[in] xattr_size
 * @param[in] flags
 *
 * @ingroup Efl_Io_Manager
 */
EOAPI Eina_Promise *efl_io_manager_file_xattr_set(Eo *obj, const char * path, const char *attribute, const char *xattr_data, unsigned int xattr_size, Eina_Xattr_Flags flags);

/**
 * @brief Retrieves or sets information of a given extended attribute.
 *
 * @param[in] path
 * @param[in] attribute
 *
 * @ingroup Efl_Io_Manager
 */
EOAPI Eina_Promise *efl_io_manager_file_xattr_get(const Eo *obj, const char * path, const char * attribute);

/**
 * @brief Lists entries in a given path.
 *
 * @param[in] path
 *
 * @ingroup Efl_Io_Manager
 */
EOAPI Eina_Promise *efl_io_manager_file_ls(Eo *obj, const char *path);

/**
 * @brief Lists entries in a given path with more information.
 *
 * @param[in] path
 *
 * @ingroup Efl_Io_Manager
 */
EOAPI Eina_Promise *efl_io_manager_file_direct_ls(Eo *obj, const char *path);

/**
 * @brief Lists entries in a given path with stat information.
 *
 * @param[in] path
 *
 * @ingroup Efl_Io_Manager
 */
EOAPI Eina_Promise *efl_io_manager_file_stat_ls(Eo *obj, const char *path);

/**
 * @brief Recursively list the directory content and its sub content.
 *
 * @param[in] path
 *
 * @ingroup Efl_Io_Manager
 */
EOAPI Eina_Promise *efl_io_manager_dir_stat_ls(Eo *obj, const char *path);

/**
 * @brief Recursively list the directory content and its sub content.
 *
 * @param[in] path
 *
 * @ingroup Efl_Io_Manager
 */
EOAPI Eina_Promise *efl_io_manager_dir_direct_ls(Eo *obj, const char *path);

/**
 * @brief Get stat info on a given file/directory.
 *
 * @param[in] path
 *
 * @ingroup Efl_Io_Manager
 */
EOAPI Eina_Promise *efl_io_manager_file_direct_stat(Eo *obj, const char *path);

/**
 * @brief Opens a file.
 *
 * The fulfilled value in the promise will be the Eina.File*.
 *
 * @param[in] path
 * @param[in] shared
 *
 * @ingroup Efl_Io_Manager
 */
EOAPI Eina_Promise *efl_io_manager_file_open(Eo *obj, const char *path, Eina_Bool shared);

/**
 * @brief Closes an open Eina.File.
 *
 * @param[in] file
 * @param[in,out] promise
 *
 * @ingroup Efl_Io_Manager
 */
EOAPI void efl_io_manager_file_close(Eo *obj, Eina_File *file, Eina_Promise **promise);

EOAPI extern const Eo_Event_Description _EFL_IO_MANAGER_EVENT_FILTER_NAME;
EOAPI extern const Eo_Event_Description _EFL_IO_MANAGER_EVENT_FILTER_DIRECT;
EOAPI extern const Eo_Event_Description _EFL_IO_MANAGER_EVENT_XATTR;

/**
 * No description
 */
#define EFL_IO_MANAGER_EVENT_FILTER_NAME (&(_EFL_IO_MANAGER_EVENT_FILTER_NAME))

/**
 * No description
 */
#define EFL_IO_MANAGER_EVENT_FILTER_DIRECT (&(_EFL_IO_MANAGER_EVENT_FILTER_DIRECT))

/**
 * No description
 */
#define EFL_IO_MANAGER_EVENT_XATTR (&(_EFL_IO_MANAGER_EVENT_XATTR))

#endif
