-- EFL LuaJIT bindings: elm_app_client.eo (class Elm.App.Client)
-- For use with Elua; automatically generated, do not modify

local cutil = require("cutil")
local util  = require("util")
local ffi   = require("ffi")
local eo    = require("eo")

local M, __lib = ...

local __class
local __body

local init = function()
    __class = __lib.elm_app_client_class_get()
    eo.class_register("Elm_App_Client", {"Eo_Base"}, nil, __body, __class)
end

cutil.init_module(init, function() end)

ffi.cdef [[
    const Eo_Class *elm_app_client_class_get(void);
    Eina_Iterator *elm_app_client_views_get(void);
    const char *elm_app_client_package_get(void);
    void elm_app_client_constructor(const char * package);
    void elm_app_client_view_all_close(void);
    void elm_app_client_terminate(void);
    Elm_App_Client_Pending *elm_app_client_view_open(Eina_Value * args, Elm_App_Client_Open_View_Cb view_open_cb, const void * data);
    void elm_app_client_view_open_cancel(Elm_App_Client_Pending * pending);
    extern const Eo_Event_Description _ELM_APP_CLIENT_EVENT_VIEW_CREATED;
    extern const Eo_Event_Description _ELM_APP_CLIENT_EVENT_VIEW_DELETED;
    extern const Eo_Event_Description _ELM_APP_CLIENT_EVENT_VIEW_LIST_LOADED;
    extern const Eo_Event_Description _ELM_APP_CLIENT_EVENT_APPLICATION_TERMINATED;
]]

local __M = util.get_namespace(M, { "app" })
__body = {
    __eo_ctor = function(self, constructor_package, __func)
        self:constructor(constructor_package)
        if __func then __func() end
    end,

    views_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_app_client_views_get()
        eo.__do_end()
        return v
    end,

    package_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_app_client_package_get()
        eo.__do_end()
        return v
    end,

    constructor = function(self, package)
        eo.__do_start(self, __class)
        __lib.elm_app_client_constructor(package)
        eo.__do_end()
    end,

    view_all_close = function(self)
        eo.__do_start(self, __class)
        __lib.elm_app_client_view_all_close()
        eo.__do_end()
    end,

    terminate = function(self)
        eo.__do_start(self, __class)
        __lib.elm_app_client_terminate()
        eo.__do_end()
    end,

    view_open = function(self, args, view_open_cb, data)
        eo.__do_start(self, __class)
        local v = __lib.elm_app_client_view_open(args, view_open_cb, data)
        eo.__do_end()
        return v
    end,

    view_open_cancel = function(self, pending)
        eo.__do_start(self, __class)
        __lib.elm_app_client_view_open_cancel(pending)
        eo.__do_end()
    end,

    __events = {
        ["view,created"] = __lib._ELM_APP_CLIENT_EVENT_VIEW_CREATED,
        ["view,deleted"] = __lib._ELM_APP_CLIENT_EVENT_VIEW_DELETED,
        ["view_list,loaded"] = __lib._ELM_APP_CLIENT_EVENT_VIEW_LIST_LOADED,
        ["application,terminated"] = __lib._ELM_APP_CLIENT_EVENT_APPLICATION_TERMINATED
    },

    __properties = {
        ["package"] = { 0, 0, 1, 0, true, false },
        ["views"] = { 0, 0, 1, 0, true, false }
    }
}

__M.Client = function(parent, ...)
    return eo.__ctor_common(__class, parent, eo.class_get("Elm_App_Client").__eo_ctor,
                            1, ...)
end

return M
