-- EFL LuaJIT bindings: elm_app_client_view.eo (class Elm.App.Client.View)
-- For use with Elua; automatically generated, do not modify

local cutil = require("cutil")
local util  = require("util")
local ffi   = require("ffi")
local eo    = require("eo")

local M, __lib = ...

local __class
local __body

local init = function()
    __class = __lib.elm_app_client_view_class_get()
    eo.class_register("Elm_App_Client_View", {"Eo_Base"}, nil, __body, __class)
end

cutil.init_module(init, function() end)

ffi.cdef [[
    const Eo_Class *elm_app_client_view_class_get(void);
    Elm_App_View_State elm_app_client_view_state_get(void);
    int elm_app_client_view_new_events_get(void);
    int elm_app_client_view_window_get(void);
    void elm_app_client_view_icon_pixels_get(unsigned int *w, unsigned int *h, Eina_Bool *has_alpha, const unsigned char * *pixels);
    Eina_Stringshare *elm_app_client_view_path_get(void);
    const char *elm_app_client_view_package_get(void);
    const char *elm_app_client_view_icon_get(void);
    unsigned short elm_app_client_view_progress_get(void);
    const char *elm_app_client_view_title_get(void);
    void elm_app_client_view_path_set(const char * path);
    void elm_app_client_view_pause(Elm_App_Client_View_Cb cb, const void * data);
    void elm_app_client_view_resume(Elm_App_Client_View_Cb cb, const void * data);
    void elm_app_client_view_close(Elm_App_Client_View_Cb cb, const void * data);
    extern const Eo_Event_Description _ELM_APP_CLIENT_VIEW_EVENT_STATE_CHANGED;
    extern const Eo_Event_Description _ELM_APP_CLIENT_VIEW_EVENT_TITLE_CHANGED;
    extern const Eo_Event_Description _ELM_APP_CLIENT_VIEW_EVENT_ICON_CHANGED;
    extern const Eo_Event_Description _ELM_APP_CLIENT_VIEW_EVENT_ICON_PIXELS_CHANGED;
    extern const Eo_Event_Description _ELM_APP_CLIENT_VIEW_EVENT_NEW_EVENTS_CHANGED;
    extern const Eo_Event_Description _ELM_APP_CLIENT_VIEW_EVENT_PROGRESS_CHANGED;
    extern const Eo_Event_Description _ELM_APP_CLIENT_VIEW_EVENT_WINDOW_CHANGED;
    extern const Eo_Event_Description _ELM_APP_CLIENT_VIEW_EVENT_PROPERTY_CHANGED;
]]

local __M = util.get_namespace(M, { "app", "client" })
__body = {
    __eo_ctor = function(self, __func)
        if __func then __func() end
    end,

    state_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_app_client_view_state_get()
        eo.__do_end()
        return v
    end,

    new_events_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_app_client_view_new_events_get()
        eo.__do_end()
        return tonumber(v)
    end,

    window_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_app_client_view_window_get()
        eo.__do_end()
        return tonumber(v)
    end,

    icon_pixels_get = function(self)
        eo.__do_start(self, __class)
        local w = ffi.new("unsigned int[1]")
        local h = ffi.new("unsigned int[1]")
        local has_alpha = ffi.new("Eina_Bool[1]")
        local pixels = ffi.new("const unsigned char *[1]")
        __lib.elm_app_client_view_icon_pixels_get(w, h, has_alpha, pixels)
        eo.__do_end()
        return w[0], h[0], ((has_alpha[0]) ~= 0), pixels[0]
    end,

    path_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_app_client_view_path_get()
        eo.__do_end()
        return v
    end,

    package_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_app_client_view_package_get()
        eo.__do_end()
        return v
    end,

    icon_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_app_client_view_icon_get()
        eo.__do_end()
        return v
    end,

    progress_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_app_client_view_progress_get()
        eo.__do_end()
        return v
    end,

    title_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_app_client_view_title_get()
        eo.__do_end()
        return v
    end,

    path_set = function(self, path)
        eo.__do_start(self, __class)
        __lib.elm_app_client_view_path_set(path)
        eo.__do_end()
    end,

    pause = function(self, cb, data)
        eo.__do_start(self, __class)
        __lib.elm_app_client_view_pause(cb, data)
        eo.__do_end()
    end,

    resume = function(self, cb, data)
        eo.__do_start(self, __class)
        __lib.elm_app_client_view_resume(cb, data)
        eo.__do_end()
    end,

    close = function(self, cb, data)
        eo.__do_start(self, __class)
        __lib.elm_app_client_view_close(cb, data)
        eo.__do_end()
    end,

    __events = {
        ["state,changed"] = __lib._ELM_APP_CLIENT_VIEW_EVENT_STATE_CHANGED,
        ["title,changed"] = __lib._ELM_APP_CLIENT_VIEW_EVENT_TITLE_CHANGED,
        ["icon,changed"] = __lib._ELM_APP_CLIENT_VIEW_EVENT_ICON_CHANGED,
        ["icon,pixels,changed"] = __lib._ELM_APP_CLIENT_VIEW_EVENT_ICON_PIXELS_CHANGED,
        ["new_events,changed"] = __lib._ELM_APP_CLIENT_VIEW_EVENT_NEW_EVENTS_CHANGED,
        ["progress,changed"] = __lib._ELM_APP_CLIENT_VIEW_EVENT_PROGRESS_CHANGED,
        ["window,changed"] = __lib._ELM_APP_CLIENT_VIEW_EVENT_WINDOW_CHANGED,
        ["property,changed"] = __lib._ELM_APP_CLIENT_VIEW_EVENT_PROPERTY_CHANGED
    },

    __properties = {
        ["new_events"] = { 0, 0, 1, 0, true, false },
        ["package"] = { 0, 0, 1, 0, true, false },
        ["path"] = { 0, 0, 1, 0, true, false },
        ["title"] = { 0, 0, 1, 0, true, false },
        ["icon"] = { 0, 0, 1, 0, true, false },
        ["progress"] = { 0, 0, 1, 0, true, false },
        ["window"] = { 0, 0, 1, 0, true, false },
        ["state"] = { 0, 0, 1, 0, true, false },
        ["icon_pixels"] = { 0, 0, 4, 0, true, false }
    }
}

__M.View = function(parent, ...)
    return eo.__ctor_common(__class, parent, eo.class_get("Elm_App_Client_View").__eo_ctor,
                            1, ...)
end

return M
