/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.tilesources;

import java.awt.Point;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.OsmMercator;
import org.openstreetmap.gui.jmapviewer.Projected;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.TileRange;
import org.openstreetmap.gui.jmapviewer.TileXY;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.IProjected;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTMSTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TileSourceInfo;

public class TMSTileSource
extends AbstractTMSTileSource {
    protected int maxZoom;
    protected int minZoom;
    protected OsmMercator osmMercator;

    public TMSTileSource(TileSourceInfo tileSourceInfo) {
        super(tileSourceInfo);
        this.minZoom = tileSourceInfo.getMinZoom();
        this.maxZoom = tileSourceInfo.getMaxZoom();
        this.osmMercator = new OsmMercator(this.getTileSize());
    }

    @Override
    public int getMinZoom() {
        return this.minZoom == 0 ? super.getMinZoom() : this.minZoom;
    }

    @Override
    public int getMaxZoom() {
        return this.maxZoom == 0 ? super.getMaxZoom() : this.maxZoom;
    }

    @Override
    public double getDistance(double d, double d2, double d3, double d4) {
        return this.osmMercator.getDistance(d, d2, d3, d4);
    }

    @Override
    public Point latLonToXY(double d, double d2, int n) {
        return new Point((int)Math.round(this.osmMercator.lonToX(d2, n)), (int)Math.round(this.osmMercator.latToY(d, n)));
    }

    @Override
    public ICoordinate xyToLatLon(int n, int n2, int n3) {
        return new Coordinate(this.osmMercator.yToLat(n2, n3), this.osmMercator.xToLon(n, n3));
    }

    @Override
    public TileXY latLonToTileXY(double d, double d2, int n) {
        return new TileXY(this.osmMercator.lonToX(d2, n) / (double)this.getTileSize(), this.osmMercator.latToY(d, n) / (double)this.getTileSize());
    }

    @Override
    public ICoordinate tileXYToLatLon(int n, int n2, int n3) {
        return new Coordinate(this.osmMercator.yToLat(n2 * this.getTileSize(), n3), this.osmMercator.xToLon(n * this.getTileSize(), n3));
    }

    @Override
    public IProjected tileXYtoProjected(int n, int n2, int n3) {
        double d = 4.007501668557849E7;
        double d2 = d * (double)this.getTileSize() / (double)this.osmMercator.getMaxPixels(n3);
        return new Projected(d2 * (double)n - d / 2.0, -(d2 * (double)n2 - d / 2.0));
    }

    @Override
    public TileXY projectedToTileXY(IProjected iProjected, int n) {
        double d = 4.007501668557849E7;
        double d2 = d * (double)this.getTileSize() / (double)this.osmMercator.getMaxPixels(n);
        return new TileXY((iProjected.getEast() + d / 2.0) / d2, (-iProjected.getNorth() + d / 2.0) / d2);
    }

    @Override
    public boolean isInside(Tile tile, Tile tile2) {
        int n = tile.getZoom() - tile2.getZoom();
        if (n < 0) {
            return false;
        }
        return tile2.getXtile() == tile.getXtile() >> n && tile2.getYtile() == tile.getYtile() >> n;
    }

    @Override
    public TileRange getCoveringTileRange(Tile tile, int n) {
        if (n <= tile.getZoom()) {
            int n2 = tile.getZoom() - n;
            TileXY tileXY = new TileXY(tile.getXtile() >> n2, tile.getYtile() >> n2);
            return new TileRange(tileXY, tileXY, n);
        }
        int n3 = n - tile.getZoom();
        TileXY tileXY = new TileXY(tile.getXtile() << n3, tile.getYtile() << n3);
        TileXY tileXY2 = new TileXY(tileXY.getX() + (double)(1 << n3) - 1.0, tileXY.getY() + (double)(1 << n3) - 1.0);
        return new TileRange(tileXY, tileXY2, n);
    }

    @Override
    public String getServerCRS() {
        return "EPSG:3857";
    }
}

