/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DatasetConsistencyTest;
import org.openstreetmap.josm.data.preferences.Setting;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.SourceEditor;
import org.openstreetmap.josm.gui.preferences.map.MapPaintPreference;
import org.openstreetmap.josm.gui.preferences.map.TaggingPresetPreference;
import org.openstreetmap.josm.gui.preferences.validator.ValidatorTagCheckerRulesPreference;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.PlatformHookUnixoid;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.bugreport.BugReportSender;
import org.openstreetmap.josm.tools.bugreport.DebugTextDisplay;

public final class ShowStatusReportAction
extends JosmAction {
    public ShowStatusReportAction() {
        super(I18n.tr("Show Status Report", new Object[0]), "clock", I18n.tr("Show status report with useful information that can be attached to bugs", new Object[0]), Shortcut.registerShortcut("help:showstatusreport", I18n.tr("Help: {0}", I18n.tr("Show Status Report", new Object[0])), 65535, 5000), false);
        this.putValue("help", HelpUtil.ht("/Action/ShowStatusReport"));
        this.putValue("toolbar", "help/showstatusreport");
        Main.toolbar.register(this);
    }

    private static boolean isRunningJavaWebStart() {
        try {
            return Class.forName("javax.jnlp.ServiceManager") != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static String getReportHeader() {
        String string2;
        Object object;
        Object object2;
        StringBuilder stringBuilder = new StringBuilder(256);
        String string3 = System.getProperty("java.runtime.version");
        stringBuilder.append(Version.getInstance().getReleaseAttributes()).append("\nIdentification: ").append(Version.getInstance().getAgentString());
        String string4 = Main.platform.getOSBuildNumber();
        if (!string4.isEmpty()) {
            stringBuilder.append("\nOS Build number: ").append(string4);
        }
        stringBuilder.append("\nMemory Usage: ").append(Runtime.getRuntime().totalMemory() / 1024L / 1024L).append(" MB / ").append(Runtime.getRuntime().maxMemory() / 1024L / 1024L).append(" MB (").append(Runtime.getRuntime().freeMemory() / 1024L / 1024L).append(" MB allocated, but free)\nJava version: ").append(string3 != null ? string3 : System.getProperty("java.version")).append(", ").append(System.getProperty("java.vendor")).append(", ").append(System.getProperty("java.vm.name")).append("\nScreen: ");
        if (!GraphicsEnvironment.isHeadless()) {
            stringBuilder.append(Arrays.stream(GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()).map(graphicsDevice -> {
                StringBuilder stringBuilder = new StringBuilder(graphicsDevice.getIDstring());
                DisplayMode displayMode = graphicsDevice.getDisplayMode();
                if (displayMode != null) {
                    stringBuilder.append(' ').append(displayMode.getWidth()).append('x').append(displayMode.getHeight());
                }
                return stringBuilder.toString();
            }).collect(Collectors.joining(", ")));
        }
        Dimension dimension = GuiHelper.getMaximumScreenSize();
        stringBuilder.append("\nMaximum Screen Size: ").append((int)dimension.getWidth()).append('x').append((int)dimension.getHeight()).append('\n');
        if (Main.platform instanceof PlatformHookUnixoid) {
            object2 = ((PlatformHookUnixoid)Main.platform).getJavaPackageDetails();
            if (object2 != null) {
                stringBuilder.append("Java package: ").append((String)object2).append('\n');
            }
            if (ShowStatusReportAction.isRunningJavaWebStart() && (object = ((PlatformHookUnixoid)Main.platform).getWebStartPackageDetails()) != null) {
                stringBuilder.append("WebStart package: ").append((String)object).append('\n');
            }
            if ((object = ((PlatformHookUnixoid)Main.platform).getAtkWrapperPackageDetails()) != null) {
                stringBuilder.append("Java ATK Wrapper package: ").append((String)object).append('\n');
            }
        }
        try {
            object2 = new ArrayList<String>(ManagementFactory.getRuntimeMXBean().getInputArguments());
            object = object2.listIterator();
            while (object.hasNext()) {
                string2 = (String)object.next();
                if (string2.contains("=")) {
                    String[] stringArray = string2.split("=");
                    if (stringArray[0].toLowerCase(Locale.ENGLISH).startsWith("-dproxy")) {
                        object.set(stringArray[0] + "=xxx");
                        continue;
                    }
                    if ("-Djnlpx.vmargs".equals(stringArray[0])) {
                        object.remove();
                        continue;
                    }
                    String string5 = ShowStatusReportAction.paramCleanup(stringArray[1]);
                    if (string5.equals(stringArray[1])) continue;
                    object.set(stringArray[0] + '=' + string5);
                    continue;
                }
                if (!string2.startsWith("-X")) continue;
                object.remove();
            }
            if (!object2.isEmpty()) {
                stringBuilder.append("VM arguments: ").append(object2.toString().replace("\\\\", "\\")).append('\n');
            }
        }
        catch (SecurityException securityException) {
            Main.trace(securityException);
        }
        object2 = MainApplication.getCommandLineArgs();
        if (!object2.isEmpty()) {
            stringBuilder.append("Program arguments: ").append(Arrays.toString(ShowStatusReportAction.paramCleanup(object2).toArray())).append('\n');
        }
        if (Main.main != null && (object = Main.getLayerManager().getEditDataSet()) != null) {
            string2 = DatasetConsistencyTest.runTests((DataSet)object);
            if (string2.isEmpty()) {
                stringBuilder.append("Dataset consistency test: No problems found\n");
            } else {
                stringBuilder.append("\nDataset consistency test:\n").append(string2).append('\n');
            }
        }
        stringBuilder.append('\n');
        ShowStatusReportAction.appendCollection(stringBuilder, "Plugins", Utils.transform(PluginHandler.getBugReportInformation(), string -> "+ " + string));
        ShowStatusReportAction.appendCollection(stringBuilder, "Tagging presets", ShowStatusReportAction.getCustomUrls(TaggingPresetPreference.PresetPrefHelper.INSTANCE));
        ShowStatusReportAction.appendCollection(stringBuilder, "Map paint styles", ShowStatusReportAction.getCustomUrls(MapPaintPreference.MapPaintPrefHelper.INSTANCE));
        ShowStatusReportAction.appendCollection(stringBuilder, "Validator rules", ShowStatusReportAction.getCustomUrls(ValidatorTagCheckerRulesPreference.RulePrefHelper.INSTANCE));
        ShowStatusReportAction.appendCollection(stringBuilder, "Last errors/warnings", Utils.transform(Main.getLastErrorAndWarnings(), string -> "- " + string));
        object = OsmApi.getOsmApi().getServerUrl();
        if (!"https://api.openstreetmap.org/api".equals(((String)object).trim())) {
            stringBuilder.append("OSM API: ").append((String)object).append("\n\n");
        }
        return stringBuilder.toString();
    }

    private static Collection<String> getCustomUrls(SourceEditor.SourcePrefHelper sourcePrefHelper) {
        Set set = sourcePrefHelper.getDefault().stream().map(extendedSourceEntry -> extendedSourceEntry.url).collect(Collectors.toSet());
        return sourcePrefHelper.get().stream().filter(sourceEntry -> !set.contains(sourceEntry.url)).map(sourceEntry -> (sourceEntry.active ? "+ " : "- ") + sourceEntry.url).collect(Collectors.toList());
    }

    private static List<String> paramCleanup(Collection<String> collection) {
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        for (String string : collection) {
            arrayList.add(ShowStatusReportAction.paramCleanup(string));
        }
        return arrayList;
    }

    private static String paramCleanup(String string) {
        String string2 = System.getenv("JAVA_HOME");
        String string3 = Main.isPlatformWindows() ? "%JAVA_HOME%" : "${JAVA_HOME}";
        String string4 = System.getProperty("java.home");
        String string5 = Main.pref.getPreferencesDirectory().toString();
        String string6 = Main.pref.getUserDataDirectory().toString();
        String string7 = Main.pref.getCacheDirectory().toString();
        String string8 = System.getProperty("user.home");
        String string9 = Main.isPlatformWindows() ? "%UserProfile%" : "${HOME}";
        String string10 = System.getProperty("user.name");
        String string11 = string;
        string11 = ShowStatusReportAction.paramReplace(string11, string2, string3);
        string11 = ShowStatusReportAction.paramReplace(string11, string2, string3);
        string11 = ShowStatusReportAction.paramReplace(string11, string4, "<java.home>");
        string11 = ShowStatusReportAction.paramReplace(string11, string5, "<josm.pref>");
        string11 = ShowStatusReportAction.paramReplace(string11, string6, "<josm.userdata>");
        string11 = ShowStatusReportAction.paramReplace(string11, string7, "<josm.cache>");
        string11 = ShowStatusReportAction.paramReplace(string11, string8, string9);
        if (string10.length() >= 3) {
            string11 = ShowStatusReportAction.paramReplace(string11, string10, "<user.name>");
        }
        return string11;
    }

    private static String paramReplace(String string, String string2, String string3) {
        return string2 == null ? string : string.replace(string2, string3);
    }

    private static void appendCollection(StringBuilder stringBuilder, String string, Collection<String> collection) {
        if (!collection.isEmpty()) {
            stringBuilder.append(string).append(":\n");
            for (String string2 : collection) {
                stringBuilder.append(ShowStatusReportAction.paramCleanup(string2)).append('\n');
            }
            stringBuilder.append('\n');
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = ShowStatusReportAction.getReportHeader();
        stringBuilder.append(string);
        Map<String, Setting<?>> map = Main.pref.getAllSettings();
        HashSet<String> hashSet = new HashSet<String>(map.keySet());
        for (String object2 : hashSet) {
            if (!object2.startsWith("marker.show") && !object2.contains("username") && !object2.contains("password") && !object2.contains("access-token")) continue;
            map.remove(object2);
        }
        for (Map.Entry entry : map.entrySet()) {
            stringBuilder.append(ShowStatusReportAction.paramCleanup((String)entry.getKey())).append('=').append(ShowStatusReportAction.paramCleanup(((Setting)entry.getValue()).getValue().toString())).append('\n');
        }
        DebugTextDisplay debugTextDisplay = new DebugTextDisplay(stringBuilder.toString());
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Status Report", new Object[0]), I18n.tr("Copy to clipboard and close", new Object[0]), I18n.tr("Report bug", new Object[0]), I18n.tr("Close", new Object[0]));
        extendedDialog.setButtonIcons("copy", "bug", "cancel");
        extendedDialog.setContent(debugTextDisplay, false);
        extendedDialog.setMinimumSize(new Dimension(380, 200));
        extendedDialog.setPreferredSize(new Dimension(700, Main.parent.getHeight() - 50));
        switch (extendedDialog.showDialog().getValue()) {
            case 1: {
                debugTextDisplay.copyToClipboard();
                break;
            }
            case 2: {
                BugReportSender.reportBug(string);
                break;
            }
        }
    }
}

