/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor;

import java.util.Collection;
import java.util.HashSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;

public class AllNodesVisitor
extends AbstractVisitor {
    public Collection<Node> nodes = new HashSet<Node>();

    @Override
    public void visit(Node node) {
        this.nodes.add(node);
    }

    @Override
    public void visit(Way way) {
        if (way.isIncomplete()) {
            return;
        }
        for (Node node : way.getNodes()) {
            this.visit(node);
        }
    }

    @Override
    public void visit(Relation relation) {
        for (RelationMember relationMember : relation.getMembers()) {
            if (!relationMember.isNode()) continue;
            this.visit(relationMember.getNode());
        }
    }

    public static Collection<Node> getAllNodes(Collection<? extends OsmPrimitive> collection) {
        AllNodesVisitor allNodesVisitor = new AllNodesVisitor();
        for (OsmPrimitive osmPrimitive : collection) {
            osmPrimitive.accept(allNodesVisitor);
        }
        return allNodesVisitor.nodes;
    }
}

