/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.bbox;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.bbox.SlippyMapBBoxChooser;

public class SlippyMapControler
extends MouseAdapter {
    private static final Timer TIMER = new Timer(true);
    private MoveTask moveTask = new MoveTask();
    private static long timerInterval = 20L;
    private static final double MAX_SPEED = 20.0;
    private static final double ACCELERATION = 0.1;
    private static final int MAC_MOUSE_BUTTON3_MASK = 1152;
    private static final String[] N = new String[]{",", ".", "up", "right", "down", "left"};
    private static final int[] K = new int[]{44, 46, 38, 39, 40, 37};
    private Point iStartSelectionPoint;
    private Point iEndSelectionPoint;
    private final SlippyMapBBoxChooser iSlippyMapChooser;
    private boolean isSelecting;

    public SlippyMapControler(SlippyMapBBoxChooser slippyMapBBoxChooser, JPanel jPanel) {
        this.iSlippyMapChooser = slippyMapBBoxChooser;
        this.iSlippyMapChooser.addMouseListener(this);
        this.iSlippyMapChooser.addMouseMotionListener(this);
        if (jPanel != null) {
            for (int i = 0; i < N.length; ++i) {
                jPanel.getInputMap(2).put(KeyStroke.getKeyStroke(K[i], 128), "MapMover.Zoomer." + N[i]);
            }
        }
        this.isSelecting = false;
        InputMap inputMap = slippyMapBBoxChooser.getInputMap(2);
        ActionMap actionMap = slippyMapBBoxChooser.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(39, 0, false), "MOVE_RIGHT");
        inputMap.put(KeyStroke.getKeyStroke(37, 0, false), "MOVE_LEFT");
        inputMap.put(KeyStroke.getKeyStroke(38, 0, false), "MOVE_UP");
        inputMap.put(KeyStroke.getKeyStroke(40, 0, false), "MOVE_DOWN");
        inputMap.put(KeyStroke.getKeyStroke(39, 0, true), "STOP_MOVE_HORIZONTALLY");
        inputMap.put(KeyStroke.getKeyStroke(37, 0, true), "STOP_MOVE_HORIZONTALLY");
        inputMap.put(KeyStroke.getKeyStroke(38, 0, true), "STOP_MOVE_VERTICALLY");
        inputMap.put(KeyStroke.getKeyStroke(40, 0, true), "STOP_MOVE_VERTICALLY");
        inputMap.put(KeyStroke.getKeyStroke(38, 128, false), "ZOOM_IN");
        inputMap.put(KeyStroke.getKeyStroke(38, 256, false), "ZOOM_IN");
        inputMap.put(KeyStroke.getKeyStroke(38, 512, false), "ZOOM_IN");
        inputMap.put(KeyStroke.getKeyStroke(107, 0, false), "ZOOM_IN");
        inputMap.put(KeyStroke.getKeyStroke(521, 0, false), "ZOOM_IN");
        inputMap.put(KeyStroke.getKeyStroke(61, 0, false), "ZOOM_IN");
        inputMap.put(KeyStroke.getKeyStroke(61, 64, false), "ZOOM_IN");
        inputMap.put(KeyStroke.getKeyStroke(40, 128, false), "ZOOM_OUT");
        inputMap.put(KeyStroke.getKeyStroke(40, 256, false), "ZOOM_OUT");
        inputMap.put(KeyStroke.getKeyStroke(40, 512, false), "ZOOM_OUT");
        inputMap.put(KeyStroke.getKeyStroke(109, 0, false), "ZOOM_OUT");
        inputMap.put(KeyStroke.getKeyStroke(45, 0, false), "ZOOM_OUT");
        actionMap.put("MOVE_RIGHT", new MoveXAction(1));
        actionMap.put("MOVE_LEFT", new MoveXAction(-1));
        actionMap.put("MOVE_UP", new MoveYAction(-1));
        actionMap.put("MOVE_DOWN", new MoveYAction(1));
        actionMap.put("STOP_MOVE_HORIZONTALLY", new MoveXAction(0));
        actionMap.put("STOP_MOVE_VERTICALLY", new MoveYAction(0));
        actionMap.put("ZOOM_IN", new ZoomInAction());
        actionMap.put("ZOOM_OUT", new ZoomOutAction());
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!(mouseEvent.getButton() != 1 || Main.isPlatformOsx() && mouseEvent.getModifiersEx() == 1152)) {
            this.iStartSelectionPoint = mouseEvent.getPoint();
            this.iEndSelectionPoint = mouseEvent.getPoint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!(this.iStartSelectionPoint == null || (mouseEvent.getModifiersEx() & 0x400) != 1024 || Main.isPlatformOsx() && mouseEvent.getModifiersEx() == 1152)) {
            this.iEndSelectionPoint = mouseEvent.getPoint();
            this.iSlippyMapChooser.setSelection(this.iStartSelectionPoint, this.iEndSelectionPoint);
            this.isSelecting = true;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            if (this.isSelecting && mouseEvent.getClickCount() == 1) {
                this.iSlippyMapChooser.setSelection(this.iStartSelectionPoint, mouseEvent.getPoint());
                this.iEndSelectionPoint = null;
                this.iStartSelectionPoint = null;
                this.isSelecting = false;
            } else {
                this.iSlippyMapChooser.handleAttribution(mouseEvent.getPoint(), true);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.iSlippyMapChooser.handleAttribution(mouseEvent.getPoint(), false);
    }

    private class ZoomOutAction
    extends AbstractAction {
        private ZoomOutAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SlippyMapControler.this.iSlippyMapChooser.zoomOut();
        }
    }

    private class ZoomInAction
    extends AbstractAction {
        private ZoomInAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SlippyMapControler.this.iSlippyMapChooser.zoomIn();
        }
    }

    private class MoveTask
    extends TimerTask {
        private double speedX = 1.0;
        private double speedY = 1.0;
        private int directionX;
        private int directionY;
        protected boolean scheduled;

        private MoveTask() {
        }

        protected void setDirectionX(int n) {
            this.directionX = n;
            this.updateScheduleStatus();
        }

        protected void setDirectionY(int n) {
            this.directionY = n;
            this.updateScheduleStatus();
        }

        private void updateScheduleStatus() {
            boolean bl;
            boolean bl2 = bl = this.directionX != 0 || this.directionY != 0;
            if (bl != this.scheduled) {
                this.scheduled = bl;
                if (bl) {
                    TIMER.schedule((TimerTask)this, 0L, timerInterval);
                } else {
                    SlippyMapControler.this.moveTask = new MoveTask();
                    this.cancel();
                }
            }
        }

        @Override
        public void run() {
            switch (this.directionX) {
                case -1: {
                    if (this.speedX > -1.0) {
                        this.speedX = -1.0;
                    }
                    if (!(this.speedX > -20.0)) break;
                    this.speedX -= 0.1;
                    break;
                }
                case 0: {
                    this.speedX = 0.0;
                    break;
                }
                case 1: {
                    if (this.speedX < 1.0) {
                        this.speedX = 1.0;
                    }
                    if (!(this.speedX < 20.0)) break;
                    this.speedX += 0.1;
                    break;
                }
                default: {
                    throw new IllegalStateException(Integer.toString(this.directionX));
                }
            }
            switch (this.directionY) {
                case -1: {
                    if (this.speedY > -1.0) {
                        this.speedY = -1.0;
                    }
                    if (!(this.speedY > -20.0)) break;
                    this.speedY -= 0.1;
                    break;
                }
                case 0: {
                    this.speedY = 0.0;
                    break;
                }
                case 1: {
                    if (this.speedY < 1.0) {
                        this.speedY = 1.0;
                    }
                    if (!(this.speedY < 20.0)) break;
                    this.speedY += 0.1;
                    break;
                }
                default: {
                    throw new IllegalStateException(Integer.toString(this.directionY));
                }
            }
            int n = (int)Math.floor(this.speedX);
            int n2 = (int)Math.floor(this.speedY);
            if (n != 0 || n2 != 0) {
                SlippyMapControler.this.iSlippyMapChooser.moveMap(n, n2);
            }
        }
    }

    private class MoveYAction
    extends AbstractAction {
        private final int direction;

        MoveYAction(int n) {
            this.direction = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SlippyMapControler.this.moveTask.setDirectionY(this.direction);
        }
    }

    private class MoveXAction
    extends AbstractAction {
        private final int direction;

        MoveXAction(int n) {
            this.direction = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SlippyMapControler.this.moveTask.setDirectionX(this.direction);
        }
    }
}

