/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ChangesetListCellRenderer
extends JLabel
implements ListCellRenderer<Changeset> {
    public ChangesetListCellRenderer() {
        this.setOpaque(true);
        this.setIcon(ImageProvider.get("data", "changeset"));
    }

    protected void renderColors(boolean bl) {
        if (bl) {
            this.setForeground(UIManager.getColor("List.selectionForeground"));
            this.setBackground(UIManager.getColor("List.selectionBackground"));
        } else {
            this.setForeground(UIManager.getColor("List.foreground"));
            this.setBackground(UIManager.getColor("List.background"));
        }
    }

    protected void renderLabel(Changeset changeset) {
        StringBuilder stringBuilder = new StringBuilder();
        if (changeset.isIncomplete()) {
            stringBuilder.append(I18n.tr("{0} [incomplete]", changeset.getId()));
        } else {
            String string = changeset.getComment();
            stringBuilder.append(changeset.getId()).append(" - ").append(changeset.isOpen() ? I18n.tr("open", new Object[0]) : I18n.tr("closed", new Object[0]));
            if (!string.isEmpty()) {
                stringBuilder.append(" - '").append(string).append('\'');
            }
        }
        this.setText(stringBuilder.toString());
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends Changeset> jList, Changeset changeset, int n, boolean bl, boolean bl2) {
        this.renderColors(bl);
        this.renderLabel(changeset);
        return this;
    }
}

