/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.imagery;

import java.awt.HeadlessException;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WMSImagery {
    private List<LayerDetails> layers;
    private URL serviceUrl;
    private List<String> formats;

    public List<LayerDetails> getLayers() {
        return Collections.unmodifiableList(this.layers);
    }

    public URL getServiceUrl() {
        return this.serviceUrl;
    }

    public List<String> getFormats() {
        return Collections.unmodifiableList(this.formats);
    }

    public String getPreferredFormats() {
        if (this.formats.contains("image/jpeg")) {
            return "image/jpeg";
        }
        if (this.formats.contains("image/png")) {
            return "image/png";
        }
        if (this.formats.isEmpty()) {
            return null;
        }
        return this.formats.get(0);
    }

    String buildRootUrl() {
        if (this.serviceUrl == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(this.serviceUrl.getProtocol());
        stringBuilder.append("://").append(this.serviceUrl.getHost());
        if (this.serviceUrl.getPort() != -1) {
            stringBuilder.append(':').append(this.serviceUrl.getPort());
        }
        stringBuilder.append(this.serviceUrl.getPath()).append('?');
        if (this.serviceUrl.getQuery() != null) {
            stringBuilder.append(this.serviceUrl.getQuery());
            if (!this.serviceUrl.getQuery().isEmpty() && !this.serviceUrl.getQuery().endsWith("&")) {
                stringBuilder.append('&');
            }
        }
        return stringBuilder.toString();
    }

    public String buildGetMapUrl(Collection<LayerDetails> collection) {
        return this.buildGetMapUrl(collection, "image/jpeg");
    }

    public String buildGetMapUrl(Collection<LayerDetails> collection, String string) {
        return this.buildRootUrl() + "FORMAT=" + string + (WMSImagery.imageFormatHasTransparency(string) ? "&TRANSPARENT=TRUE" : "") + "&VERSION=1.1.1&SERVICE=WMS&REQUEST=GetMap&LAYERS=" + collection.stream().map(layerDetails -> layerDetails.ident).collect(Collectors.joining(",")) + "&STYLES=&SRS={proj}&WIDTH={width}&HEIGHT={height}&BBOX={bbox}";
    }

    public void attemptGetCapabilities(String string3) throws IOException, WMSGetCapabilitiesException {
        URL uRL = null;
        try {
            uRL = !Pattern.compile(".*GetCapabilities.*", 2).matcher(string3).matches() ? ((uRL = new URL(string3)).getQuery() == null ? new URL(string3 + '?' + "VERSION=1.1.1&SERVICE=WMS&REQUEST=GetCapabilities") : (!uRL.getQuery().isEmpty() && !uRL.getQuery().endsWith("&") ? new URL(string3 + '&' + "VERSION=1.1.1&SERVICE=WMS&REQUEST=GetCapabilities") : new URL(string3 + "VERSION=1.1.1&SERVICE=WMS&REQUEST=GetCapabilities"))) : new URL(string3);
            this.serviceUrl = new URL(string3);
        }
        catch (HeadlessException headlessException) {
            Main.warn(headlessException);
            return;
        }
        String string4 = HttpClient.create(uRL).connect().fetchContent();
        Main.debug("Server response to Capabilities request:");
        Main.debug(string4);
        try {
            Object object;
            DocumentBuilder documentBuilder = Utils.newSafeDOMBuilder();
            documentBuilder.setEntityResolver((string, string2) -> {
                Main.info("Ignoring DTD " + string + ", " + string2);
                return new InputSource(new StringReader(""));
            });
            Document document = documentBuilder.parse(new InputSource(new StringReader(string4)));
            Element element = document.getDocumentElement();
            if ("ServiceException".equals(element.getTagName())) {
                throw new WMSGetCapabilitiesException(element.getTextContent(), string4);
            }
            Element element2 = WMSImagery.getChild(element, "Capability");
            element2 = WMSImagery.getChild(element2, "Request");
            element2 = WMSImagery.getChild(element2, "GetMap");
            this.formats = WMSImagery.getChildrenStream(element2, "Format").map(Node::getTextContent).filter(WMSImagery::isImageFormatSupportedWarn).collect(Collectors.toList());
            element2 = WMSImagery.getChild(element2, "DCPType");
            element2 = WMSImagery.getChild(element2, "HTTP");
            element2 = WMSImagery.getChild(element2, "Get");
            if ((element2 = WMSImagery.getChild(element2, "OnlineResource")) != null && !((String)(object = element2.getAttribute("xlink:href"))).equals(string3)) {
                Main.info("GetCapabilities specifies a different service URL: " + (String)object);
                this.serviceUrl = new URL((String)object);
            }
            object = WMSImagery.getChild(element, "Capability");
            List<Element> list = WMSImagery.getChildren((Element)object, "Layer");
            this.layers = this.parseLayers(list, new HashSet<String>());
        }
        catch (MalformedURLException | ParserConfigurationException | SAXException exception) {
            throw new WMSGetCapabilitiesException(exception, string4);
        }
    }

    private static boolean isImageFormatSupportedWarn(String string) {
        boolean bl = WMSImagery.isImageFormatSupported(string);
        if (!bl) {
            Main.info("Skipping unsupported image format {0}", string);
        }
        return bl;
    }

    static boolean isImageFormatSupported(String string) {
        return ImageIO.getImageReadersByMIMEType(string).hasNext() || WMSImagery.isImageFormatSupported(string, "tiff", "geotiff") || WMSImagery.isImageFormatSupported(string, "png") || WMSImagery.isImageFormatSupported(string, "svg") || WMSImagery.isImageFormatSupported(string, "bmp");
    }

    static boolean isImageFormatSupported(String string, String ... stringArray) {
        for (String string2 : stringArray) {
            if (!string.startsWith("image/" + string2)) continue;
            return ImageIO.getImageReadersBySuffix(stringArray[0]).hasNext();
        }
        return false;
    }

    static boolean imageFormatHasTransparency(String string) {
        return string != null && (string.startsWith("image/png") || string.startsWith("image/gif") || string.startsWith("image/svg") || string.startsWith("image/tiff"));
    }

    public ImageryInfo toImageryInfo(String string, Collection<LayerDetails> collection) {
        ImageryInfo imageryInfo = new ImageryInfo(string, this.buildGetMapUrl(collection));
        if (collection != null) {
            HashSet<String> hashSet = new HashSet<String>();
            for (LayerDetails layerDetails : collection) {
                hashSet.addAll(layerDetails.getProjections());
            }
            imageryInfo.setServerProjections(hashSet);
        }
        return imageryInfo;
    }

    private List<LayerDetails> parseLayers(List<Element> list, Set<String> set) {
        ArrayList<LayerDetails> arrayList = new ArrayList<LayerDetails>(list.size());
        for (Element element : list) {
            arrayList.add(this.parseLayer(element, set));
        }
        return arrayList;
    }

    private LayerDetails parseLayer(Element element2, Set<String> set) {
        double d;
        String string2 = WMSImagery.getChildContent(element2, "Title", null, null);
        String string3 = WMSImagery.getChildContent(element2, "Name", null, null);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(set);
        WMSImagery.getChildrenStream(element2).filter(element -> "CRS".equals(element.getNodeName()) || "SRS".equals(element.getNodeName())).map(element -> (String)WMSImagery.getContent(element)).filter(string -> !string.isEmpty()).map(string -> string.trim().toUpperCase(Locale.ENGLISH)).forEach(hashSet::add);
        boolean bl = false;
        for (String object2 : hashSet) {
            bl |= WMSImagery.isProjSupported(object2);
        }
        Object object3 = null;
        Element element3 = WMSImagery.getChild(element2, "EX_GeographicBoundingBox");
        if (element3 != null) {
            d = Double.parseDouble(WMSImagery.getChildContent(element3, "westBoundLongitude", null, null));
            double d2 = Double.parseDouble(WMSImagery.getChildContent(element3, "northBoundLatitude", null, null));
            double d3 = Double.parseDouble(WMSImagery.getChildContent(element3, "eastBoundLongitude", null, null));
            double d4 = Double.parseDouble(WMSImagery.getChildContent(element3, "southBoundLatitude", null, null));
            object3 = new Bounds(d4, d, d2, d3);
        } else {
            Element element4 = WMSImagery.getChild(element2, "LatLonBoundingBox");
            if (element4 != null) {
                d = WMSImagery.getDecimalDegree(element4, "minx");
                double d5 = WMSImagery.getDecimalDegree(element4, "maxy");
                double d6 = WMSImagery.getDecimalDegree(element4, "maxx");
                double d7 = WMSImagery.getDecimalDegree(element4, "miny");
                object3 = new Bounds(d7, d, d5, d6);
            }
        }
        List<Element> list = WMSImagery.getChildren(element2, "Layer");
        List<LayerDetails> list2 = this.parseLayers(list, hashSet);
        return new LayerDetails(string2, string3, (Set<String>)hashSet, bl, (Bounds)object3, list2);
    }

    private static double getDecimalDegree(Element element, String string) {
        return Double.parseDouble(element.getAttribute(string).replace(',', '.'));
    }

    private static boolean isProjSupported(String string) {
        return Projections.getProjectionByCode(string) != null;
    }

    private static String getChildContent(Element element, String string, String string2, String string3) {
        Element element2 = WMSImagery.getChild(element, string);
        if (element2 == null) {
            return string2;
        }
        String string4 = (String)WMSImagery.getContent(element2);
        return !string4.isEmpty() ? string4 : string3;
    }

    private static Object getContent(Element element) {
        NodeList nodeList = element.getChildNodes();
        StringBuilder stringBuilder = new StringBuilder();
        block4: for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            switch (node.getNodeType()) {
                case 1: {
                    return node;
                }
                case 3: 
                case 4: {
                    stringBuilder.append(node.getNodeValue());
                    continue block4;
                }
            }
        }
        return stringBuilder.toString().trim();
    }

    private static Stream<Element> getChildrenStream(Element element) {
        if (element == null) {
            return Stream.empty();
        }
        Iterable iterable = () -> new ChildIterator(element);
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    private static Stream<Element> getChildrenStream(Element element2, String string) {
        return WMSImagery.getChildrenStream(element2).filter(element -> string.equals(element.getNodeName()));
    }

    private static List<Element> getChildren(Element element, String string) {
        return WMSImagery.getChildrenStream(element, string).collect(Collectors.toList());
    }

    private static Element getChild(Element element, String string) {
        return WMSImagery.getChildrenStream(element, string).findFirst().orElse(null);
    }

    public static class LayerDetails {
        public final String name;
        public final String ident;
        public final List<LayerDetails> children;
        public final Bounds bounds;
        public final Set<String> crsList;
        public final boolean supported;

        public LayerDetails(String string, String string2, Set<String> set, boolean bl, Bounds bounds, List<LayerDetails> list) {
            this.name = string;
            this.ident = string2;
            this.supported = bl;
            this.children = list;
            this.bounds = bounds;
            this.crsList = set;
        }

        public boolean isSupported() {
            return this.supported;
        }

        public Set<String> getProjections() {
            return this.crsList;
        }

        public String toString() {
            if (this.name == null || this.name.isEmpty()) {
                return this.ident;
            }
            return this.name;
        }
    }

    public static class WMSGetCapabilitiesException
    extends Exception {
        private final String incomingData;

        public WMSGetCapabilitiesException(Throwable throwable, String string) {
            super(throwable);
            this.incomingData = string;
        }

        public WMSGetCapabilitiesException(String string, String string2) {
            super(string);
            this.incomingData = string2;
        }

        public String getIncomingData() {
            return this.incomingData;
        }
    }

    private static final class ChildIterator
    implements Iterator<Element> {
        private Element child;

        ChildIterator(Element element) {
            this.child = ChildIterator.advanceToElement(element.getFirstChild());
        }

        private static Element advanceToElement(Node node) {
            Node node2;
            for (node2 = node; node2 != null && !(node2 instanceof Element); node2 = node2.getNextSibling()) {
            }
            return (Element)node2;
        }

        @Override
        public boolean hasNext() {
            return this.child != null;
        }

        @Override
        public Element next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No next sibling.");
            }
            Element element = this.child;
            this.child = ChildIterator.advanceToElement(this.child.getNextSibling());
            return element;
        }
    }
}

