/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resources;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.gradle.api.Action;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.gradle.internal.resources.ResourceLockRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResourceLockRegistry<T extends ResourceLock>
implements ResourceLockRegistry {
    private final Cache<String, T> resourceLocks = CacheBuilder.newBuilder().weakValues().build();
    private final Multimap<Long, ResourceLock> threadResourceLockMap = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());
    private final ResourceLockCoordinationService coordinationService;

    public AbstractResourceLockRegistry(ResourceLockCoordinationService coordinationService) {
        this.coordinationService = coordinationService;
    }

    protected T getOrRegisterResourceLock(final String displayName, final ResourceLockProducer<T> producer) {
        try {
            return (T)((ResourceLock)this.resourceLocks.get((Object)displayName, new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return producer.create(displayName, AbstractResourceLockRegistry.this.coordinationService, AbstractResourceLockRegistry.this.getLockAction(), AbstractResourceLockRegistry.this.getUnlockAction());
                }
            }));
        }
        catch (ExecutionException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    @Override
    public Collection<? extends ResourceLock> getResourceLocksByCurrentThread() {
        Long threadId = Thread.currentThread().getId();
        return ImmutableList.copyOf((Collection)this.threadResourceLockMap.get((Object)threadId));
    }

    @Override
    public boolean hasOpenLocks() {
        for (ResourceLock resourceLock : this.resourceLocks.asMap().values()) {
            if (!resourceLock.isLocked()) continue;
            return true;
        }
        return false;
    }

    private Action<ResourceLock> getLockAction() {
        return new Action<ResourceLock>(){

            @Override
            public void execute(ResourceLock resourceLock) {
                AbstractResourceLockRegistry.this.threadResourceLockMap.put((Object)Thread.currentThread().getId(), (Object)resourceLock);
            }
        };
    }

    private Action<ResourceLock> getUnlockAction() {
        return new Action<ResourceLock>(){

            @Override
            public void execute(ResourceLock resourceLock) {
                AbstractResourceLockRegistry.this.threadResourceLockMap.remove((Object)Thread.currentThread().getId(), (Object)resourceLock);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ResourceLockProducer<T extends ResourceLock> {
        public T create(String var1, ResourceLockCoordinationService var2, Action<ResourceLock> var3, Action<ResourceLock> var4);
    }
}

